/*
 * Decompiled with CFR 0.152.
 */
package org.jzy3d.plot3d.builder.delaunay.jdt;

import java.awt.Point;
import java.util.Iterator;
import org.jzy3d.plot3d.builder.delaunay.jdt.BoundingBox;
import org.jzy3d.plot3d.builder.delaunay.jdt.Delaunay_Triangulation;
import org.jzy3d.plot3d.builder.delaunay.jdt.Point_dt;
import org.jzy3d.plot3d.builder.delaunay.jdt.Triangle_dt;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GridIndex {
    private Delaunay_Triangulation indexDelaunay;
    private double x_size;
    private double y_size;
    private BoundingBox indexRegion;
    private Triangle_dt[][] grid;

    public GridIndex(Delaunay_Triangulation delaunay, int xCellCount, int yCellCount) {
        this(delaunay, xCellCount, yCellCount, delaunay.getBoundingBox());
    }

    public GridIndex(Delaunay_Triangulation delaunay, int xCellCount, int yCellCount, BoundingBox region) {
        this.init(delaunay, xCellCount, yCellCount, region);
    }

    private void init(Delaunay_Triangulation delaunay, int xCellCount, int yCellCount, BoundingBox region) {
        this.indexDelaunay = delaunay;
        this.indexRegion = region;
        this.x_size = region.getWidth() / (double)yCellCount;
        this.y_size = region.getHeight() / (double)xCellCount;
        this.grid = new Triangle_dt[xCellCount][yCellCount];
        Triangle_dt colStartTriangle = this.indexDelaunay.find(this.middleOfCell(0, 0));
        this.updateCellValues(0, 0, xCellCount - 1, yCellCount - 1, colStartTriangle);
    }

    public Triangle_dt findCellTriangleOf(Point_dt point) {
        int x_index = (int)((point.x() - this.indexRegion.minX()) / this.x_size);
        int y_index = (int)((point.y() - this.indexRegion.minY()) / this.y_size);
        return this.grid[x_index][y_index];
    }

    public void updateIndex(Iterator<Triangle_dt> updatedTriangles) {
        BoundingBox updatedRegion = new BoundingBox();
        while (updatedTriangles.hasNext()) {
            updatedRegion = updatedRegion.unionWith(updatedTriangles.next().getBoundingBox());
        }
        if (updatedRegion.isNull()) {
            return;
        }
        if (!this.indexRegion.contains(updatedRegion)) {
            this.init(this.indexDelaunay, (int)(this.indexRegion.getWidth() / this.x_size), (int)(this.indexRegion.getHeight() / this.y_size), this.indexRegion.unionWith(updatedRegion));
        } else {
            Point minInvalidCell = this.getCellOf(updatedRegion.getMinPoint());
            Point maxInvalidCell = this.getCellOf(updatedRegion.getMaxPoint());
            Triangle_dt adjacentValidTriangle = this.findValidTriangle(minInvalidCell);
            this.updateCellValues(minInvalidCell.x, minInvalidCell.y, maxInvalidCell.x, maxInvalidCell.y, adjacentValidTriangle);
        }
    }

    private void updateCellValues(int startXCell, int startYCell, int lastXCell, int lastYCell, Triangle_dt startTriangle) {
        for (int i = startXCell; i <= lastXCell; ++i) {
            this.grid[i][startYCell] = startTriangle = this.indexDelaunay.find(this.middleOfCell(i, startYCell), startTriangle);
            Triangle_dt prevRowTriangle = startTriangle;
            for (int j = startYCell + 1; j <= lastYCell; ++j) {
                this.grid[i][j] = this.indexDelaunay.find(this.middleOfCell(i, j), prevRowTriangle);
                prevRowTriangle = this.grid[i][j];
            }
        }
    }

    private Triangle_dt findValidTriangle(Point minInvalidCell) {
        if (minInvalidCell.x == 0 && minInvalidCell.y == 0) {
            return this.indexDelaunay.find(this.middleOfCell(minInvalidCell.x, minInvalidCell.y), null);
        }
        return this.grid[Math.min(0, minInvalidCell.x)][Math.min(0, minInvalidCell.y)];
    }

    private Point getCellOf(Point_dt coordinate) {
        int xCell = (int)((coordinate.x() - this.indexRegion.minX()) / this.x_size);
        int yCell = (int)((coordinate.y() - this.indexRegion.minY()) / this.y_size);
        return new Point(xCell, yCell);
    }

    private Point_dt middleOfCell(int x_index, int y_index) {
        double middleXCell = this.indexRegion.minX() + (double)x_index * this.x_size + this.x_size / 2.0;
        double middleYCell = this.indexRegion.minY() + (double)y_index * this.y_size + this.y_size / 2.0;
        return new Point_dt(middleXCell, middleYCell);
    }
}

