/*
 * Decompiled with CFR 0.152.
 */
package org.jzy3d.plot3d.primitives;

import org.jzy3d.colors.IMultiColorable;
import org.jzy3d.colors.ISingleColorable;
import org.jzy3d.maths.BoundingBox3d;
import org.jzy3d.maths.Coord3d;
import org.jzy3d.plot3d.primitives.AbstractComposite;
import org.jzy3d.plot3d.primitives.Point;
import org.jzy3d.plot3d.primitives.Polygon;
import org.jzy3d.plot3d.primitives.SimplePolygon;

public class CompositeParallelepiped
extends AbstractComposite
implements ISingleColorable,
IMultiColorable {
    protected Polygon[] quads;
    protected PolygonType type = PolygonType.CULLED;

    public CompositeParallelepiped() {
        this(PolygonType.CULLED);
    }

    public CompositeParallelepiped(PolygonType type) {
        this.type = type;
    }

    public CompositeParallelepiped(BoundingBox3d b) {
        this(b, PolygonType.CULLED);
    }

    public CompositeParallelepiped(BoundingBox3d b, PolygonType type) {
        this.setData(b);
    }

    public void setData(BoundingBox3d box) {
        if (this.bbox == null) {
            this.bbox = box;
        } else {
            this.bbox.reset();
            this.bbox.add(box);
        }
        this.quads = new Polygon[6];
        this.quads[0] = this.createPolygon();
        this.quads[0].add(new Point(new Coord3d(this.bbox.getXmax(), this.bbox.getYmin(), this.bbox.getZmax())));
        this.quads[0].add(new Point(new Coord3d(this.bbox.getXmax(), this.bbox.getYmin(), this.bbox.getZmin())));
        this.quads[0].add(new Point(new Coord3d(this.bbox.getXmax(), this.bbox.getYmax(), this.bbox.getZmin())));
        this.quads[0].add(new Point(new Coord3d(this.bbox.getXmax(), this.bbox.getYmax(), this.bbox.getZmax())));
        this.quads[1] = this.createPolygon();
        this.quads[1].add(new Point(new Coord3d(this.bbox.getXmin(), this.bbox.getYmax(), this.bbox.getZmax())));
        this.quads[1].add(new Point(new Coord3d(this.bbox.getXmin(), this.bbox.getYmax(), this.bbox.getZmin())));
        this.quads[1].add(new Point(new Coord3d(this.bbox.getXmin(), this.bbox.getYmin(), this.bbox.getZmin())));
        this.quads[1].add(new Point(new Coord3d(this.bbox.getXmin(), this.bbox.getYmin(), this.bbox.getZmax())));
        this.quads[2] = this.createPolygon();
        this.quads[2].add(new Point(new Coord3d(this.bbox.getXmax(), this.bbox.getYmax(), this.bbox.getZmax())));
        this.quads[2].add(new Point(new Coord3d(this.bbox.getXmax(), this.bbox.getYmax(), this.bbox.getZmin())));
        this.quads[2].add(new Point(new Coord3d(this.bbox.getXmin(), this.bbox.getYmax(), this.bbox.getZmin())));
        this.quads[2].add(new Point(new Coord3d(this.bbox.getXmin(), this.bbox.getYmax(), this.bbox.getZmax())));
        this.quads[3] = this.createPolygon();
        this.quads[3].add(new Point(new Coord3d(this.bbox.getXmin(), this.bbox.getYmin(), this.bbox.getZmax())));
        this.quads[3].add(new Point(new Coord3d(this.bbox.getXmin(), this.bbox.getYmin(), this.bbox.getZmin())));
        this.quads[3].add(new Point(new Coord3d(this.bbox.getXmax(), this.bbox.getYmin(), this.bbox.getZmin())));
        this.quads[3].add(new Point(new Coord3d(this.bbox.getXmax(), this.bbox.getYmin(), this.bbox.getZmax())));
        this.quads[4] = this.createPolygon();
        this.quads[4].add(new Point(new Coord3d(this.bbox.getXmin(), this.bbox.getYmin(), this.bbox.getZmax())));
        this.quads[4].add(new Point(new Coord3d(this.bbox.getXmax(), this.bbox.getYmin(), this.bbox.getZmax())));
        this.quads[4].add(new Point(new Coord3d(this.bbox.getXmax(), this.bbox.getYmax(), this.bbox.getZmax())));
        this.quads[4].add(new Point(new Coord3d(this.bbox.getXmin(), this.bbox.getYmax(), this.bbox.getZmax())));
        this.quads[5] = this.createPolygon();
        this.quads[5].add(new Point(new Coord3d(this.bbox.getXmax(), this.bbox.getYmin(), this.bbox.getZmin())));
        this.quads[5].add(new Point(new Coord3d(this.bbox.getXmin(), this.bbox.getYmin(), this.bbox.getZmin())));
        this.quads[5].add(new Point(new Coord3d(this.bbox.getXmin(), this.bbox.getYmax(), this.bbox.getZmin())));
        this.quads[5].add(new Point(new Coord3d(this.bbox.getXmax(), this.bbox.getYmax(), this.bbox.getZmin())));
        for (Polygon p : this.quads) {
            this.add(p);
        }
    }

    protected Polygon createPolygon() {
        if (this.type == PolygonType.CULLED) {
            return new Polygon();
        }
        if (this.type == PolygonType.SIMPLE) {
            return new SimplePolygon();
        }
        throw new RuntimeException("unknown polygon type: " + (Object)((Object)this.type));
    }

    public void setPolygonOffsetFill(boolean value) {
        for (Polygon polygon : this.quads) {
            polygon.setPolygonOffsetFillEnable(value);
        }
    }

    public void setPolygonMode(Polygon.PolygonMode mode) {
        for (Polygon polygon : this.quads) {
            polygon.setPolygonMode(mode);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum PolygonType {
        SIMPLE,
        CULLED;

    }
}

