/*
 * Decompiled with CFR 0.152.
 */
package org.jzy3d.plot3d.primitives;

import java.util.ArrayList;
import java.util.List;
import javax.media.opengl.GL2;
import javax.media.opengl.glu.GLU;
import org.jzy3d.maths.BoundingBox3d;
import org.jzy3d.maths.Coord3d;
import org.jzy3d.maths.Utils;
import org.jzy3d.plot3d.primitives.AbstractWireframeable;
import org.jzy3d.plot3d.primitives.Point;
import org.jzy3d.plot3d.rendering.view.Camera;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LineStrip
extends AbstractWireframeable {
    protected List<Point> points;
    protected float width;

    public LineStrip() {
        this(2);
    }

    public LineStrip(int n) {
        this.points = new ArrayList<Point>(n);
        this.bbox = new BoundingBox3d();
        this.setWireframeColor(null);
    }

    public LineStrip(List<Coord3d> coords) {
        this();
        for (Coord3d c : coords) {
            Point p = new Point(c);
            this.add(p);
        }
    }

    @Override
    public void draw(GL2 gl, GLU glu, Camera cam) {
        if (this.transform != null) {
            this.transform.execute(gl);
        }
        gl.glLineWidth(this.width);
        gl.glBegin(3);
        if (this.wfcolor == null) {
            for (Point p : this.points) {
                gl.glColor4f(p.rgb.r, p.rgb.g, p.rgb.b, p.rgb.a);
                gl.glVertex3f(p.xyz.x, p.xyz.y, p.xyz.z);
            }
        } else {
            for (Point p : this.points) {
                gl.glColor4f(this.wfcolor.r, this.wfcolor.g, this.wfcolor.b, this.wfcolor.a);
                gl.glVertex3f(p.xyz.x, p.xyz.y, p.xyz.z);
            }
        }
        for (Point p : this.points) {
            if (this.wfcolor == null) {
                gl.glColor4f(p.rgb.r, p.rgb.g, p.rgb.b, p.rgb.a);
            } else {
                gl.glColor4f(this.wfcolor.r, this.wfcolor.g, this.wfcolor.b, this.wfcolor.a);
            }
            gl.glVertex3f(p.xyz.x, p.xyz.y, p.xyz.z);
        }
        gl.glEnd();
    }

    public void add(Point point) {
        this.points.add(point);
        this.bbox.add(point);
    }

    public void addAll(List<Point> points) {
        for (Point p : points) {
            this.add(p);
        }
    }

    public void addAll(LineStrip strip) {
        this.addAll(strip.getPoints());
    }

    public Point get(int p) {
        return this.points.get(p);
    }

    public List<Point> getPoints() {
        return this.points;
    }

    public int size() {
        return this.points.size();
    }

    public void setWidth(float width) {
        this.width = width;
    }

    @Override
    public double getDistance(Camera camera) {
        return this.getBarycentre().distance(camera.getEye());
    }

    @Override
    public double getShortestDistance(Camera camera) {
        double min = 3.4028234663852886E38;
        double dist = 0.0;
        for (Point point : this.points) {
            dist = point.getDistance(camera);
            if (!(dist < min)) continue;
            min = dist;
        }
        return min;
    }

    @Override
    public double getLongestDistance(Camera camera) {
        double max = 0.0;
        double dist = 0.0;
        for (Point point : this.points) {
            dist = point.getDistance(camera);
            if (!(dist < max)) continue;
            max = dist;
        }
        return max;
    }

    public static LineStrip merge(LineStrip strip1, LineStrip strip2) {
        double da;
        Coord3d a = strip1.get((int)0).xyz;
        Coord3d b = strip1.get((int)(strip1.size() - 1)).xyz;
        Coord3d c = strip2.get((int)0).xyz;
        Coord3d d = strip2.get((int)(strip2.size() - 1)).xyz;
        double bc = b.distance(c);
        if (bc > (da = d.distance(a))) {
            strip1.addAll(strip2);
            return strip1;
        }
        strip2.addAll(strip1);
        return strip2;
    }

    @Override
    public String toString(int depth) {
        return Utils.blanks(depth) + "(LineStrip) #points:" + this.points.size();
    }
}

