/*
 * Decompiled with CFR 0.152.
 */
package org.jzy3d.plot3d.primitives;

import java.util.List;
import javax.media.opengl.GL2;
import javax.media.opengl.glu.GLU;
import org.jzy3d.colors.Color;
import org.jzy3d.colors.ColorMapper;
import org.jzy3d.colors.IMultiColorable;
import org.jzy3d.maths.BoundingBox3d;
import org.jzy3d.maths.Coord3d;
import org.jzy3d.plot3d.primitives.AbstractDrawable;
import org.jzy3d.plot3d.primitives.axes.layout.providers.ITickProvider;
import org.jzy3d.plot3d.primitives.axes.layout.renderers.ITickRenderer;
import org.jzy3d.plot3d.rendering.legends.colorbars.ColorbarLegend;
import org.jzy3d.plot3d.rendering.view.Camera;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultiColorScatterList
extends AbstractDrawable
implements IMultiColorable {
    protected List<Coord3d> coordinates;
    protected float width;
    protected ColorMapper mapper;

    public MultiColorScatterList(List<Coord3d> coordinates, ColorMapper mapper) {
        this(coordinates, mapper, 1.0f);
    }

    public MultiColorScatterList(List<Coord3d> coordinates, ColorMapper mapper, float width) {
        this.bbox = new BoundingBox3d();
        this.setData(coordinates);
        this.setWidth(width);
        this.setColorMapper(mapper);
    }

    public void clear() {
        this.coordinates = null;
        this.bbox.reset();
    }

    public void enableColorBar(ITickProvider provider, ITickRenderer renderer) {
        this.setLegend(new ColorbarLegend((AbstractDrawable)this, provider, renderer));
        this.setLegendDisplayed(true);
    }

    @Override
    public void draw(GL2 gl, GLU glu, Camera cam) {
        if (this.transform != null) {
            this.transform.execute(gl);
        }
        gl.glPointSize(this.width);
        gl.glBegin(0);
        if (this.coordinates != null) {
            for (Coord3d coord : this.coordinates) {
                Color color = this.mapper.getColor(coord);
                gl.glColor4f(color.r, color.g, color.b, color.a);
                gl.glVertex3f(coord.x, coord.y, coord.z);
            }
        }
        gl.glEnd();
    }

    public void setData(List<Coord3d> coordinates) {
        this.coordinates = coordinates;
        this.bbox.reset();
        for (Coord3d c : coordinates) {
            this.bbox.add(c);
        }
    }

    public List<Coord3d> getData() {
        return this.coordinates;
    }

    @Override
    public ColorMapper getColorMapper() {
        return this.mapper;
    }

    @Override
    public void setColorMapper(ColorMapper mapper) {
        this.mapper = mapper;
    }

    public void setWidth(float width) {
        this.width = width;
    }
}

