/*
 * Decompiled with CFR 0.152.
 */
package org.jzy3d.plot3d.primitives.axes;

import javax.media.opengl.GL2;
import javax.media.opengl.glu.GLU;
import org.jzy3d.maths.BoundingBox3d;
import org.jzy3d.maths.Coord3d;
import org.jzy3d.plot3d.primitives.axes.IAxe;
import org.jzy3d.plot3d.primitives.axes.layout.IAxeLayout;
import org.jzy3d.plot3d.rendering.view.Camera;

public class AxeBase
implements IAxe {
    protected Coord3d scale;
    protected BoundingBox3d bbox;
    protected IAxeLayout layout;

    public AxeBase() {
        this.setAxe(new BoundingBox3d(0.0f, 1.0f, 0.0f, 1.0f, 0.0f, 1.0f));
        this.setScale(new Coord3d(1.0f, 1.0f, 1.0f));
    }

    public AxeBase(BoundingBox3d box) {
        this.setAxe(box);
        this.setScale(new Coord3d(1.0f, 1.0f, 1.0f));
    }

    public void dispose() {
    }

    public void setAxe(BoundingBox3d box) {
        this.bbox = box;
    }

    public void draw(GL2 gl, GLU glu, Camera camera) {
        gl.glLoadIdentity();
        gl.glScalef(this.scale.x, this.scale.y, this.scale.z);
        gl.glLineWidth(2.0f);
        gl.glBegin(1);
        gl.glColor3f(1.0f, 0.0f, 0.0f);
        gl.glVertex3f(this.bbox.getXmin(), this.bbox.getYmin(), this.bbox.getZmin());
        gl.glVertex3f(this.bbox.getXmax(), 0.0f, 0.0f);
        gl.glColor3f(0.0f, 1.0f, 0.0f);
        gl.glVertex3f(this.bbox.getXmin(), this.bbox.getYmin(), this.bbox.getZmin());
        gl.glVertex3f(0.0f, this.bbox.getYmax(), 0.0f);
        gl.glColor3f(0.0f, 0.0f, 1.0f);
        gl.glVertex3f(this.bbox.getXmin(), this.bbox.getYmin(), this.bbox.getZmin());
        gl.glVertex3f(0.0f, 0.0f, this.bbox.getZmax());
        gl.glEnd();
    }

    public void setScale(Coord3d scale) {
        this.scale = scale;
    }

    public BoundingBox3d getBoxBounds() {
        return this.bbox;
    }

    public Coord3d getCenter() {
        return new Coord3d(this.bbox.getXmin(), this.bbox.getYmin(), this.bbox.getZmin());
    }

    public IAxeLayout getLayout() {
        return this.layout;
    }
}

