/*
 * Decompiled with CFR 0.152.
 */
package org.jzy3d.plot3d.primitives.axes;

import javax.media.opengl.GL;
import javax.media.opengl.GL2;
import javax.media.opengl.glu.GLU;
import org.jzy3d.colors.Color;
import org.jzy3d.maths.BoundingBox3d;
import org.jzy3d.maths.Coord3d;
import org.jzy3d.maths.Vector3d;
import org.jzy3d.plot3d.primitives.axes.IAxe;
import org.jzy3d.plot3d.primitives.axes.layout.AxeBoxLayout;
import org.jzy3d.plot3d.primitives.axes.layout.IAxeLayout;
import org.jzy3d.plot3d.rendering.canvas.ICanvas;
import org.jzy3d.plot3d.rendering.view.Camera;
import org.jzy3d.plot3d.rendering.view.View;
import org.jzy3d.plot3d.rendering.view.modes.ViewPositionMode;
import org.jzy3d.plot3d.text.ITextRenderer;
import org.jzy3d.plot3d.text.align.Halign;
import org.jzy3d.plot3d.text.align.Valign;
import org.jzy3d.plot3d.text.overlay.TextOverlay;
import org.jzy3d.plot3d.text.renderers.TextBitmapRenderer;

public class AxeBox
implements IAxe {
    protected static final int PRECISION = 6;
    protected View view;
    protected ITextRenderer txt = new TextBitmapRenderer();
    protected TextOverlay txtRenderer;
    protected IAxeLayout layout;
    protected BoundingBox3d boxBounds;
    protected BoundingBox3d wholeBounds;
    protected Coord3d center;
    protected Coord3d scale;
    protected float xrange;
    protected float yrange;
    protected float zrange;
    protected float[][] quadx;
    protected float[][] quady;
    protected float[][] quadz;
    protected float[] normx;
    protected float[] normy;
    protected float[] normz;
    protected float[][] axeXx;
    protected float[][] axeXy;
    protected float[][] axeXz;
    protected float[][] axeYx;
    protected float[][] axeYy;
    protected float[][] axeYz;
    protected float[][] axeZx;
    protected float[][] axeZy;
    protected float[][] axeZz;
    protected int[][] axeXquads;
    protected int[][] axeYquads;
    protected int[][] axeZquads;
    protected boolean[] quadIsHidden;
    protected static final int AXE_X = 0;
    protected static final int AXE_Y = 1;
    protected static final int AXE_Z = 2;

    public AxeBox(BoundingBox3d bbox) {
        this(bbox, new AxeBoxLayout());
    }

    public AxeBox(BoundingBox3d bbox, IAxeLayout layout) {
        this.layout = layout;
        if (bbox.valid()) {
            this.setAxe(bbox);
        } else {
            this.setAxe(new BoundingBox3d(-1.0f, 1.0f, -1.0f, 1.0f, -1.0f, 1.0f));
        }
        this.wholeBounds = new BoundingBox3d();
        this.init();
    }

    protected void init() {
        this.setScale(new Coord3d(1.0f, 1.0f, 1.0f));
    }

    public void dispose() {
        if (this.txtRenderer != null) {
            this.txtRenderer.dispose();
        }
    }

    public ITextRenderer getTextRenderer() {
        return this.txt;
    }

    public void setTextRenderer(ITextRenderer renderer) {
        this.txt = renderer;
    }

    public TextOverlay getExperimentalTextRenderer() {
        return this.txtRenderer;
    }

    public void setExperimentalTextOverlayRenderer(ICanvas canvas) {
        this.txtRenderer = new TextOverlay(canvas);
    }

    public View getView() {
        return this.view;
    }

    public void setView(View view) {
        this.view = view;
    }

    public void setAxe(BoundingBox3d bbox) {
        this.boxBounds = bbox;
        this.setAxeBox(bbox.getXmin(), bbox.getXmax(), bbox.getYmin(), bbox.getYmax(), bbox.getZmin(), bbox.getZmax());
    }

    public BoundingBox3d getBoxBounds() {
        return this.boxBounds;
    }

    public IAxeLayout getLayout() {
        return this.layout;
    }

    public BoundingBox3d getWholeBounds() {
        return this.wholeBounds;
    }

    public Coord3d getCenter() {
        return this.center;
    }

    public void setScale(Coord3d scale) {
        this.scale = scale;
    }

    public void draw(GL2 gl, GLU glu, Camera camera) {
        int zselect;
        BoundingBox3d bbox;
        gl.glLoadIdentity();
        gl.glScalef(this.scale.x, this.scale.y, this.scale.z);
        gl.glEnable(2884);
        gl.glFrontFace(2305);
        gl.glCullFace(1028);
        this.quadIsHidden = this.getHiddenQuads((GL)gl, camera);
        if (this.layout.isFaceDisplayed()) {
            Color quadcolor = this.layout.getQuadColor();
            gl.glPolygonMode(1029, 6914);
            gl.glColor4f(quadcolor.r, quadcolor.g, quadcolor.b, quadcolor.a);
            gl.glLineWidth(1.0f);
            gl.glEnable(32823);
            gl.glPolygonOffset(1.0f, 1.0f);
            this.drawCube(gl, 7168);
            gl.glDisable(32823);
        }
        Color gridcolor = this.layout.getGridColor();
        gl.glPolygonMode(1029, 6913);
        gl.glColor4f(gridcolor.r, gridcolor.g, gridcolor.b, gridcolor.a);
        gl.glLineWidth(1.0f);
        this.drawCube(gl, 7168);
        gl.glPolygonMode(1029, 6913);
        gl.glColor4f(gridcolor.r, gridcolor.g, gridcolor.b, gridcolor.a);
        gl.glLineWidth(1.0f);
        gl.glLineStipple(1, (short)-21846);
        gl.glEnable(2852);
        for (int quad = 0; quad < 6; ++quad) {
            if (this.quadIsHidden[quad]) continue;
            this.drawGridOnQuad(gl, quad);
        }
        gl.glDisable(2852);
        this.wholeBounds.reset();
        this.wholeBounds.add(this.boxBounds);
        if (this.xrange > 0.0f && this.layout.isXTickLabelDisplayed()) {
            if (this.view != null && this.view.getViewMode().equals((Object)ViewPositionMode.TOP)) {
                BoundingBox3d bbox2 = this.drawTicks(gl, glu, camera, 1, 0, this.layout.getXTickColor(), Halign.LEFT, Valign.TOP);
                this.wholeBounds.add(bbox2);
            } else {
                int xselect = this.findClosestXaxe(camera);
                if (xselect >= 0) {
                    bbox = this.drawTicks(gl, glu, camera, xselect, 0, this.layout.getXTickColor());
                    this.wholeBounds.add(bbox);
                } else {
                    bbox = this.drawTicks(gl, glu, camera, 2, 0, this.layout.getXTickColor(), Halign.CENTER, Valign.TOP);
                    this.wholeBounds.add(bbox);
                }
            }
        }
        if (this.yrange > 0.0f && this.layout.isYTickLabelDisplayed()) {
            if (this.view != null && this.view.getViewMode().equals((Object)ViewPositionMode.TOP)) {
                BoundingBox3d bbox3 = this.drawTicks(gl, glu, camera, 2, 1, this.layout.getYTickColor(), Halign.LEFT, Valign.GROUND);
                this.wholeBounds.add(bbox3);
            } else {
                int yselect = this.findClosestYaxe(camera);
                if (yselect >= 0) {
                    bbox = this.drawTicks(gl, glu, camera, yselect, 1, this.layout.getYTickColor());
                    this.wholeBounds.add(bbox);
                } else {
                    bbox = this.drawTicks(gl, glu, camera, 1, 1, this.layout.getYTickColor(), Halign.RIGHT, Valign.GROUND);
                    this.wholeBounds.add(bbox);
                }
            }
        }
        if (this.zrange > 0.0f && this.layout.isZTickLabelDisplayed() && (this.view == null || !this.view.getViewMode().equals((Object)ViewPositionMode.TOP)) && (zselect = this.findClosestZaxe(camera)) >= 0) {
            bbox = this.drawTicks(gl, glu, camera, zselect, 2, this.layout.getZTickColor());
            this.wholeBounds.add(bbox);
        }
        gl.glDisable(2884);
    }

    protected void setAxeBox(float xmin, float xmax, float ymin, float ymax, float zmin, float zmax) {
        this.center = new Coord3d((xmax + xmin) / 2.0f, (ymax + ymin) / 2.0f, (zmax + zmin) / 2.0f);
        this.xrange = xmax - xmin;
        this.yrange = ymax - ymin;
        this.zrange = zmax - zmin;
        this.quadx = new float[6][4];
        this.quady = new float[6][4];
        this.quadz = new float[6][4];
        this.quadx[0][0] = xmax;
        this.quady[0][0] = ymin;
        this.quadz[0][0] = zmax;
        this.quadx[0][1] = xmax;
        this.quady[0][1] = ymin;
        this.quadz[0][1] = zmin;
        this.quadx[0][2] = xmax;
        this.quady[0][2] = ymax;
        this.quadz[0][2] = zmin;
        this.quadx[0][3] = xmax;
        this.quady[0][3] = ymax;
        this.quadz[0][3] = zmax;
        this.quadx[1][0] = xmin;
        this.quady[1][0] = ymax;
        this.quadz[1][0] = zmax;
        this.quadx[1][1] = xmin;
        this.quady[1][1] = ymax;
        this.quadz[1][1] = zmin;
        this.quadx[1][2] = xmin;
        this.quady[1][2] = ymin;
        this.quadz[1][2] = zmin;
        this.quadx[1][3] = xmin;
        this.quady[1][3] = ymin;
        this.quadz[1][3] = zmax;
        this.quadx[2][0] = xmax;
        this.quady[2][0] = ymax;
        this.quadz[2][0] = zmax;
        this.quadx[2][1] = xmax;
        this.quady[2][1] = ymax;
        this.quadz[2][1] = zmin;
        this.quadx[2][2] = xmin;
        this.quady[2][2] = ymax;
        this.quadz[2][2] = zmin;
        this.quadx[2][3] = xmin;
        this.quady[2][3] = ymax;
        this.quadz[2][3] = zmax;
        this.quadx[3][0] = xmin;
        this.quady[3][0] = ymin;
        this.quadz[3][0] = zmax;
        this.quadx[3][1] = xmin;
        this.quady[3][1] = ymin;
        this.quadz[3][1] = zmin;
        this.quadx[3][2] = xmax;
        this.quady[3][2] = ymin;
        this.quadz[3][2] = zmin;
        this.quadx[3][3] = xmax;
        this.quady[3][3] = ymin;
        this.quadz[3][3] = zmax;
        this.quadx[4][0] = xmin;
        this.quady[4][0] = ymin;
        this.quadz[4][0] = zmax;
        this.quadx[4][1] = xmax;
        this.quady[4][1] = ymin;
        this.quadz[4][1] = zmax;
        this.quadx[4][2] = xmax;
        this.quady[4][2] = ymax;
        this.quadz[4][2] = zmax;
        this.quadx[4][3] = xmin;
        this.quady[4][3] = ymax;
        this.quadz[4][3] = zmax;
        this.quadx[5][0] = xmax;
        this.quady[5][0] = ymin;
        this.quadz[5][0] = zmin;
        this.quadx[5][1] = xmin;
        this.quady[5][1] = ymin;
        this.quadz[5][1] = zmin;
        this.quadx[5][2] = xmin;
        this.quady[5][2] = ymax;
        this.quadz[5][2] = zmin;
        this.quadx[5][3] = xmax;
        this.quady[5][3] = ymax;
        this.quadz[5][3] = zmin;
        this.normx = new float[6];
        this.normy = new float[6];
        this.normz = new float[6];
        this.normx[0] = xmax;
        this.normy[0] = 0.0f;
        this.normz[0] = 0.0f;
        this.normx[1] = xmin;
        this.normy[1] = 0.0f;
        this.normz[1] = 0.0f;
        this.normx[2] = 0.0f;
        this.normy[2] = ymax;
        this.normz[2] = 0.0f;
        this.normx[3] = 0.0f;
        this.normy[3] = ymin;
        this.normz[3] = 0.0f;
        this.normx[4] = 0.0f;
        this.normy[4] = 0.0f;
        this.normz[4] = zmax;
        this.normx[5] = 0.0f;
        this.normy[5] = 0.0f;
        this.normz[5] = zmin;
        int na = 4;
        int np = 2;
        int nq = 2;
        this.axeXquads = new int[na][nq];
        this.axeYquads = new int[na][nq];
        this.axeZquads = new int[na][nq];
        int i = 0;
        this.axeXquads[i][0] = 4;
        this.axeXquads[i][1] = 3;
        i = 1;
        this.axeXquads[i][0] = 3;
        this.axeXquads[i][1] = 5;
        i = 2;
        this.axeXquads[i][0] = 5;
        this.axeXquads[i][1] = 2;
        i = 3;
        this.axeXquads[i][0] = 2;
        this.axeXquads[i][1] = 4;
        i = 0;
        this.axeYquads[i][0] = 4;
        this.axeYquads[i][1] = 0;
        i = 1;
        this.axeYquads[i][0] = 0;
        this.axeYquads[i][1] = 5;
        i = 2;
        this.axeYquads[i][0] = 5;
        this.axeYquads[i][1] = 1;
        i = 3;
        this.axeYquads[i][0] = 1;
        this.axeYquads[i][1] = 4;
        i = 0;
        this.axeZquads[i][0] = 3;
        this.axeZquads[i][1] = 0;
        i = 1;
        this.axeZquads[i][0] = 0;
        this.axeZquads[i][1] = 2;
        i = 2;
        this.axeZquads[i][0] = 2;
        this.axeZquads[i][1] = 1;
        i = 3;
        this.axeZquads[i][0] = 1;
        this.axeZquads[i][1] = 3;
        this.axeXx = new float[na][np];
        this.axeXy = new float[na][np];
        this.axeXz = new float[na][np];
        this.axeYx = new float[na][np];
        this.axeYy = new float[na][np];
        this.axeYz = new float[na][np];
        this.axeZx = new float[na][np];
        this.axeZy = new float[na][np];
        this.axeZz = new float[na][np];
        i = 0;
        this.axeXx[i][0] = xmin;
        this.axeXy[i][0] = ymin;
        this.axeXz[i][0] = zmax;
        this.axeXx[i][1] = xmax;
        this.axeXy[i][1] = ymin;
        this.axeXz[i][1] = zmax;
        i = 1;
        this.axeXx[i][0] = xmin;
        this.axeXy[i][0] = ymin;
        this.axeXz[i][0] = zmin;
        this.axeXx[i][1] = xmax;
        this.axeXy[i][1] = ymin;
        this.axeXz[i][1] = zmin;
        i = 2;
        this.axeXx[i][0] = xmin;
        this.axeXy[i][0] = ymax;
        this.axeXz[i][0] = zmin;
        this.axeXx[i][1] = xmax;
        this.axeXy[i][1] = ymax;
        this.axeXz[i][1] = zmin;
        i = 3;
        this.axeXx[i][0] = xmin;
        this.axeXy[i][0] = ymax;
        this.axeXz[i][0] = zmax;
        this.axeXx[i][1] = xmax;
        this.axeXy[i][1] = ymax;
        this.axeXz[i][1] = zmax;
        i = 0;
        this.axeYx[i][0] = xmax;
        this.axeYy[i][0] = ymin;
        this.axeYz[i][0] = zmax;
        this.axeYx[i][1] = xmax;
        this.axeYy[i][1] = ymax;
        this.axeYz[i][1] = zmax;
        i = 1;
        this.axeYx[i][0] = xmax;
        this.axeYy[i][0] = ymin;
        this.axeYz[i][0] = zmin;
        this.axeYx[i][1] = xmax;
        this.axeYy[i][1] = ymax;
        this.axeYz[i][1] = zmin;
        i = 2;
        this.axeYx[i][0] = xmin;
        this.axeYy[i][0] = ymin;
        this.axeYz[i][0] = zmin;
        this.axeYx[i][1] = xmin;
        this.axeYy[i][1] = ymax;
        this.axeYz[i][1] = zmin;
        i = 3;
        this.axeYx[i][0] = xmin;
        this.axeYy[i][0] = ymin;
        this.axeYz[i][0] = zmax;
        this.axeYx[i][1] = xmin;
        this.axeYy[i][1] = ymax;
        this.axeYz[i][1] = zmax;
        i = 0;
        this.axeZx[i][0] = xmax;
        this.axeZy[i][0] = ymin;
        this.axeZz[i][0] = zmin;
        this.axeZx[i][1] = xmax;
        this.axeZy[i][1] = ymin;
        this.axeZz[i][1] = zmax;
        i = 1;
        this.axeZx[i][0] = xmax;
        this.axeZy[i][0] = ymax;
        this.axeZz[i][0] = zmin;
        this.axeZx[i][1] = xmax;
        this.axeZy[i][1] = ymax;
        this.axeZz[i][1] = zmax;
        i = 2;
        this.axeZx[i][0] = xmin;
        this.axeZy[i][0] = ymax;
        this.axeZz[i][0] = zmin;
        this.axeZx[i][1] = xmin;
        this.axeZy[i][1] = ymax;
        this.axeZz[i][1] = zmax;
        i = 3;
        this.axeZx[i][0] = xmin;
        this.axeZy[i][0] = ymin;
        this.axeZz[i][0] = zmin;
        this.axeZx[i][1] = xmin;
        this.axeZy[i][1] = ymin;
        this.axeZz[i][1] = zmax;
        this.layout.getXTicks(xmin, xmax);
        this.layout.getYTicks(ymin, ymax);
        this.layout.getZTicks(zmin, zmax);
    }

    protected void drawCube(GL2 gl, int mode) {
        for (int q = 0; q < 6; ++q) {
            if (mode == 7169) {
                gl.glPassThrough((float)q);
            }
            gl.glBegin(7);
            for (int v = 0; v < 4; ++v) {
                gl.glVertex3f(this.quadx[q][v], this.quady[q][v], this.quadz[q][v]);
            }
            gl.glEnd();
        }
    }

    protected void drawGridOnQuad(GL2 gl, int quad) {
        int t;
        if (quad != 0 && quad != 1) {
            float[] xticks = this.layout.getXTicks();
            for (t = 0; t < xticks.length; ++t) {
                gl.glBegin(1);
                gl.glVertex3f(xticks[t], this.quady[quad][0], this.quadz[quad][0]);
                gl.glVertex3f(xticks[t], this.quady[quad][2], this.quadz[quad][2]);
                gl.glEnd();
            }
        }
        if (quad != 2 && quad != 3) {
            float[] yticks = this.layout.getYTicks();
            for (t = 0; t < yticks.length; ++t) {
                gl.glBegin(1);
                gl.glVertex3f(this.quadx[quad][0], yticks[t], this.quadz[quad][0]);
                gl.glVertex3f(this.quadx[quad][2], yticks[t], this.quadz[quad][2]);
                gl.glEnd();
            }
        }
        if (quad != 4 && quad != 5) {
            float[] zticks = this.layout.getZTicks();
            for (t = 0; t < zticks.length; ++t) {
                gl.glBegin(1);
                gl.glVertex3f(this.quadx[quad][0], this.quady[quad][0], zticks[t]);
                gl.glVertex3f(this.quadx[quad][2], this.quady[quad][2], zticks[t]);
                gl.glEnd();
            }
        }
    }

    protected BoundingBox3d drawTicks(GL2 gl, GLU glu, Camera cam, int axis, int direction, Color color) {
        return this.drawTicks(gl, glu, cam, axis, direction, color, null, null);
    }

    protected BoundingBox3d drawTicks(GL2 gl, GLU glu, Camera cam, int axis, int direction, Color color, Halign hal, Valign val) {
        String axeLabel;
        float zlab;
        float ylab;
        float xlab;
        int quad_1;
        int quad_0;
        float tickLength = 20.0f;
        float axeLabelDist = 2.5f;
        BoundingBox3d ticksTxtBounds = new BoundingBox3d();
        if (direction == 0) {
            quad_0 = this.axeXquads[axis][0];
            quad_1 = this.axeXquads[axis][1];
        } else if (direction == 1) {
            quad_0 = this.axeYquads[axis][0];
            quad_1 = this.axeYquads[axis][1];
        } else {
            quad_0 = this.axeZquads[axis][0];
            quad_1 = this.axeZquads[axis][1];
        }
        float xpos = this.normx[quad_0] + this.normx[quad_1];
        float ypos = this.normy[quad_0] + this.normy[quad_1];
        float zpos = this.normz[quad_0] + this.normz[quad_1];
        float xdir = this.normx[quad_0] + this.normx[quad_1] - this.center.x;
        float ydir = this.normy[quad_0] + this.normy[quad_1] - this.center.y;
        float zdir = this.normz[quad_0] + this.normz[quad_1] - this.center.z;
        xdir = xdir == 0.0f ? 0.0f : xdir / Math.abs(xdir);
        ydir = ydir == 0.0f ? 0.0f : ydir / Math.abs(ydir);
        zdir = zdir == 0.0f ? 0.0f : zdir / Math.abs(zdir);
        boolean dist = true;
        if (direction == 0) {
            xlab = this.center.x;
            ylab = axeLabelDist * (this.yrange / tickLength) * (float)dist * ydir + ypos;
            zlab = axeLabelDist * (this.zrange / tickLength) * (float)dist * zdir + zpos;
            axeLabel = this.layout.getXAxeLabel();
        } else if (direction == 1) {
            xlab = axeLabelDist * (this.xrange / tickLength) * (float)dist * xdir + xpos;
            ylab = this.center.y;
            zlab = axeLabelDist * (this.zrange / tickLength) * (float)dist * zdir + zpos;
            axeLabel = this.layout.getYAxeLabel();
        } else {
            xlab = axeLabelDist * (this.xrange / tickLength) * (float)dist * xdir + xpos;
            ylab = axeLabelDist * (this.yrange / tickLength) * (float)dist * ydir + ypos;
            zlab = this.center.z;
            axeLabel = this.layout.getZAxeLabel();
        }
        if (direction == 0 && this.layout.isXAxeLabelDisplayed() || direction == 1 && this.layout.isYAxeLabelDisplayed() || direction == 2 && this.layout.isZAxeLabelDisplayed()) {
            Coord3d labelPosition = new Coord3d(xlab, ylab, zlab);
            if (this.txtRenderer != null) {
                this.txtRenderer.appendText(gl, glu, cam, axeLabel, labelPosition, Halign.CENTER, Valign.CENTER, color);
            } else {
                BoundingBox3d labelBounds = this.txt.drawText(gl, glu, cam, axeLabel, labelPosition, Halign.CENTER, Valign.CENTER, color);
                if (labelBounds != null) {
                    ticksTxtBounds.add(labelBounds);
                }
            }
        }
        float[] ticks = direction == 0 ? this.layout.getXTicks() : (direction == 1 ? this.layout.getYTicks() : this.layout.getZTicks());
        String tickLabel = "";
        gl.glColor3f(color.r, color.g, color.b);
        gl.glLineWidth(1.0f);
        for (int t = 0; t < ticks.length; ++t) {
            if (direction == 0) {
                xlab = xpos = ticks[t];
                ylab = this.yrange / tickLength * ydir + ypos;
                zlab = this.zrange / tickLength * zdir + zpos;
                tickLabel = this.layout.getXTickRenderer().format(xpos);
            } else if (direction == 1) {
                ypos = ticks[t];
                xlab = this.xrange / tickLength * xdir + xpos;
                ylab = ypos;
                zlab = this.zrange / tickLength * zdir + zpos;
                tickLabel = this.layout.getYTickRenderer().format(ypos);
            } else {
                zpos = ticks[t];
                xlab = this.xrange / tickLength * xdir + xpos;
                ylab = this.yrange / tickLength * ydir + ypos;
                zlab = zpos;
                tickLabel = this.layout.getZTickRenderer().format(zpos);
            }
            Coord3d tickPosition = new Coord3d(xlab, ylab, zlab);
            gl.glBegin(1);
            gl.glVertex3f(xpos, ypos, zpos);
            gl.glVertex3f(xlab, ylab, zlab);
            gl.glEnd();
            Halign hAlign = hal == null ? (cam.side(tickPosition) ? Halign.LEFT : Halign.RIGHT) : hal;
            Valign vAlign = val == null ? (direction == 2 ? Valign.CENTER : (zdir > 0.0f ? Valign.TOP : Valign.BOTTOM)) : val;
            if (this.txtRenderer != null) {
                this.txtRenderer.appendText(gl, glu, cam, tickLabel, tickPosition, hAlign, vAlign, color);
                continue;
            }
            BoundingBox3d tickBounds = this.txt.drawText(gl, glu, cam, tickLabel, tickPosition, hAlign, vAlign, color);
            if (tickBounds == null) continue;
            ticksTxtBounds.add(tickBounds);
        }
        return ticksTxtBounds;
    }

    protected int findClosestXaxe(Camera cam) {
        int a;
        int na = 4;
        double[] distAxeX = new double[na];
        for (a = 0; a < na; ++a) {
            distAxeX[a] = this.quadIsHidden[this.axeXquads[a][0]] ^ this.quadIsHidden[this.axeXquads[a][1]] ? new Vector3d(this.axeXx[a][0], this.axeXy[a][0], this.axeXz[a][0], this.axeXx[a][1], this.axeXy[a][1], this.axeXz[a][1]).distance(cam.getEye()) : Double.MAX_VALUE;
        }
        for (a = 0; a < na; ++a) {
            if (!(distAxeX[a] < Double.MAX_VALUE) || !(this.center.z > (this.axeXz[a][0] + this.axeXz[a][1]) / 2.0f)) continue;
            int n = a;
            distAxeX[n] = distAxeX[n] * -1.0;
        }
        return this.min(distAxeX);
    }

    protected int findClosestYaxe(Camera cam) {
        int a;
        int na = 4;
        double[] distAxeY = new double[na];
        for (a = 0; a < na; ++a) {
            distAxeY[a] = this.quadIsHidden[this.axeYquads[a][0]] ^ this.quadIsHidden[this.axeYquads[a][1]] ? new Vector3d(this.axeYx[a][0], this.axeYy[a][0], this.axeYz[a][0], this.axeYx[a][1], this.axeYy[a][1], this.axeYz[a][1]).distance(cam.getEye()) : Double.MAX_VALUE;
        }
        for (a = 0; a < na; ++a) {
            if (!(distAxeY[a] < Double.MAX_VALUE) || !(this.center.z > (this.axeYz[a][0] + this.axeYz[a][1]) / 2.0f)) continue;
            int n = a;
            distAxeY[n] = distAxeY[n] * -1.0;
        }
        return this.min(distAxeY);
    }

    protected int findClosestZaxe(Camera cam) {
        int a;
        int na = 4;
        double[] distAxeZ = new double[na];
        for (a = 0; a < na; ++a) {
            distAxeZ[a] = this.quadIsHidden[this.axeZquads[a][0]] ^ this.quadIsHidden[this.axeZquads[a][1]] ? new Vector3d(this.axeZx[a][0], this.axeZy[a][0], this.axeZz[a][0], this.axeZx[a][1], this.axeZy[a][1], this.axeZz[a][1]).distance(cam.getEye()) : Double.MAX_VALUE;
        }
        for (a = 0; a < na; ++a) {
            Coord3d axeCenter;
            if (!(distAxeZ[a] < Double.MAX_VALUE) || cam.side(axeCenter = new Coord3d((this.axeZx[a][0] + this.axeZx[a][1]) / 2.0f, (this.axeZy[a][0] + this.axeZy[a][1]) / 2.0f, (this.axeZz[a][0] + this.axeZz[a][1]) / 2.0f))) continue;
            int n = a;
            distAxeZ[n] = distAxeZ[n] * -1.0;
        }
        return this.min(distAxeZ);
    }

    protected int min(double[] values) {
        double minv = Double.MAX_VALUE;
        int index = -1;
        for (int i = 0; i < values.length; ++i) {
            if (!(values[i] < minv)) continue;
            minv = values[i];
            index = i;
        }
        return index;
    }

    protected boolean[] getHiddenQuads(GL gl, Camera cam) {
        boolean[] status = new boolean[6];
        Coord3d se = cam.getEye().div(this.scale);
        if (se.x <= this.center.x) {
            status[0] = false;
            status[1] = true;
        } else {
            status[0] = true;
            status[1] = false;
        }
        if (se.y <= this.center.y) {
            status[2] = false;
            status[3] = true;
        } else {
            status[2] = true;
            status[3] = false;
        }
        if (se.z <= this.center.z) {
            status[4] = false;
            status[5] = true;
        } else {
            status[4] = true;
            status[5] = false;
        }
        return status;
    }

    protected int print3DcolorVertex(int size, int count, float[] buffer) {
        int id = size - count;
        int veclength = 7;
        System.out.print("  [" + id + "]");
        for (int i = 0; i < veclength; ++i) {
            System.out.print(" " + buffer[size - count]);
            --count;
        }
        System.out.println();
        return count;
    }

    protected void printHiddenQuads() {
        for (int t = 0; t < this.quadIsHidden.length; ++t) {
            if (this.quadIsHidden[t]) {
                System.out.println("Quad[" + t + "] is not displayed");
                continue;
            }
            System.out.println("Quad[" + t + "] is displayed");
        }
    }
}

