/*
 * Decompiled with CFR 0.152.
 */
package org.jzy3d.plot3d.primitives.enlightables;

import javax.media.opengl.GL2;
import javax.media.opengl.glu.GLU;
import javax.media.opengl.glu.GLUquadric;
import org.jzy3d.colors.Color;
import org.jzy3d.colors.ISingleColorable;
import org.jzy3d.events.DrawableChangedEvent;
import org.jzy3d.maths.BoundingBox3d;
import org.jzy3d.maths.Coord3d;
import org.jzy3d.maths.Utils;
import org.jzy3d.plot3d.primitives.enlightables.AbstractEnlightable;
import org.jzy3d.plot3d.rendering.view.Camera;

public class EnlightableSphere
extends AbstractEnlightable
implements ISingleColorable {
    private float x;
    private float y;
    private float z;
    private float radius;
    private int slices;
    private int stacks;
    private Color color;

    public EnlightableSphere() {
        this(Coord3d.ORIGIN, 10.0f, 15, Color.BLACK);
    }

    public EnlightableSphere(Coord3d position, float radius, int slicing, Color color) {
        this.bbox = new BoundingBox3d();
        this.setPosition(position);
        this.setVolume(radius);
        this.setSlicing(slicing, slicing);
        this.setColor(color);
    }

    public void draw(GL2 gl, GLU glu, Camera cam) {
        if (this.transform != null) {
            this.transform.execute(gl);
        }
        gl.glTranslatef(this.x, this.y, this.z);
        this.applyMaterial(gl);
        gl.glLineWidth(this.wfwidth);
        GLUquadric qobj = glu.gluNewQuadric();
        if (this.facestatus) {
            gl.glPolygonMode(1032, 6914);
            gl.glColor4f(this.color.r, this.color.g, this.color.b, this.color.a);
            glu.gluSphere(qobj, (double)this.radius, this.slices, this.stacks);
        }
        if (this.wfstatus) {
            gl.glPolygonMode(1032, 6913);
            gl.glColor4f(this.wfcolor.r, this.wfcolor.g, this.wfcolor.b, this.wfcolor.a);
            glu.gluSphere(qobj, (double)this.radius, this.slices, this.stacks);
        }
    }

    public void setData(Coord3d position, float radius, float height, int slices, int stacks) {
        this.setPosition(position);
        this.setVolume(radius);
        this.setSlicing(slices, stacks);
    }

    public void setPosition(Coord3d position) {
        this.x = position.x;
        this.y = position.y;
        this.z = position.z;
        this.bbox.reset();
        this.bbox.add(this.x + this.radius, this.y + this.radius, this.z + this.radius);
        this.bbox.add(this.x - this.radius, this.y - this.radius, this.z - this.radius);
    }

    public void setVolume(float radius) {
        this.radius = radius;
        this.bbox.reset();
        this.bbox.add(this.x + radius, this.y + radius, this.z + radius);
        this.bbox.add(this.x - radius, this.y - radius, this.z - radius);
    }

    public void setSlicing(int verticalWires, int horizontalWires) {
        this.slices = verticalWires;
        this.stacks = horizontalWires;
    }

    public void setColor(Color color) {
        this.color = color;
        this.fireDrawableChanged(new DrawableChangedEvent(this, 2));
    }

    public Color getColor() {
        return this.color;
    }

    public String toString(int depth) {
        return Utils.blanks(depth) + "(EnlightableSphere) x=" + this.x + " y=" + this.y + " z=" + this.z + " r=" + this.color.r + " g=" + this.color.g + " b=" + this.color.b + " a=" + this.color.a;
    }
}

