/*
 * Decompiled with CFR 0.152.
 */
package org.jzy3d.plot3d.rendering.canvas;

import com.jogamp.opengl.util.Animator;
import java.awt.image.BufferedImage;
import javax.media.opengl.GLAutoDrawable;
import javax.media.opengl.GLCapabilitiesImmutable;
import javax.media.opengl.awt.GLJPanel;
import org.jzy3d.factories.JzyFactories;
import org.jzy3d.global.Settings;
import org.jzy3d.plot3d.rendering.canvas.IScreenCanvas;
import org.jzy3d.plot3d.rendering.canvas.Quality;
import org.jzy3d.plot3d.rendering.scene.Scene;
import org.jzy3d.plot3d.rendering.view.Renderer3d;
import org.jzy3d.plot3d.rendering.view.View;

public class CanvasSwing
extends GLJPanel
implements IScreenCanvas {
    protected View view;
    protected Renderer3d renderer;
    protected Animator animator;
    private static final long serialVersionUID = 980088854683562436L;

    public CanvasSwing(Scene scene, Quality quality) {
        this(scene, quality, (GLCapabilitiesImmutable)Settings.getInstance().getGLCapabilities());
    }

    public CanvasSwing(Scene scene, Quality quality, GLCapabilitiesImmutable glci) {
        super(glci);
        this.view = scene.newView(this, quality);
        this.renderer = JzyFactories.renderer3d.getInstance(this.view, false, false);
        this.addGLEventListener(this.renderer);
        this.setFocusable(true);
        this.requestFocusInWindow();
        this.setAutoSwapBufferMode(quality.isAutoSwapBuffer());
        if (quality.isAnimated()) {
            this.animator = new Animator((GLAutoDrawable)this);
            this.getAnimator().start();
        }
    }

    public void dispose() {
        if (this.renderer != null) {
            this.renderer.dispose((GLAutoDrawable)this);
        }
        this.renderer = null;
        this.view = null;
    }

    public void forceRepaint() {
        this.display();
    }

    public BufferedImage screenshot() {
        this.renderer.nextDisplayUpdateScreenshot();
        this.display();
        return this.renderer.getLastScreenshot();
    }

    public View getView() {
        return this.view;
    }

    public int getRendererWidth() {
        return this.renderer != null ? this.renderer.getWidth() : 0;
    }

    public int getRendererHeight() {
        return this.renderer != null ? this.renderer.getHeight() : 0;
    }
}

