/*
 * Decompiled with CFR 0.152.
 */
package org.jzy3d.plot3d.rendering.legends.colorbars;

import java.awt.Dimension;
import java.awt.Image;
import javax.media.opengl.GL2;
import javax.media.opengl.glu.GLU;
import org.jzy3d.colors.Color;
import org.jzy3d.colors.IMultiColorable;
import org.jzy3d.events.DrawableChangedEvent;
import org.jzy3d.plot2d.primitive.ColorbarImageGenerator;
import org.jzy3d.plot3d.primitives.AbstractDrawable;
import org.jzy3d.plot3d.primitives.axes.layout.IAxeLayout;
import org.jzy3d.plot3d.primitives.axes.layout.providers.ITickProvider;
import org.jzy3d.plot3d.primitives.axes.layout.renderers.ITickRenderer;
import org.jzy3d.plot3d.rendering.legends.Legend;

public class ColorbarLegend
extends Legend {
    protected ITickProvider provider;
    protected ITickRenderer renderer;
    protected Dimension minimumDimension;
    protected Color foreground;
    protected Color background;

    public ColorbarLegend(AbstractDrawable parent, IAxeLayout layout) {
        this(parent, layout.getZTickProvider(), layout.getZTickRenderer(), layout.getMainColor(), null);
    }

    public ColorbarLegend(AbstractDrawable parent, IAxeLayout layout, Color foreground) {
        this(parent, layout.getZTickProvider(), layout.getZTickRenderer(), foreground, null);
    }

    public ColorbarLegend(AbstractDrawable parent, IAxeLayout layout, Color foreground, Color background) {
        this(parent, layout.getZTickProvider(), layout.getZTickRenderer(), foreground, background);
    }

    public ColorbarLegend(AbstractDrawable parent, ITickProvider provider, ITickRenderer renderer) {
        this(parent, provider, renderer, Color.BLACK, Color.WHITE);
    }

    public ColorbarLegend(AbstractDrawable parent, ITickProvider provider, ITickRenderer renderer, Color foreground, Color background) {
        super(parent);
        this.provider = provider;
        this.renderer = renderer;
        this.foreground = foreground;
        this.background = background;
        this.minimumDimension = new Dimension(100, 100);
    }

    public void render(GL2 gl, GLU glu) {
        gl.glEnable(3042);
        super.render(gl, glu);
    }

    public Image toImage(int width, int height) {
        IMultiColorable mc;
        if (this.parent != null && this.parent instanceof IMultiColorable && (mc = (IMultiColorable)((Object)this.parent)).getColorMapper() != null) {
            ColorbarImageGenerator bar = new ColorbarImageGenerator(mc.getColorMapper(), this.provider, this.renderer);
            if (this.foreground != null) {
                bar.setForegroundColor(this.foreground);
            } else {
                bar.setForegroundColor(Color.BLACK);
            }
            if (this.background != null) {
                bar.setBackgroundColor(this.background);
                bar.setHasBackground(true);
            } else {
                bar.setHasBackground(false);
            }
            return bar.toImage(Math.max(width - 25, 1), Math.max(height - 25, 1));
        }
        return null;
    }

    public void drawableChanged(DrawableChangedEvent e) {
        if (e.what() == 2) {
            this.updateImage();
        }
    }

    public Dimension getMinimumSize() {
        return this.minimumDimension;
    }

    public void setMinimumSize(Dimension dimension) {
        this.minimumDimension = dimension;
    }
}

