/*
 * Decompiled with CFR 0.152.
 */
package org.jzy3d.plot3d.rendering.lights;

import com.jogamp.opengl.util.gl2.GLUT;
import javax.media.opengl.GL2;
import org.jzy3d.colors.Color;
import org.jzy3d.maths.Coord3d;
import org.jzy3d.plot3d.rendering.lights.LightSwitch;

public class Light {
    protected int lightId;
    protected boolean enabled;
    protected Color ambiantColor;
    protected Color diffuseColor;
    protected Color specularColor;
    protected Coord3d position;
    protected float[] positionZero = new float[]{0.0f, 0.0f, 0.0f, 1.0f};
    protected boolean representationDisplayed;
    protected static GLUT glut = new GLUT();

    public Light(int id) {
        this(id, true);
    }

    public Light(int id, boolean representationDisplayed) {
        this(id, true, true);
    }

    public Light(int id, boolean enabled, boolean representationDisplayed) {
        this.lightId = id;
        this.enabled = enabled;
        this.representationDisplayed = representationDisplayed;
        this.ambiantColor = Color.WHITE;
        this.diffuseColor = Color.WHITE;
        this.specularColor = Color.WHITE;
    }

    public void apply(GL2 gl, Coord3d scale) {
        if (this.enabled) {
            gl.glMatrixMode(5888);
            gl.glLoadIdentity();
            gl.glTranslatef(this.position.x * scale.x, this.position.y * scale.y, this.position.z * scale.z);
            if (this.representationDisplayed) {
                gl.glDisable(2896);
                gl.glColor3f(0.0f, 1.0f, 1.0f);
                gl.glPolygonMode(1032, 6913);
                glut.glutSolidCube(10.0f);
                gl.glEnable(2896);
            }
            LightSwitch.enable(gl, this.lightId);
            gl.glLightfv(16384, 4611, this.positionZero, 0);
            gl.glLightfv(16384, 4608, this.ambiantColor.toArray(), 0);
            gl.glLightfv(16384, 4609, this.diffuseColor.toArray(), 0);
            gl.glLightfv(16384, 4610, this.specularColor.toArray(), 0);
        } else {
            gl.glDisable(2896);
        }
    }

    public void setRepresentationDisplayed(boolean status) {
        this.representationDisplayed = status;
    }

    public boolean getRepresentationDisplayed() {
        return this.representationDisplayed;
    }

    public int getId() {
        return this.lightId;
    }

    public void setPosition(Coord3d position) {
        this.position = position;
    }

    public Coord3d getPosition() {
        return this.position;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public Color getAmbiantColor() {
        return this.ambiantColor;
    }

    public void setAmbiantColor(Color ambiantColor) {
        this.ambiantColor = ambiantColor;
    }

    public Color getDiffuseColor() {
        return this.diffuseColor;
    }

    public void setDiffuseColor(Color diffuseColor) {
        this.diffuseColor = diffuseColor;
    }

    public Color getSpecularColor() {
        return this.specularColor;
    }

    public void setSpecularColor(Color specularColor) {
        this.specularColor = specularColor;
    }
}

