/*
 * Decompiled with CFR 0.152.
 */
package org.jzy3d.plot3d.rendering.lights;

import java.util.ArrayList;
import java.util.List;
import javax.media.opengl.GL2;
import org.jzy3d.maths.Coord3d;
import org.jzy3d.plot3d.rendering.lights.Light;
import org.jzy3d.plot3d.rendering.lights.LightSwitch;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LightSet {
    protected List<Light> lights;
    protected boolean lazyLightInit = false;

    public LightSet() {
        this.lights = new ArrayList<Light>();
    }

    public LightSet(List<Light> lights) {
        this.lights = lights;
    }

    public void init(GL2 gl) {
        gl.glEnable(2903);
    }

    public void apply(GL2 gl, Coord3d scale) {
        if (this.lazyLightInit) {
            this.initLight(gl);
            for (Light light : this.lights) {
                LightSwitch.enable(gl, light.getId());
            }
            this.lazyLightInit = false;
        }
        for (Light light : this.lights) {
            light.apply(gl, scale);
        }
    }

    public void enableLightIfThereAreLights(GL2 gl) {
        this.enable(gl, true);
    }

    public void enable(GL2 gl, boolean onlyIfAtLeastOneLight) {
        if (onlyIfAtLeastOneLight) {
            if (this.lights.size() > 0) {
                gl.glEnable(2896);
            }
        } else {
            gl.glEnable(2896);
        }
    }

    public void disable(GL2 gl) {
        gl.glDisable(2896);
    }

    public Light get(int id) {
        return this.lights.get(id);
    }

    public void add(Light light) {
        if (this.lights.size() == 0) {
            this.queryLazyLightInit();
        }
        this.lights.add(light);
    }

    public void remove(Light light) {
        this.lights.remove(light);
    }

    protected void queryLazyLightInit() {
        this.lazyLightInit = true;
    }

    protected void initLight(GL2 gl) {
        gl.glEnable(2903);
        gl.glEnable(2896);
        gl.glLightModeli(2898, 1);
    }
}

