/*
 * Decompiled with CFR 0.152.
 */
package org.jzy3d.plot3d.rendering.textures;

import com.jogamp.opengl.util.texture.Texture;
import com.jogamp.opengl.util.texture.TextureCoords;
import com.jogamp.opengl.util.texture.awt.AWTTextureIO;
import java.awt.image.BufferedImage;
import java.io.IOException;
import javax.media.opengl.GL;
import javax.media.opengl.GL2;
import javax.media.opengl.GLException;
import javax.media.opengl.GLProfile;
import org.jzy3d.plot3d.rendering.textures.SharedTexture;

public class BufferedImageTexture
extends SharedTexture {
    protected Texture texture;
    protected BufferedImage image;
    protected TextureCoords coords;
    protected float halfWidth;
    protected float halfHeight;

    public BufferedImageTexture(BufferedImage image) {
        this.image = image;
    }

    public Texture getTexture(GL2 gl) {
        if (this.texture == null) {
            this.mount(gl);
        }
        return this.texture;
    }

    public void mount(GL2 gl) {
        try {
            this.load(gl, this.image);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        this.coords = this.texture.getImageTexCoords();
        this.halfWidth = this.texture.getWidth() / 2;
        this.halfHeight = this.texture.getHeight() / 2;
    }

    protected void load(GL2 gl, BufferedImage image) throws GLException, IOException {
        this.texture = AWTTextureIO.newTexture((GLProfile)GLProfile.getDefault(), (BufferedImage)image, (boolean)false);
        this.texture.setTexParameteri((GL)gl, 10240, 9729);
        this.texture.setTexParameteri((GL)gl, 10241, 9729);
    }

    public String getFile() {
        return this.file;
    }

    public TextureCoords getCoords() {
        return this.coords;
    }

    public float getHalfWidth() {
        return this.halfWidth;
    }

    public float getHalfHeight() {
        return this.halfHeight;
    }
}

