/*
 * Decompiled with CFR 0.152.
 */
package org.jzy3d.plot3d.rendering.view.controllers;

import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import org.jzy3d.chart.controllers.ControllerType;
import org.jzy3d.events.ControllerEvent;
import org.jzy3d.events.ControllerEventListener;
import org.jzy3d.maths.Coord2d;
import org.jzy3d.plot3d.rendering.view.View;

public abstract class ViewCameraController {
    protected List<View> targets;
    protected Vector<ControllerEventListener> controllerListeners = new Vector(1);

    public ViewCameraController() {
        this.targets = new ArrayList<View>();
    }

    public void addTarget(View target) {
        this.targets.add(target);
    }

    public void removeTarget(View target) {
        this.targets.remove(target);
    }

    public void dispose() {
        this.targets.clear();
    }

    protected void rotate(Coord2d move) {
        for (View view : this.targets) {
            view.rotate(move);
        }
        this.fireControllerEvent(ControllerType.ROTATE, move);
    }

    protected void shift(float factor) {
        for (View view : this.targets) {
            view.shift(factor);
        }
        this.fireControllerEvent(ControllerType.SHIFT, Float.valueOf(factor));
    }

    protected void zoom(float factor) {
        for (View view : this.targets) {
            view.zoom(factor);
        }
        this.fireControllerEvent(ControllerType.ZOOM, Float.valueOf(factor));
    }

    public void addControllerEventListener(ControllerEventListener listener) {
        this.controllerListeners.add(listener);
    }

    public void removeControllerEventListener(ControllerEventListener listener) {
        this.controllerListeners.remove(listener);
    }

    protected void fireControllerEvent(ControllerType type, Object value) {
        ControllerEvent e = new ControllerEvent(this, type, value);
        for (ControllerEventListener listener : this.controllerListeners) {
            listener.controllerEventFired(e);
        }
    }
}

