/*
 * Decompiled with CFR 0.152.
 */
package org.jzy3d.plot3d.text.renderers;

import com.jogamp.opengl.util.gl2.GLUT;
import javax.media.opengl.GL2;
import javax.media.opengl.glu.GLU;
import org.jzy3d.colors.Color;
import org.jzy3d.maths.BoundingBox3d;
import org.jzy3d.maths.Coord2d;
import org.jzy3d.maths.Coord3d;
import org.jzy3d.plot3d.rendering.view.Camera;
import org.jzy3d.plot3d.text.AbstractTextRenderer;
import org.jzy3d.plot3d.text.ITextRenderer;
import org.jzy3d.plot3d.text.align.Halign;
import org.jzy3d.plot3d.text.align.Valign;

public class TextBitmapRenderer
extends AbstractTextRenderer
implements ITextRenderer {
    protected static GLUT glut = new GLUT();
    protected int fontHeight = 10;
    protected int font = 6;

    public void drawSimpleText(GL2 gl, GLU glu, Camera cam, String s, Coord3d position, Color color) {
        gl.glColor3f(color.r, color.g, color.b);
        gl.glRasterPos3f(position.x, position.y, position.z);
        glut.glutBitmapString(this.font, s);
    }

    public BoundingBox3d drawText(GL2 gl, GLU glu, Camera cam, String s, Coord3d position, Halign halign, Valign valign, Color color, Coord2d screenOffset, Coord3d sceneOffset) {
        Coord3d posReal;
        gl.glColor3f(color.r, color.g, color.b);
        Coord3d posScreen = cam.modelToScreen(gl, glu, position);
        float strlen = glut.glutBitmapLength(this.font, s);
        float x = 0.0f;
        float y = 0.0f;
        if (halign == Halign.RIGHT) {
            x = posScreen.x;
        } else if (halign == Halign.CENTER) {
            x = posScreen.x - strlen / 2.0f;
        } else if (halign == Halign.LEFT) {
            x = posScreen.x - strlen;
        }
        if (valign == Valign.TOP) {
            y = posScreen.y;
        } else if (valign == Valign.GROUND) {
            y = posScreen.y;
        } else if (valign == Valign.CENTER) {
            y = posScreen.y - (float)(this.fontHeight / 2);
        } else if (valign == Valign.BOTTOM) {
            y = posScreen.y - (float)this.fontHeight;
        }
        Coord3d posScreenShifted = new Coord3d(x + screenOffset.x, y + screenOffset.y, posScreen.z);
        try {
            posReal = cam.screenToModel(gl, glu, posScreenShifted);
        }
        catch (RuntimeException e) {
            System.err.println("TextBitmap.drawText(): could not process text position: " + posScreen + " " + posScreenShifted);
            return new BoundingBox3d();
        }
        gl.glRasterPos3f(posReal.x + sceneOffset.x, posReal.y + sceneOffset.y, posReal.z + sceneOffset.z);
        glut.glutBitmapString(this.font, s);
        Coord3d botLeft = new Coord3d();
        Coord3d topRight = new Coord3d();
        botLeft.x = posScreenShifted.x;
        botLeft.y = posScreenShifted.y;
        botLeft.z = posScreenShifted.z;
        topRight.x = botLeft.x + strlen;
        topRight.y = botLeft.y + (float)this.fontHeight;
        topRight.z = botLeft.z;
        BoundingBox3d txtBounds = new BoundingBox3d();
        txtBounds.add(cam.screenToModel(gl, glu, botLeft));
        txtBounds.add(cam.screenToModel(gl, glu, topRight));
        return txtBounds;
    }
}

