/*
 * Decompiled with CFR 0.152.
 */
package org.jzy3d.plot3d.text.renderers.jogl;

import java.awt.Color;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import org.jzy3d.plot3d.text.renderers.jogl.ITextStyle;

public class GradientTextStyle
implements ITextStyle {
    private float gradientSize;
    private Color color1;
    private Color color2;

    public GradientTextStyle(float gradientSize, Color color1, Color color2) {
        this.gradientSize = gradientSize;
        this.color1 = color1;
        this.color2 = color2;
    }

    public boolean intensityOnly() {
        return false;
    }

    public Rectangle2D getBounds(CharSequence str, Font font, FontRenderContext frc) {
        return this.getBounds(((Object)str).toString(), font, frc);
    }

    public Rectangle2D getBounds(String str, Font font, FontRenderContext frc) {
        return this.getBounds(font.createGlyphVector(frc, str), frc);
    }

    public Rectangle2D getBounds(GlyphVector gv, FontRenderContext frc) {
        Rectangle stringBounds = gv.getPixelBounds(frc, 0.0f, 0.0f);
        return new Rectangle2D.Double(((RectangularShape)stringBounds).getX(), ((RectangularShape)stringBounds).getY(), ((RectangularShape)stringBounds).getWidth(), ((RectangularShape)stringBounds).getHeight());
    }

    public void drawGlyphVector(Graphics2D graphics, GlyphVector str, int x, int y) {
        graphics.setColor(Color.WHITE);
        graphics.setPaint(new GradientPaint(x, y, this.color1, x, (float)y + this.gradientSize / 2.0f, this.color2, true));
        graphics.drawGlyphVector(str, x, y);
    }

    public void draw(Graphics2D graphics, String str, int x, int y) {
        graphics.setColor(Color.WHITE);
        graphics.setPaint(new GradientPaint(x, y, this.color1, x, (float)y + this.gradientSize / 2.0f, this.color2, true));
        graphics.drawString(str, x, y);
    }
}

