/*
 * Decompiled with CFR 0.152.
 */
package org.jzy3d.plot3d.text.renderers.jogl;

import com.jogamp.opengl.util.awt.TextRenderer;
import java.awt.Color;
import java.awt.Font;
import java.awt.geom.Rectangle2D;
import javax.media.opengl.GL2;
import javax.media.opengl.glu.GLU;
import org.jzy3d.maths.BoundingBox3d;
import org.jzy3d.maths.Coord2d;
import org.jzy3d.maths.Coord3d;
import org.jzy3d.plot3d.rendering.view.Camera;
import org.jzy3d.plot3d.text.AbstractTextRenderer;
import org.jzy3d.plot3d.text.ITextRenderer;
import org.jzy3d.plot3d.text.align.Halign;
import org.jzy3d.plot3d.text.align.Valign;
import org.jzy3d.plot3d.text.renderers.jogl.DefaultTextStyle;
import org.jzy3d.plot3d.text.renderers.jogl.ITextStyle;

public class JOGLTextRenderer
extends AbstractTextRenderer
implements ITextRenderer {
    protected boolean LAYOUT = false;
    protected Font font = new Font("Serif", 0, 72);
    protected TextRenderer.RenderDelegate style;
    protected TextRenderer renderer;

    public JOGLTextRenderer() {
        this(new DefaultTextStyle(Color.BLUE));
    }

    public JOGLTextRenderer(ITextStyle style) {
        this.renderer = new TextRenderer(this.font, true, true, (TextRenderer.RenderDelegate)style);
        this.style = style;
    }

    public void drawSimpleText(GL2 gl, GLU glu, Camera cam, String s, Coord3d position, org.jzy3d.colors.Color color) {
        this.renderer.begin3DRendering();
        this.renderer.draw3D(s, position.x, position.y, position.z, 0.01f);
        this.renderer.flush();
        this.renderer.end3DRendering();
    }

    public BoundingBox3d drawText(GL2 gl, GLU glu, Camera cam, String s, Coord3d position, Halign halign, Valign valign, org.jzy3d.colors.Color color, Coord2d screenOffset, Coord3d sceneOffset) {
        this.renderer.begin3DRendering();
        if (this.LAYOUT) {
            Rectangle2D d = this.style.getBounds(s, this.font, this.renderer.getFontRenderContext());
            Coord3d left2d = cam.modelToScreen(gl, glu, position);
            Coord2d right2d = new Coord2d(left2d.x + (float)d.getWidth(), left2d.y + (float)d.getHeight());
            Coord3d right3d = cam.screenToModel(gl, glu, new Coord3d(right2d, 0.0f));
            Coord3d offset3d = right3d.sub(position).div(2.0f);
            Coord3d real = position.add(sceneOffset).sub(offset3d);
            this.renderer.draw3D(s, real.x, real.y, real.z, 0.005f);
        } else {
            Coord3d real = position.add(sceneOffset);
            this.renderer.draw3D(s, real.x, real.y, real.z, 0.005f);
        }
        this.renderer.flush();
        this.renderer.end3DRendering();
        return null;
    }
}

