/*
 * Decompiled with CFR 0.152.
 */
package org.jzy3d.ui.editors;

import java.awt.GridLayout;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jzy3d.chart.Chart;
import org.jzy3d.colors.Color;
import org.jzy3d.plot3d.primitives.enlightables.AbstractEnlightable;
import org.jzy3d.ui.LookAndFeel;
import org.jzy3d.ui.editors.ColorEditor;

public class MaterialEditor
extends JPanel {
    protected ColorEditor ambiantColorControl;
    protected ColorEditor diffuseColorControl;
    protected ColorEditor specularColorControl;
    protected Chart chart;
    protected AbstractEnlightable enlightable;
    private static final long serialVersionUID = 4903947408608903517L;

    public MaterialEditor(Chart chart) {
        LookAndFeel.apply();
        this.chart = chart;
        this.ambiantColorControl = new ColorEditor("Ambiant");
        this.diffuseColorControl = new ColorEditor("Diffuse");
        this.specularColorControl = new ColorEditor("Specular");
        this.setLayout(new GridLayout(3, 1));
        this.add(this.ambiantColorControl);
        this.add(this.diffuseColorControl);
        this.add(this.specularColorControl);
    }

    protected void registerColorControl(ColorEditor colorControl, final Color color) {
        final JSlider slider0 = colorControl.getSlider(0);
        slider0.setValue((int)color.r * slider0.getMaximum());
        slider0.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                color.r = MaterialEditor.this.getPercent(slider0);
                System.out.println(color);
                MaterialEditor.this.chart.render();
            }
        });
        final JSlider slider1 = colorControl.getSlider(1);
        slider1.setValue((int)color.g * slider1.getMaximum());
        slider1.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                color.g = MaterialEditor.this.getPercent(slider1);
                MaterialEditor.this.chart.render();
            }
        });
        final JSlider slider2 = colorControl.getSlider(2);
        slider2.setValue((int)color.b * slider2.getMaximum());
        slider2.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                color.b = MaterialEditor.this.getPercent(slider2);
                MaterialEditor.this.chart.render();
            }
        });
    }

    protected float getPercent(JSlider slider) {
        return (float)slider.getValue() / (float)slider.getMaximum();
    }

    public void setTarget(AbstractEnlightable enlightable) {
        this.enlightable = enlightable;
        System.out.println(enlightable);
        this.registerColorControl(this.ambiantColorControl, enlightable.getMaterialAmbiantReflection());
        this.registerColorControl(this.diffuseColorControl, enlightable.getMaterialDiffuseReflection());
        this.registerColorControl(this.specularColorControl, enlightable.getMaterialSpecularReflection());
    }
}

