/*
 * Decompiled with CFR 0.152.
 */
package edu.geophys.hypoline;

import edu.geophys.commons.suite.SuiteManager;
import edu.geophys.commons.ui.AbstractConfiguration;
import edu.geophys.commons.util.JAXBSerializable;
import edu.geophys.commons.util.JAXBUtil;
import edu.geophys.commons.util.LogUtil;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlTransient;
import java.awt.Dimension;
import java.awt.Point;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

@XmlRootElement(name="HypoLine")
public class HypoLineConfiguration
extends AbstractConfiguration
implements JAXBSerializable {
    private static final long serialVersionUID = 1L;
    @XmlTransient
    public final String DEFAULT_CONFIGFILE = SuiteManager.INSTANCE.getKnowledgebase().getKnowledgeFolder().getAbsolutePath() + File.separator + "hypoline.xml";
    private AbstractConfiguration.FrameSize hypoLineFrameSize = new AbstractConfiguration.FrameSize(1280, 768);
    private AbstractConfiguration.FramePosition hypoLineFramePosition = new AbstractConfiguration.FramePosition(0, 0);
    private int[] traceFl = new int[]{0, 0, 0, 0, 0, 0};
    private int[] traceFu = new int[]{0, 0, 0, 0, 0, 0};
    private List<String> customSites = new ArrayList<String>();
    private int activeSNS = -2;
    private HypoLineMode hypoLineMode = HypoLineMode.NETWORK;
    private boolean expand3Comp = false;
    private boolean showSatellite = true;
    private boolean scrollPane = false;
    private int numGrdPoints = 100;
    private boolean useBeamsInGrid = false;
    private GRID_TYPE gridType = GRID_TYPE.RESIDUAL;
    private int probabilisticGridSampleNum = 100;
    private String layerModelName = "";
    private boolean tieFilters = true;
    private boolean commonScaling = false;
    private boolean splineInterpolation = false;
    private boolean showEventMarkers = false;
    private boolean automaticSync = true;
    private String nllocBinaryDir = "";
    private String srtmDir = "";

    private final void shallowCopyFrom(HypoLineConfiguration hypoLineConfiguration) {
        this.hypoLineFrameSize = hypoLineConfiguration.hypoLineFrameSize;
        this.hypoLineFramePosition = hypoLineConfiguration.hypoLineFramePosition;
        this.traceFl = hypoLineConfiguration.traceFl;
        this.traceFu = hypoLineConfiguration.traceFu;
        this.activeSNS = hypoLineConfiguration.activeSNS;
        this.showSatellite = hypoLineConfiguration.showSatellite;
        this.expand3Comp = hypoLineConfiguration.expand3Comp;
        this.tieFilters = hypoLineConfiguration.tieFilters;
        this.hypoLineMode = hypoLineConfiguration.hypoLineMode;
        this.splineInterpolation = hypoLineConfiguration.splineInterpolation;
        this.customSites = hypoLineConfiguration.customSites;
        this.scrollPane = hypoLineConfiguration.scrollPane;
        this.showEventMarkers = hypoLineConfiguration.showEventMarkers;
        this.automaticSync = hypoLineConfiguration.automaticSync;
        this.numGrdPoints = hypoLineConfiguration.numGrdPoints;
        this.gridType = hypoLineConfiguration.gridType;
        this.probabilisticGridSampleNum = hypoLineConfiguration.probabilisticGridSampleNum;
        this.nllocBinaryDir = hypoLineConfiguration.nllocBinaryDir;
        this.useBeamsInGrid = hypoLineConfiguration.useBeamsInGrid;
        this.srtmDir = hypoLineConfiguration.srtmDir;
        this.layerModelName = hypoLineConfiguration.layerModelName;
    }

    public void load() {
        try {
            HypoLineConfiguration hypoLineConfiguration = (HypoLineConfiguration)JAXBUtil.readXML((File)new File(this.DEFAULT_CONFIGFILE), ((Object)((Object)this)).getClass());
            this.shallowCopyFrom(hypoLineConfiguration);
        }
        catch (Exception exception) {
            LogUtil.info(((Object)((Object)this)).getClass(), (String)"Failed to load HypoLine config file, using default values", (boolean)false);
        }
    }

    public void store() {
        try {
            JAXBUtil.writeXML((JAXBSerializable)this, (File)new File(this.DEFAULT_CONFIGFILE));
        }
        catch (Exception exception) {
            LogUtil.fatal(((Object)((Object)this)).getClass(), (String)"Failed to store HypoLine config file", (Throwable)exception);
        }
    }

    @XmlElement(name="hypoLineFrameSize", required=true, nillable=false)
    private final AbstractConfiguration.FrameSize getHypoLineFrameSizeJAXB() {
        return this.hypoLineFrameSize;
    }

    @XmlElement(name="hypoLineFramePosition", required=true, nillable=false)
    private final AbstractConfiguration.FramePosition getHypoLineFramePositionJAXB() {
        return this.hypoLineFramePosition;
    }

    private void setHypoLineFrameSizeJAXB(AbstractConfiguration.FrameSize frameSize) {
        this.hypoLineFrameSize = frameSize;
    }

    private void setHypoLineFramePositionJAXB(AbstractConfiguration.FramePosition framePosition) {
        this.hypoLineFramePosition = framePosition;
    }

    @XmlTransient
    public final Dimension getHypoLineFrameSize() {
        return this.hypoLineFrameSize.getDimension();
    }

    public final void setHypoLineFrameSize(Dimension dimension) {
        this.hypoLineFrameSize.setDimension(dimension);
    }

    @XmlTransient
    public final Point getHypoLineFramePosition() {
        return this.hypoLineFramePosition.getPoint();
    }

    public final void setHypoLineFramePosition(Point point) {
        this.hypoLineFramePosition.setPoint(point);
    }

    public int[] getTraceFl() {
        return this.traceFl;
    }

    public void setTraceFl(int[] nArray) {
        int[] nArray2 = this.traceFl;
        this.traceFl = nArray;
        this.firePropertyChange("traceFl", 0, 1);
    }

    public int[] getTraceFu() {
        return this.traceFu;
    }

    public void setTraceFu(int[] nArray) {
        int[] nArray2 = this.traceFu;
        this.traceFu = nArray;
        this.firePropertyChange("traceFu", 0, 1);
    }

    public int getActiveSNS() {
        return this.activeSNS;
    }

    public void setActiveSNS(int n) {
        int n2 = this.activeSNS;
        this.activeSNS = n;
        this.firePropertyChange("activeSNS", n2, n);
    }

    public boolean isExpand3Comp() {
        return this.expand3Comp;
    }

    public void setExpand3Comp(boolean bl) {
        boolean bl2 = this.expand3Comp;
        this.expand3Comp = bl;
        this.firePropertyChange("expand3Comp", bl2, bl);
    }

    public HypoLineMode getHypoLineMode() {
        return this.hypoLineMode;
    }

    public void setHypoLineMode(HypoLineMode hypoLineMode) {
        HypoLineMode hypoLineMode2 = this.hypoLineMode;
        this.hypoLineMode = hypoLineMode;
        this.firePropertyChange("hypoLineMode", (Object)hypoLineMode2, (Object)hypoLineMode);
    }

    public boolean isTieFilters() {
        return this.tieFilters;
    }

    public void setTieFilters(boolean bl) {
        this.tieFilters = bl;
    }

    public boolean isCommonScaling() {
        return this.commonScaling;
    }

    public void setCommonScaling(boolean bl) {
        boolean bl2 = this.commonScaling;
        this.commonScaling = bl;
        this.firePropertyChange("commonScaling", bl2, bl);
    }

    public boolean isSplineInterpolation() {
        return this.splineInterpolation;
    }

    public void setSplineInterpolation(boolean bl) {
        boolean bl2 = this.splineInterpolation;
        this.splineInterpolation = bl;
        this.firePropertyChange("splineInterpolation", bl2, bl);
    }

    public List<String> getCustomSites() {
        return this.customSites;
    }

    public void setCustomSites(List<String> list) {
        this.customSites = list;
    }

    public boolean isScrollPane() {
        return this.scrollPane;
    }

    public void setScrollPane(boolean bl) {
        boolean bl2 = this.scrollPane;
        this.scrollPane = bl;
        this.firePropertyChange("scrollPane", bl2, bl);
    }

    public boolean isShowEventMarkers() {
        return this.showEventMarkers;
    }

    public void setShowEventMarkers(boolean bl) {
        this.showEventMarkers = bl;
    }

    public boolean isAutomaticSync() {
        return this.automaticSync;
    }

    public void setAutomaticSync(boolean bl) {
        this.automaticSync = bl;
    }

    public int getNumGrdPoints() {
        return this.numGrdPoints;
    }

    public void setNumGrdPoints(int n) {
        this.numGrdPoints = n;
    }

    public GRID_TYPE getGridType() {
        return this.gridType;
    }

    public void setGridType(GRID_TYPE gRID_TYPE) {
        this.gridType = gRID_TYPE;
    }

    public int getProbabilisticGridSampleNum() {
        return this.probabilisticGridSampleNum;
    }

    public void setProbabilisticGridSampleNum(int n) {
        this.probabilisticGridSampleNum = n;
    }

    public String getNllocBinaryDir() {
        return this.nllocBinaryDir;
    }

    public void setNllocBinaryDir(String string) {
        this.nllocBinaryDir = string;
    }

    public boolean isUseBeamsInGrid() {
        return this.useBeamsInGrid;
    }

    public void setUseBeamsInGrid(boolean bl) {
        this.useBeamsInGrid = bl;
    }

    public String getSrtmDir() {
        return this.srtmDir;
    }

    public void setSrtmDir(String string) {
        this.srtmDir = string;
    }

    public boolean isShowSatellite() {
        return this.showSatellite;
    }

    public void setShowSatellite(boolean bl) {
        boolean bl2 = this.showSatellite;
        this.showSatellite = bl;
        this.firePropertyChange("showSatellite", bl2, bl);
    }

    public String getLayerModelName() {
        return this.layerModelName;
    }

    public void setLayerModelName(String string) {
        this.layerModelName = string;
    }

    public static enum HypoLineMode {
        NETWORK,
        ARRAY,
        MAGNITUDE;

    }

    public static enum GRID_TYPE {
        PATCHMAP,
        RESIDUAL,
        PROBABILISTIC;

    }
}

