/*
 * Decompiled with CFR 0.152.
 */
package edu.geophys.hypoline;

import edu.geophys.commons.model.SNS;
import edu.geophys.hypoline.HypoLineApplication;
import edu.geophys.hypoline.HypoLineConfiguration;
import edu.geophys.hypoline.ccode.CHypoLineRoutines56;
import edu.geophys.hypoline.epimap.EpiMapDatabase;
import edu.geophys.hypoline.legacy.ArrayPositionWrapper;
import edu.geophys.hypoline.me.MasterEventManager;
import edu.geophys.hypoline.protocol.ProtFileManager;
import edu.geophys.hypoline.sitecollection.SiteCollectionModel;
import edu.geophys.hypoline.ui.StatusPanel;
import edu.geophys.hypoline.ui.arraybeamprocessing.BeamView;
import edu.geophys.hypoline.ui.magnitude.MagnitudePanel;
import edu.geophys.hypoline.ui.trace.SiteModel;
import edu.geophys.hypoline.ui.vertical.LayerModelController;
import edu.geophys.hypoline.ui.vertical.LayerModelEditorFrame;
import java.util.ArrayList;
import java.util.List;

public class HypoLineManager {
    public static HypoLineManager INSTANCE;
    private HypoLineConfiguration config;
    private int numberOfTraces = 4;
    private HypoLineApplication hlApp;
    private MasterEventManager masterEventManager = new MasterEventManager();
    private List<SiteModel> sites = new ArrayList<SiteModel>();
    private List<SiteModel> currentSitesOverview = new ArrayList<SiteModel>();
    private List<SiteModel> currentSitesDetail = new ArrayList<SiteModel>();
    private ProtFileManager protFileManager = new ProtFileManager();
    private BeamView pBeamView = new BeamView(true);
    private BeamView sBeamView = new BeamView(false);
    private EpiMapDatabase epiMapDb = new EpiMapDatabase();
    private MagnitudePanel magnitudePanel = new MagnitudePanel();
    private final StatusPanel statusPanel = new StatusPanel();
    private LayerModelEditorFrame layerModelEditorFrame = null;
    private boolean forensicGridRunning = false;
    private List<SNS> allNeighbourSNS = new ArrayList<SNS>();
    private ArrayPositionWrapper arrayPositionWrapper = new ArrayPositionWrapper();
    private CHypoLineRoutines56 raytracer;
    private SiteCollectionModel siteCollectionModel = null;
    private LayerModelController layerModelController = new LayerModelController();

    public HypoLineManager() {
        INSTANCE = this;
    }

    public boolean isForensicGridRunning() {
        return this.forensicGridRunning;
    }

    public void setForensicGridRunning(boolean bl) {
        this.forensicGridRunning = bl;
    }

    public HypoLineConfiguration getConfig() {
        return this.config;
    }

    public void setConfig(HypoLineConfiguration hypoLineConfiguration) {
        this.config = hypoLineConfiguration;
    }

    public int getNumberOfTraces() {
        return this.numberOfTraces;
    }

    public void setNumberOfTraces(int n) {
        this.numberOfTraces = n;
    }

    public HypoLineApplication getHlApp() {
        return this.hlApp;
    }

    public void setHlApp(HypoLineApplication hypoLineApplication) {
        this.hlApp = hypoLineApplication;
    }

    public List<SiteModel> getSites() {
        return this.sites;
    }

    public ProtFileManager getProtFileManager() {
        return this.protFileManager;
    }

    public void setProtFileManager(ProtFileManager protFileManager) {
        this.protFileManager = protFileManager;
    }

    public List<SiteModel> getCurrentSitesOverview() {
        return this.currentSitesOverview;
    }

    public void setCurrentSitesOverview(List<SiteModel> list) {
        this.currentSitesOverview = list;
    }

    public List<SiteModel> getCurrentSitesDetail() {
        return this.currentSitesDetail;
    }

    public void setCurrentSitesDetail(List<SiteModel> list) {
        this.currentSitesDetail = list;
    }

    public BeamView getpBeamView() {
        return this.pBeamView;
    }

    public void setpBeamView(BeamView beamView) {
        this.pBeamView = beamView;
    }

    public BeamView getsBeamView() {
        return this.sBeamView;
    }

    public void setsBeamView(BeamView beamView) {
        this.sBeamView = beamView;
    }

    public EpiMapDatabase getEpiMapDb() {
        return this.epiMapDb;
    }

    public void setEpiMapDb(EpiMapDatabase epiMapDatabase) {
        this.epiMapDb = epiMapDatabase;
    }

    public MagnitudePanel getMagnitudePanel() {
        return this.magnitudePanel;
    }

    public void setMagnitudePanel(MagnitudePanel magnitudePanel) {
        this.magnitudePanel = magnitudePanel;
    }

    public void resetAll() {
        for (SiteModel siteModel : this.sites) {
            siteModel.reset();
            siteModel.getChild().reset();
        }
        for (SiteModel siteModel : this.currentSitesDetail) {
            siteModel.reset();
            siteModel.update();
        }
        this.pBeamView.reset();
        this.sBeamView.reset();
        this.magnitudePanel.update();
        this.epiMapDb.reset();
        this.epiMapDb.paintAllStations();
        this.epiMapDb.updateDepth(0.0f);
        this.hlApp.getMainFrame().getFilterView().update();
    }

    public MasterEventManager getMasterEventManager() {
        return this.masterEventManager;
    }

    public void setMasterEventManager(MasterEventManager masterEventManager) {
        this.masterEventManager = masterEventManager;
    }

    public List<SNS> getAllNeighbourSNS() {
        return this.allNeighbourSNS;
    }

    public void setAllNeighbourSNS(List<SNS> list) {
        this.allNeighbourSNS = list;
    }

    public ArrayPositionWrapper getArrayPositionWrapper() {
        return this.arrayPositionWrapper;
    }

    public StatusPanel getStatusPanel() {
        return this.statusPanel;
    }

    public void updateSelectedStationDisplay() {
        this.getHlApp().getMainFrame().getArraySelectionView().repaint();
    }

    public CHypoLineRoutines56 getRaytracer() {
        if (this.raytracer == null) {
            this.initRaytracer();
        }
        return this.raytracer;
    }

    public LayerModelController getLayerModelController() {
        return this.layerModelController;
    }

    public void onUpdateLayerModel() {
        System.out.println("Active Layer Model: " + INSTANCE.getLayerModelController().getCurrentLayerModel());
        INSTANCE.initRaytracer();
        INSTANCE.getEpiMapDb().getEpiDepth().repaintArea();
        if (this.layerModelEditorFrame != null) {
            this.layerModelEditorFrame.updateLayerModel();
        }
        this.epiMapDb.updateDepth();
    }

    public LayerModelEditorFrame getLayerModelEditorFrame() {
        if (this.layerModelEditorFrame == null) {
            this.layerModelEditorFrame = new LayerModelEditorFrame();
        }
        return this.layerModelEditorFrame;
    }

    public void initRaytracer() {
        SiteCollectionModel siteCollectionModel = this.getSiteCollectionModel();
        LayerModelController layerModelController = this.getLayerModelController();
        this.raytracer = new CHypoLineRoutines56(layerModelController.getCurrentLayerModel(), layerModelController.getCorrectedZeroElevation(), layerModelController.getCorrectedFirstLayerThickness(), siteCollectionModel.getSiteEastingsKm(), siteCollectionModel.getSiteNorthingsKm(), siteCollectionModel.getSiteZClassByIndex(), siteCollectionModel.getZClasses());
    }

    public SiteCollectionModel getSiteCollectionModel() {
        if (this.siteCollectionModel == null) {
            this.siteCollectionModel = new SiteCollectionModel();
        }
        return this.siteCollectionModel;
    }
}

