/*
 * Decompiled with CFR 0.152.
 */
package edu.geophys.hypoline.epimap;

import edu.geophys.commons.ui.AbstractBasicPainter;
import edu.geophys.hypoline.epimap.BeamModel;
import edu.geophys.hypoline.epimap.MapPoint;
import java.awt.BasicStroke;
import java.awt.Graphics2D;
import java.awt.geom.GeneralPath;

class BeamPainter
extends AbstractBasicPainter<BeamModel> {
    BeamPainter() {
    }

    protected void doBasicPaint(Graphics2D graphics2D, int n, int n2, BeamModel beamModel) {
        double d = -beamModel.getPivotAngle();
        double d2 = beamModel.getFanAngle();
        double d3 = beamModel.getFanStartWidth() / 2.0;
        double d4 = 1.5707963267948966 + d;
        double d5 = d - 1.5707963267948966;
        MapPoint mapPoint = beamModel.getPivotPoint();
        MapPoint mapPoint2 = new MapPoint(mapPoint.getX() + Math.cos(d) * beamModel.getFanDistance(), mapPoint.getY() + Math.sin(d) * beamModel.getFanDistance());
        MapPoint mapPoint3 = new MapPoint(mapPoint2.getX() + Math.cos(d5) * d3, mapPoint2.getY() + Math.sin(d5) * d3);
        MapPoint mapPoint4 = new MapPoint(mapPoint2.getX() + Math.cos(d4) * d3, mapPoint2.getY() + Math.sin(d4) * d3);
        MapPoint mapPoint5 = new MapPoint(mapPoint3.getX() + Math.cos(d - d2) * 2.0, mapPoint3.getY() + Math.sin(d - d2) * 2.0);
        MapPoint mapPoint6 = new MapPoint(mapPoint4.getX() + Math.cos(d + d2) * 2.0, mapPoint4.getY() + Math.sin(d + d2) * 2.0);
        GeneralPath generalPath = new GeneralPath();
        generalPath.moveTo(mapPoint5.getAbsoluteX(n), mapPoint5.getAbsoluteY(n2));
        generalPath.lineTo(mapPoint3.getAbsoluteX(n), mapPoint3.getAbsoluteY(n2));
        generalPath.lineTo(mapPoint4.getAbsoluteX(n), mapPoint4.getAbsoluteY(n2));
        generalPath.lineTo(mapPoint6.getAbsoluteX(n), mapPoint6.getAbsoluteY(n2));
        graphics2D.setStroke(new BasicStroke(1.0f, 0, 1));
        graphics2D.draw(generalPath);
        graphics2D.setStroke(new BasicStroke(1.0f, 0, 1, 0.0f, new float[]{20.0f, 8.0f}, 0.0f));
        graphics2D.drawLine(mapPoint2.getAbsoluteX(n), mapPoint2.getAbsoluteY(n2), mapPoint.getAbsoluteX(n), mapPoint.getAbsoluteY(n2));
        graphics2D.setStroke(new BasicStroke(1.0f, 0, 1, 0.0f, new float[]{4.0f, 4.0f}, 0.0f));
        for (double d6 = 0.0; d6 < 2.0; d6 += 0.1) {
            double d7;
            double d8;
            if (beamModel.ispOrSBeam()) {
                d8 = d6;
                d7 = 0.1 + d6;
            } else {
                d8 = 0.1 + d6;
                d7 = d6;
            }
            MapPoint mapPoint7 = new MapPoint(mapPoint3.getX() + Math.cos(d - d2) * d8, mapPoint3.getY() + Math.sin(d - d2) * d8);
            MapPoint mapPoint8 = new MapPoint(mapPoint4.getX() + Math.cos(d + d2) * d7, mapPoint4.getY() + Math.sin(d + d2) * d7);
            graphics2D.drawLine(mapPoint7.getAbsoluteX(n), mapPoint7.getAbsoluteY(n2), mapPoint8.getAbsoluteX(n), mapPoint8.getAbsoluteY(n2));
        }
    }
}

