/*
 * Decompiled with CFR 0.152.
 */
package edu.geophys.hypoline.epimap;

import edu.geophys.commons.model.layer.Layer;
import edu.geophys.commons.model.layer.LayerModel;
import edu.geophys.commons.resources.ColorRamp;
import edu.geophys.commons.themes.SuiteTheme;
import edu.geophys.commons.themes.ThemeManager;
import edu.geophys.commons.util.LogUtil;
import edu.geophys.commons.util.MathUtil;
import edu.geophys.hypoline.HypoLineManager;
import edu.geophys.hypoline.epimap.EpiMapDatabase;
import edu.geophys.hypoline.epimap.EpiMapInterface;
import edu.geophys.hypoline.ui.Legend;
import edu.geophys.hypoline.ui.vertical.LayerModelController;
import edu.geophys.hypoline.ui.vertical.LayerModelEditorFrame;
import edu.geophys.hypoline.util.HypoLineUtils;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import layout.TableLayout;

public class EpiDepthView
extends EpiMapInterface {
    private static final long serialVersionUID = 1L;
    private EpiMapDatabase epiDb;
    private static final Font epiDepthFontTextmode = new Font("Arial", 0, 12);
    private int turnLayer = 0;
    private final double incStep = 0.1;
    private double maxZ;
    private final JScrollPane scroll;
    private JLabel textArea;
    private boolean textOrGraph = false;
    private static final int LABEL_PADDING = 2;
    private static final int TOP_PX_BORDER = 30;
    private static final int HOUSE_HEIGHT = 20;
    private static final int HOUSE_WIDTH = 35;
    private static Polygon[] HOUSE_POLY_CACHE = null;
    private static final PaintMode PAINTMODE = PaintMode.EW;
    private final double DEPTH_ADD = 2.5;
    private String TABLE_LAYER_FORMAT = "<tr align=\"CENTER\"><td>%2d</td><td>%s</td><td>%.2f</td><td>%s</td></tr>";
    private final MouseListener zoomMouseListener = new MouseAdapter(){

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            if (mouseEvent.getButton() == 1) {
                Point point = new Point(mouseEvent.getX(), mouseEvent.getY() - 30);
                EpiDepthView.this.cursorModel.setAbsoluteY(point.y, EpiDepthView.this.getHeight() - 30);
                EpiDepthView.this.cursorModel2.setAbsoluteY(point.y, EpiDepthView.this.getHeight() - 30);
                EpiDepthView.this.epiDb.updateDepth((float)(EpiDepthView.this.cursorModel.getY() * (EpiDepthView.this.mapModelZ.height - EpiDepthView.this.mapModelZ.y)));
                EpiDepthView.this.cursorModelChanged();
                EpiDepthView.this.repaintArea();
            }
        }
    };
    private KeyListener keyListener = new KeyListener(){

        @Override
        public synchronized void keyPressed(KeyEvent keyEvent) {
            LayerModel layerModel = HypoLineManager.INSTANCE.getLayerModelController().getCurrentLayerModel();
            float f = EpiDepthView.this.epiDb.getEpiCenter().getEpi_z();
            switch (keyEvent.getKeyCode()) {
                case 40: {
                    if (keyEvent.isShiftDown()) {
                        if (((Layer)layerModel.getLayers().get(0)).getD() - 0.1 >= 0.0) {
                            ((Layer)layerModel.getLayers().get(0)).setD(((Layer)layerModel.getLayers().get(0)).getD() - 0.1);
                        }
                        HypoLineManager.INSTANCE.getLayerModelController().onModification();
                        break;
                    }
                    EpiDepthView.this.epiDb.getEpiCenter().setEpi_z(HypoLineUtils.changeValue(f, true));
                    break;
                }
                case 38: {
                    if (keyEvent.isShiftDown()) {
                        if (((Layer)layerModel.getLayers().get(0)).getD() + 0.1 >= 0.0) {
                            ((Layer)layerModel.getLayers().get(0)).setD(((Layer)layerModel.getLayers().get(0)).getD() + 0.1);
                        }
                        HypoLineManager.INSTANCE.getLayerModelController().onModification();
                        break;
                    }
                    float f2 = HypoLineUtils.changeValue(f, false);
                    if (f2 < 0.0f) {
                        f2 = 0.0f;
                    }
                    EpiDepthView.this.epiDb.getEpiCenter().setEpi_z(f2);
                    break;
                }
                case 37: {
                    int n = 0;
                    if (keyEvent.isControlDown() && layerModel.getLayers().size() > 1) {
                        n = 1;
                    }
                    if (keyEvent.isShiftDown()) {
                        if (((Layer)layerModel.getLayers().get(0)).getVp() - 0.1 >= 0.0) {
                            double d = 0.1;
                            if (((Layer)layerModel.getLayers().get(0)).getVp() <= 0.51) {
                                d /= 2.0;
                            }
                            ((Layer)layerModel.getLayers().get(n)).setVp(((Layer)layerModel.getLayers().get(n)).getVp() - d);
                        }
                        HypoLineManager.INSTANCE.getLayerModelController().onModification();
                        break;
                    }
                    float f3 = HypoLineUtils.changeValueLog(f, false);
                    if (f3 < 0.0f) {
                        f3 = 0.0f;
                    }
                    EpiDepthView.this.epiDb.getEpiCenter().setEpi_z(f3);
                    break;
                }
                case 39: {
                    int n = 0;
                    if (keyEvent.isControlDown() && layerModel.getLayers().size() > 1) {
                        n = 1;
                    }
                    if (keyEvent.isShiftDown()) {
                        double d = 0.1;
                        if (((Layer)layerModel.getLayers().get(0)).getVp() < 0.49) {
                            d /= 2.0;
                        }
                        ((Layer)layerModel.getLayers().get(n)).setVp(((Layer)layerModel.getLayers().get(n)).getVp() + d);
                        HypoLineManager.INSTANCE.getLayerModelController().onModification();
                        break;
                    }
                    EpiDepthView.this.epiDb.getEpiCenter().setEpi_z(HypoLineUtils.changeValueLog(f, true));
                    break;
                }
                case 34: {
                    if (!keyEvent.isShiftDown() || !(layerModel.getVp2vs() - 0.1 >= 0.0)) break;
                    double d = 0.1;
                    if (layerModel.getVp2vs() <= 0.51) {
                        d /= 2.0;
                    }
                    layerModel.setVp2vs(layerModel.getVp2vs() - d);
                    HypoLineManager.INSTANCE.getLayerModelController().onModification();
                    break;
                }
                case 33: {
                    System.out.println("0.1 " + layerModel.getVp2vs());
                    if (!keyEvent.isShiftDown()) break;
                    double d = 0.1;
                    if (layerModel.getVp2vs() <= 0.49) {
                        d /= 2.0;
                    }
                    layerModel.setVp2vs(layerModel.getVp2vs() + d);
                    HypoLineManager.INSTANCE.getLayerModelController().onModification();
                    break;
                }
                case 49: 
                case 97: {
                    HypoLineManager.INSTANCE.getLayerModelController().setCurrentLayerModel(1);
                    break;
                }
                case 50: 
                case 98: {
                    HypoLineManager.INSTANCE.getLayerModelController().setCurrentLayerModel(2);
                    break;
                }
                case 51: 
                case 99: {
                    HypoLineManager.INSTANCE.getLayerModelController().setCurrentLayerModel(3);
                    break;
                }
                case 52: 
                case 100: {
                    HypoLineManager.INSTANCE.getLayerModelController().setCurrentLayerModel(4);
                    break;
                }
                case 53: 
                case 101: {
                    HypoLineManager.INSTANCE.getLayerModelController().setCurrentLayerModel(5);
                    break;
                }
                case 54: 
                case 102: {
                    HypoLineManager.INSTANCE.getLayerModelController().setCurrentLayerModel(6);
                    break;
                }
                case 55: 
                case 103: {
                    HypoLineManager.INSTANCE.getLayerModelController().setCurrentLayerModel(7);
                    break;
                }
                case 56: 
                case 104: {
                    HypoLineManager.INSTANCE.getLayerModelController().setCurrentLayerModel(8);
                    break;
                }
                case 57: 
                case 105: {
                    HypoLineManager.INSTANCE.getLayerModelController().setCurrentLayerModel(9);
                    break;
                }
                case 48: 
                case 96: {
                    HypoLineManager.INSTANCE.getLayerModelController().setCurrentLayerModel(0);
                    break;
                }
                case 76: {
                    LayerModelEditorFrame layerModelEditorFrame = HypoLineManager.INSTANCE.getLayerModelEditorFrame();
                    layerModelEditorFrame.setVisible(!layerModelEditorFrame.isVisible());
                    break;
                }
                case 84: {
                    EpiDepthView.this.switchView();
                    break;
                }
                case 112: {
                    if (keyEvent.isAltDown()) {
                        Legend.legendf1(Legend.WindowName.MASTEREVENT);
                        break;
                    }
                    Legend.legendf1(Legend.WindowName.LAYERS);
                    break;
                }
                case 113: {
                    Legend.legendf2(Legend.WindowName.LAYERS);
                    break;
                }
                case 73: {
                    EpiDepthView.this.showEpiDepthInputSelection();
                    break;
                }
                default: {
                    return;
                }
            }
            EpiDepthView.this.epiDb.updateDepth();
            EpiDepthView.this.repaintArea();
            EpiDepthView.this.cursorModelChanged();
        }

        @Override
        public synchronized void keyReleased(KeyEvent keyEvent) {
        }

        @Override
        public void keyTyped(KeyEvent keyEvent) {
        }
    };

    public void setActive(boolean bl) {
        super.setActive(bl);
    }

    public EpiDepthView(EpiMapDatabase epiMapDatabase) {
        this.epiDb = epiMapDatabase;
        this.addKeyListener(this.keyListener);
        this.textArea = new JLabel();
        final EpiDepthView epiDepthView = this;
        this.textArea.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
                this.redispatchEvent(mouseEvent);
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
                this.redispatchEvent(mouseEvent);
            }

            private void redispatchEvent(MouseEvent mouseEvent) {
                epiDepthView.dispatchEvent(new MouseEvent((Component)((Object)epiDepthView), mouseEvent.getID(), mouseEvent.getWhen(), mouseEvent.getModifiersEx(), mouseEvent.getX(), mouseEvent.getY(), mouseEvent.getClickCount(), mouseEvent.isPopupTrigger()));
            }
        });
        this.textArea.setFocusable(false);
        this.textArea.setRequestFocusEnabled(true);
        this.textArea.setFont(epiDepthFontTextmode);
        this.scroll = new JScrollPane(this.textArea, 20, 31){
            private static final long serialVersionUID = 1L;
        };
        this.scroll.getVerticalScrollBar().setUnitIncrement(16);
        this.setLayout((LayoutManager)new TableLayout((double[][])new double[][]{{-1.0}, {-1.0}}));
        this.addMouseListener(this.zoomMouseListener);
        this.mapCursorPainter.setModel(this.cursorModel);
        this.mapCursorPainter.setDepthCursor(true);
        this.mapCursorPainter2.setModel(this.cursorModel2);
        this.mapCursorPainter2.setDepthCursor(true);
        this.mapStationsPainter.enableEpiDepthMode(30);
        this.mapStationsPainter2.enableEpiDepthMode(30);
    }

    private void switchView() {
        this.textOrGraph = !this.textOrGraph;
        this.removeAll();
        if (this.textOrGraph) {
            this.add(this.scroll, "0, 0");
        }
        this.revalidate();
        this.repaint();
    }

    @Override
    public final void updateLocation(Rectangle2D.Double double_) {
        this.mapModel = double_;
        double d = this.epiDb.getEpiCenter().getX();
        double d2 = this.epiDb.getEpiCenter().getY();
        this.cursorModel.x = (d - double_.x) / double_.width;
        this.cursorModel.y = ((double)this.epiDb.getEpiCenter().getEpi_z() - this.mapModelZ.y) / this.mapModelZ.height;
        if (this.cursorModel.x < 0.0) {
            this.cursorModel.x = 0.0;
        } else if (this.cursorModel.x > 1.0) {
            this.cursorModel.x = 1.0;
        }
        this.cursorModel2.x = (-d2 - double_.y) / double_.height;
        if (this.cursorModel2.x < 0.0) {
            this.cursorModel2.x = 0.0;
        } else if (this.cursorModel2.x > 1.0) {
            this.cursorModel2.x = 1.0;
        }
        this.cursorModel2.y = ((double)this.epiDb.getEpiCenter().getEpi_z() - this.mapModelZ.y) / this.mapModelZ.height;
        this.repaint();
    }

    public void cursorModelChanged() {
        int n = this.getMapSquareSize();
        Rectangle rectangle = this.mapCursorPainter.getPaintingArea(this.getX(), this.getY(), n, n);
        LogUtil.debug(((Object)((Object)this)).getClass(), (String)(this.cursorModel.getX() + " " + this.cursorModel.getY() + " " + this.mapModel.x + " " + this.mapModel.width + " " + this.mapModel.y + " " + this.mapModel.height));
        this.repaint(this.mapCursorPainter.getPaintingArea(this.getX(), this.getY(), n, n));
        this.repaint(rectangle);
        this.epiDb.getEpiMap().updateLocation(this.epiDb.getEpiMap().getMapModel());
    }

    protected void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        if (!this.textOrGraph) {
            Object object3;
            SuiteTheme suiteTheme = ThemeManager.getInstance().getTheme();
            Graphics2D graphics2D = (Graphics2D)graphics;
            graphics2D.setColor(suiteTheme.getPlotBackgroundColor());
            graphics2D.fill(graphics2D.getClip());
            this.drawHouse(graphics2D);
            graphics2D.setColor(suiteTheme.getPlotForegroundColor());
            LayerModelController layerModelController = HypoLineManager.INSTANCE.getLayerModelController();
            LayerModel layerModel = layerModelController.getCurrentLayerModel();
            Object object2 = layerModel.getName();
            Rectangle2D rectangle2D = graphics2D.getFontMetrics().getStringBounds((String)object2, graphics2D);
            graphics2D.drawString((String)object2, 2, 2 + (int)rectangle2D.getHeight());
            object2 = "vP/vS=" + MathUtil.format2Digits((double)layerModel.getVp2vs());
            rectangle2D = graphics2D.getFontMetrics().getStringBounds((String)object2, graphics2D);
            graphics2D.drawString((String)object2, this.getWidth() - 2 - (int)rectangle2D.getWidth(), 2 + (int)rectangle2D.getHeight());
            int n = 30;
            int n2 = this.getHeight() - 30;
            this.gridPainter.paint(graphics2D, 0, 30, this.getWidth(), n2);
            double d = 0.0;
            Stroke stroke = graphics2D.getStroke();
            graphics2D.setStroke(new BasicStroke(2.0f, 0, 0, 1.0f, new float[]{10.0f}, 0.0f));
            graphics2D.drawLine(0, n, this.getWidth(), n);
            int n3 = layerModel.getLayers().size();
            int n4 = -1;
            for (Object object3 : layerModel.getLayers()) {
                Color color = ColorRamp.getBrightSonogram((double)(++n4), (double)0.0, (double)(n3 - 1));
                graphics2D.setColor(color);
                if (object3.getD() < 0.0) {
                    if (this.gridPainter.getImage() != null) break;
                    graphics2D.fillRect(0, n, this.getWidth(), this.getHeight() - n);
                    break;
                }
                int n5 = (int)(object3.getD() * (double)n2 / this.mapModelZ.height);
                if (this.gridPainter.getImage() == null) {
                    graphics2D.fillRect(0, n, this.getWidth(), n5);
                }
                graphics2D.setColor(Color.BLACK);
                graphics2D.drawLine(0, n += n5, this.getWidth(), n);
                object2 = String.format("%.2f km", d += object3.getD());
                rectangle2D = graphics2D.getFontMetrics().getStringBounds((String)object2, graphics2D);
                if (PAINTMODE != PaintMode.BOTH) {
                    graphics2D.drawString((String)object2, this.getWidth() - (int)rectangle2D.getWidth() - 2, n - 2);
                    continue;
                }
                graphics2D.drawString((String)object2, (this.getWidth() - (int)rectangle2D.getWidth()) / 4, n - 2);
            }
            this.drawHalfspaceTicks(graphics2D, 0.0);
            graphics2D.setStroke(stroke);
            switch (PAINTMODE) {
                case EW: {
                    this.mapStationsPainter.paint(graphics2D, 0, 0, this.getWidth(), n2);
                    this.mapCursorPainter.paint(graphics2D, 0, 30, this.getWidth(), n2);
                    break;
                }
                case NS: {
                    this.mapStationsPainter2.paint(graphics2D, 0, 0, this.getWidth(), n2);
                    this.mapCursorPainter2.paint(graphics2D, 0, 30, this.getWidth(), n2);
                    break;
                }
                case BOTH: {
                    this.mapStationsPainter.paint(graphics2D, 0, 0, this.getWidth() / 2, n2);
                    this.mapStationsPainter2.paint(graphics2D, this.getWidth() / 2, 30, this.getWidth() / 2, n2);
                    this.mapCursorPainter.paint(graphics2D, 0, 0, this.getWidth() / 2, n2);
                    this.mapCursorPainter2.paint(graphics2D, this.getWidth() / 2, 30, this.getWidth() / 2, n2);
                }
            }
            graphics2D.setColor(Color.BLACK);
            if (PAINTMODE == PaintMode.BOTH) {
                graphics2D.drawLine(this.getWidth() / 2, 0, this.getWidth() / 2, this.getHeight());
            }
            String string = "Cur. depth " + MathUtil.format2Digits((double)this.epiDb.getEpiCenter().getEpi_z()) + "km";
            object3 = graphics2D.getFontMetrics().getStringBounds(string, graphics2D);
            graphics2D.setColor(new Color(255, 255, 255, 200));
            graphics2D.fillRect(this.getWidth() - (int)((RectangularShape)object3).getWidth(), this.getHeight() - 22, (int)((RectangularShape)object3).getWidth(), 14);
            graphics2D.setColor(Color.BLACK);
            graphics2D.drawString(string, this.getWidth() - (int)((RectangularShape)object3).getWidth(), this.getHeight() - 10);
        }
    }

    private void drawHalfspaceTicks(Graphics2D graphics2D, double d) {
        double d2 = this.getMapModelZ().getHeight();
        int n = this.calcDepthTickIncKm();
        int n2 = (int)((double)(n * (this.getHeight() - 30)) / this.mapModelZ.height);
        int n3 = n2 + 30;
        int n4 = n;
        graphics2D.setColor(Color.BLACK);
        graphics2D.setStroke(new BasicStroke(1.0f, 0, 0));
        double d3 = d + (double)n / 2.0;
        while ((double)n4 < d2) {
            if ((double)n4 > d3) {
                String string = n4 + "km";
                graphics2D.drawString(string, 2, n3 - 2);
                graphics2D.drawLine(0, n3, 20, n3);
            }
            n3 += n2;
            n4 += n;
        }
    }

    private int calcDepthTickIncKm() {
        double d = this.mapModelZ.height;
        int n = (int)(0.75 + d / 4.0);
        int n2 = 1;
        while (n > 9) {
            n /= 10;
            n2 *= 10;
        }
        return Math.max(n2 * n, 1);
    }

    public void drawHouse(Graphics2D graphics2D) {
        SuiteTheme suiteTheme = ThemeManager.getInstance().getTheme();
        int n = (int)((double)this.getWidth() / 1.618);
        graphics2D.translate(n, 30);
        Color color = suiteTheme.getAltered(suiteTheme.getPlotBackgroundColor());
        Color color2 = suiteTheme.getAltered(color);
        graphics2D.setColor(color);
        for (Polygon polygon : this.getHousePolygons()) {
            graphics2D.fill(polygon);
            graphics2D.setColor(color2);
        }
        graphics2D.translate(-n, -30);
    }

    private Polygon[] getHousePolygons() {
        if (HOUSE_POLY_CACHE != null) {
            return HOUSE_POLY_CACHE;
        }
        int n = Math.max(4, 3);
        Polygon polygon = new Polygon();
        polygon.addPoint(17, -13);
        polygon.addPoint(0, -20);
        polygon.addPoint(-17, -13);
        Polygon polygon2 = new Polygon();
        polygon2.addPoint(-10, -13);
        polygon2.addPoint(-10, -1);
        polygon2.addPoint(10, -1);
        polygon2.addPoint(10, -13);
        Polygon polygon3 = new Polygon();
        polygon3.addPoint(-5, -1);
        polygon3.addPoint(0, -1);
        polygon3.addPoint(0, -11);
        polygon3.addPoint(-5, -11);
        Polygon polygon4 = new Polygon();
        polygon4.addPoint(8, -6);
        polygon4.addPoint(3, -6);
        polygon4.addPoint(3, -11);
        polygon4.addPoint(8, -11);
        Polygon polygon5 = new Polygon();
        polygon5.addPoint(10, -20);
        polygon5.addPoint(10 - n, -20);
        polygon5.addPoint(10 - n, -13);
        polygon5.addPoint(10, -13);
        Polygon[] polygonArray = new Polygon[]{polygon2, polygon, polygon3, polygon4, polygon5};
        HOUSE_POLY_CACHE = polygonArray;
        return HOUSE_POLY_CACHE;
    }

    public void repaintArea() {
        Object object = "<html>";
        LayerModelController layerModelController = HypoLineManager.INSTANCE.getLayerModelController();
        LayerModel layerModel = layerModelController.getCurrentLayerModel();
        object = (String)object + "<strong>Model " + layerModelController.getCurrentLayerModelHotkey() + ": " + layerModel.getName() + "</strong><br> v<sub>P</sub>/v<sub>S</sub>: " + MathUtil.format2Digits((double)layerModel.getVp2vs()) + "<br>";
        int n = 0;
        double d = 2.5;
        object = (String)object + "<table>";
        object = (String)object + "<tr align=\"CENTER\"><th>layer</th><th>thickness</th><th>v<sub>P</sub></th><th>type</th></tr>";
        object = (String)object + "<tr align=\"CENTER\"><th></th><th>[km]</th><th>[km/s]</th><th></th></tr>";
        for (Layer layer : layerModel.getLayers()) {
            if (layer.getD() > 0.0) {
                d += layer.getD();
            }
            object = (String)object + String.format(this.TABLE_LAYER_FORMAT, n + 1, layer.getD() > 0.0 ? String.format("%.2f", layer.getD()) : "inf.", layer.getVp(), layer.getWavetype() == Layer.WaveType.Unknown ? "" : layer.getWavetype().name());
            ++n;
        }
        object = (String)object + "</table><br>Current depth [km]: " + MathUtil.format2Digits((double)this.epiDb.getEpiCenter().getEpi_z()) + "<br>";
        object = (String)object + "Refraction layer: " + this.turnLayer;
        object = (String)object + "</html>";
        this.textArea.setText((String)object);
        this.mapModelZ.height = d = Math.max(d, 1.1 * (double)this.epiDb.getEpiCenter().getEpi_z() + 2.5);
        this.updateLocation(this.mapModel);
        this.epiDb.paintStationsDepth();
    }

    private void showEpiDepthInputSelection() {
        JPanel jPanel = new JPanel((LayoutManager)new TableLayout((double[][])new double[][]{{-3.0, 10.0, -1.0}, {-1.0}}));
        jPanel.add((Component)new JLabel("New epi depth [km]"), "0, 0");
        JSpinner jSpinner = new JSpinner();
        jSpinner.setModel(new SpinnerNumberModel((Number)this.epiDb.getEpiCenter().getEpi_z(), Double.valueOf(0.0), null, (Number)1.0));
        jPanel.add((Component)jSpinner, "2, 0");
        int n = JOptionPane.showConfirmDialog(HypoLineManager.INSTANCE.getHlApp().getMainFrame(), jPanel, "Choose accurate epidepth", -1);
        if (n == 0) {
            this.epiDb.updateDepth(((Double)jSpinner.getValue()).floatValue());
        }
    }

    public int getTurnLayer() {
        return this.turnLayer;
    }

    public void setTurnLayer(int n) {
        this.turnLayer = n;
        this.repaintArea();
    }

    public double getMaxZ() {
        return this.maxZ;
    }

    public void setMaxZ(double d) {
        this.maxZ = d;
    }

    private static enum PaintMode {
        EW,
        NS,
        BOTH;

    }
}

