/*
 * Decompiled with CFR 0.152.
 */
package edu.geophys.hypoline.epimap;

import edu.geophys.commons.util.SwingUtil;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import javax.swing.JComponent;

class JMapScalebar
extends JComponent {
    private static final long serialVersionUID = 5202753567336290599L;
    private static final String UNIT_KILOMETRE = "km";
    private static final String UNIT_METRE = "m";
    private static final String UNIT_CENTIMETRE = "cm";
    private String text = "";
    private double barLength;
    private SwingUtil.RenderQuality renderQuality = SwingUtil.RenderQuality.VERY_LOW;

    public JMapScalebar() {
        this.setOpaque(false);
        this.setBorder(null);
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setColor(this.getForeground());
        SwingUtil.setRenderingQuality((Graphics2D)graphics2D, (SwingUtil.RenderQuality)this.renderQuality);
        graphics2D.drawString(this.text, (this.getWidth() - (int)graphics2D.getFontMetrics().getStringBounds(this.text, null).getWidth()) / 2, this.getHeight() - 2);
        SwingUtil.setAntialiasing((Graphics2D)graphics2D, (boolean)false);
        graphics2D.drawLine((int)((double)this.getWidth() / 2.0 - this.barLength / 2.0), this.getHeight() - 1, (int)((double)this.getWidth() / 2.0 + this.barLength / 2.0), this.getHeight() - 1);
    }

    public final void setBarLengthAndCaption(double d, double d2) {
        this.barLength = d;
        this.doUpdateText(d2);
        this.doAdjustPreferredSize();
    }

    public final SwingUtil.RenderQuality getRenderQuality() {
        return this.renderQuality;
    }

    public void setRenderQuality(SwingUtil.RenderQuality renderQuality) {
        this.renderQuality = renderQuality;
    }

    private void doUpdateText(double d) {
        this.text = d >= 1.0 ? JMapScalebar.convertLenth(d) + UNIT_KILOMETRE : (d >= 0.001 ? JMapScalebar.convertLenth(d * 1000.0) + UNIT_METRE : (d > -1.0 ? JMapScalebar.convertLenth(d * 10000.0) + UNIT_CENTIMETRE : ""));
    }

    private static final String convertLenth(double d) {
        return d - Math.floor(d) < 0.001 ? String.format("%.0f ", d) : String.format("%.1f ", d);
    }

    private void doAdjustPreferredSize() {
        Dimension dimension = new Dimension();
        if (this.getFont() != null) {
            Graphics graphics = this.getGraphics();
            FontMetrics fontMetrics = graphics.getFontMetrics(this.getFont());
            Rectangle2D rectangle2D = fontMetrics.getStringBounds(this.text, graphics);
            dimension.height = 2 + (int)rectangle2D.getHeight();
            dimension.width = 2 + (int)rectangle2D.getWidth() * 2;
        }
        if ((double)dimension.width < this.barLength + 2.0) {
            dimension.width = (int)this.barLength + 2;
        }
        this.setPreferredSize(dimension);
    }
}

