/*
 * Decompiled with CFR 0.152.
 */
package edu.geophys.hypoline.epimap;

import edu.geophys.commons.ui.AbstractPainter;
import edu.geophys.commons.util.MathUtil;
import edu.geophys.hypoline.epimap.MapCursorModel;
import edu.geophys.hypoline.epimap.MapPoint;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.geom.Rectangle2D;

public class MapCirclePainter
extends AbstractPainter<MapCursorModel> {
    private final int minMag = -3;
    private final int maxMag = 4;
    private final int maxMagMultFactor = 5;
    private Color innerCrossColor = Color.GREEN;
    private final int baseInnerCrossRadius = 5;
    private int innerCrossRadius = 5;
    private double x;
    private double y;
    private double xrel = Double.NaN;
    private double yrel = Double.NaN;
    private float mag = Float.NaN;

    public MapCirclePainter(Color color) {
        this.innerCrossColor = color;
    }

    public MapCirclePainter() {
    }

    public void updateValues(Rectangle2D.Double double_) {
        if (!Double.isNaN(this.xrel) && !Double.isNaN(this.yrel)) {
            this.x = (this.xrel - double_.x) / double_.width;
            this.y = (-this.yrel - double_.y) / double_.height;
            if (!Float.isNaN(this.mag)) {
                this.innerCrossRadius = (int)(5.0 * MathUtil.convertFromTo((double)this.mag, (double)-3.0, (double)4.0, (double)1.0, (double)5.0));
            }
        }
    }

    protected void doPaint(Graphics2D graphics2D, int n, int n2) {
        MapPoint mapPoint = new MapPoint(this.x, this.y);
        if (mapPoint == null || Double.isNaN(mapPoint.getX()) || Double.isNaN(mapPoint.getY())) {
            return;
        }
        Point point = mapPoint.getAbsolutePoint(n, n2);
        this.paintInnerCross(graphics2D, point);
    }

    private void paintInnerCross(Graphics2D graphics2D, Point point) {
        graphics2D.setColor(this.innerCrossColor);
        if (Float.isNaN(this.mag)) {
            graphics2D.drawRect(point.x - this.innerCrossRadius / 2, point.y - this.innerCrossRadius / 2, this.innerCrossRadius, this.innerCrossRadius);
        } else {
            graphics2D.drawOval(point.x - this.innerCrossRadius / 2, point.y - this.innerCrossRadius / 2, this.innerCrossRadius, this.innerCrossRadius);
        }
    }

    public Color getInnerCrossColor() {
        return this.innerCrossColor;
    }

    public void setInnerCrossColor(Color color) {
        this.innerCrossColor = color;
    }

    public int getInnerCrossRadius() {
        return this.innerCrossRadius;
    }

    public void setInnerCrossRadius(int n) {
        this.innerCrossRadius = n;
    }

    public float getMag() {
        return this.mag;
    }

    public void setMag(float f) {
        this.mag = f;
    }

    public double getXrel() {
        return this.xrel;
    }

    public void setXrel(double d) {
        this.xrel = d;
    }

    public double getYrel() {
        return this.yrel;
    }

    public void setYrel(double d) {
        this.yrel = d;
    }
}

