/*
 * Decompiled with CFR 0.152.
 */
package edu.geophys.hypoline.epimap;

import edu.geophys.hypoline.epimap.BeamModel;
import edu.geophys.hypoline.epimap.MapPoint;
import java.util.Collection;
import java.util.HashMap;

public class MapStationsModel {
    private HashMap<String, Station> stations = new HashMap();
    private boolean paintUnderlyingRectangle = false;

    public void remove(String string) {
        this.stations.remove(string);
    }

    public boolean contains(String string) {
        return this.stations.containsKey(string);
    }

    public Station get(String string) {
        return this.stations.get(string);
    }

    public void set(String string, String string2, double d, double d2, StationState stationState) {
        this.set(string, string2, d, d2, null, null, stationState);
    }

    public void set(String string, String string2, double d, double d2, BeamModel beamModel, BeamModel beamModel2, StationState stationState) {
        this.stations.remove(string);
        this.stations.put(string, new Station(string, string2, d, d2, beamModel, beamModel2, stationState));
    }

    public void clear() {
        this.stations.clear();
    }

    public Collection<Station> values() {
        return this.stations.values();
    }

    public boolean isPaintUnderlyingRectangle() {
        return this.paintUnderlyingRectangle;
    }

    public void setPaintUnderlyingRectangle(boolean bl) {
        this.paintUnderlyingRectangle = bl;
    }

    public class Station {
        private final String stationName;
        private final MapPoint mapPoint = new MapPoint();
        private String captionName;
        private StationState state = StationState.GREY;
        private BeamModel beam1 = null;
        private BeamModel beam2 = null;

        public Station(String string, String string2, double d, double d2, BeamModel beamModel, BeamModel beamModel2, StationState stationState) {
            this.stationName = string;
            this.mapPoint.x = d;
            this.mapPoint.y = d2;
            this.captionName = string2;
            this.beam1 = beamModel;
            this.beam2 = beamModel2;
            this.state = stationState;
            if (this.beam1 != null) {
                this.beam1.pivotPoint = this.mapPoint;
            }
            if (this.beam2 != null) {
                this.beam2.pivotPoint = this.mapPoint;
            }
        }

        public final String getStationName() {
            return this.stationName;
        }

        public final MapPoint getMapPoint() {
            return this.mapPoint;
        }

        public final StationState getState() {
            return this.state;
        }

        public final BeamModel getBeam1() {
            return this.beam1;
        }

        public final void setBeam1(BeamModel beamModel) {
            this.beam1 = beamModel;
        }

        public final BeamModel getBeam2() {
            return this.beam2;
        }

        public final void setBeam2(BeamModel beamModel) {
            this.beam2 = beamModel;
        }

        public String getCaptionName() {
            return this.captionName;
        }

        public void setCaptionName(String string) {
            this.captionName = string;
        }
    }

    public static enum StationState {
        GREY,
        BLUE,
        GREEN;

    }
}

