/*
 * Decompiled with CFR 0.152.
 */
package edu.geophys.hypoline.epimap;

import edu.geophys.commons.util.CoordinateUtil;
import edu.geophys.commons.util.LogUtil;
import java.io.File;
import java.io.FileInputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.ShortBuffer;
import java.nio.channels.FileChannel;
import java.util.HashMap;
import java.util.Map;

public class SRTMReader {
    private static final int SECONDS_PER_MINUTE = 60;
    public static final String HGT_EXT = ".hgt";
    public static final int HGT_RES = 3;
    public static final int HGT_ROW_LENGTH = 1201;
    public static final int HGT_VOID = Short.MIN_VALUE;
    private static final Map<String, ShortBuffer> cache = new HashMap<String, ShortBuffer>();

    public static double getElevationFromHgt(String string, double d, double d2) {
        try {
            String string2 = SRTMReader.getHgtFileName(d, d2);
            if (!cache.containsKey(string2)) {
                cache.put(string2, null);
                String string3 = new File(string, string2).getPath();
                File file = new File(string3);
                if (file.exists()) {
                    ShortBuffer shortBuffer = SRTMReader.readHgtFile(string3);
                    cache.put(string2, shortBuffer);
                } else {
                    LogUtil.error(SRTMReader.class, (String)("Get elevation from HGT " + d + " " + d2 + " failed because file does not exist: => " + string3));
                }
            }
            return SRTMReader.readElevation(d, d2);
        }
        catch (Exception exception) {
            LogUtil.error(SRTMReader.class, (String)("Get elevation from HGT " + d + " " + d2 + " failed: => " + exception.getMessage()));
            return Double.NaN;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ShortBuffer readHgtFile(String string) throws Exception {
        ShortBuffer shortBuffer = null;
        try (FileChannel fileChannel = null;){
            fileChannel = new FileInputStream(string).getChannel();
            ByteBuffer byteBuffer = ByteBuffer.allocateDirect((int)fileChannel.size());
            while (byteBuffer.remaining() > 0) {
                fileChannel.read(byteBuffer);
            }
            byteBuffer.flip();
            shortBuffer = byteBuffer.order(ByteOrder.BIG_ENDIAN).asShortBuffer();
        }
        return shortBuffer;
    }

    public static double readElevation(double d, double d2) {
        String string = SRTMReader.getHgtFileName(d, d2);
        ShortBuffer shortBuffer = cache.get(string);
        if (shortBuffer == null) {
            return Double.NaN;
        }
        double d3 = SRTMReader.frac(d) * 60.0;
        double d4 = SRTMReader.frac(d2) * 60.0;
        int n = (int)Math.round(d3 * 60.0 / 3.0);
        int n2 = (int)Math.round(d4 * 60.0 / 3.0);
        int n3 = 1201 * ((n = 1201 - n) - 1) + n2;
        if (n3 < shortBuffer.limit()) {
            short s = shortBuffer.get(n3);
            if (s == Short.MIN_VALUE) {
                return Double.NaN;
            }
            return s;
        }
        return Double.NaN;
    }

    public static String getHgtFileName(double d, double d2) {
        int n = (int)d;
        int n2 = (int)d2;
        String string = "N";
        if (n < 0) {
            string = "S";
        }
        String string2 = "E";
        if (n2 < 0) {
            string2 = "W";
        }
        return String.format("%s%02d%s%03d%s", string, n, string2, n2, HGT_EXT);
    }

    public static double frac(double d) {
        long l = (long)d;
        double d2 = d - (double)l;
        return d2;
    }

    public static void main(String[] stringArray) {
        CoordinateUtil.AbsoluteResult absoluteResult = new CoordinateUtil.AbsoluteResult(31.655277777777776, 35.64861111111111);
        CoordinateUtil.AbsoluteResult absoluteResult2 = new CoordinateUtil.AbsoluteResult(31.670555555555556, 35.665);
        CoordinateUtil.AbsoluteResult absoluteResult3 = new CoordinateUtil.AbsoluteResult(31.675, 35.68138888888889);
        System.out.println("BH3 " + SRTMReader.getElevationFromHgt("/home/sick/data/srtm/", absoluteResult.latitude, absoluteResult.longitude));
        System.out.println("BH2 " + SRTMReader.getElevationFromHgt("/home/sick/data/srtm/", absoluteResult2.latitude, absoluteResult2.longitude));
        System.out.println("BH1 " + SRTMReader.getElevationFromHgt("/home/sick/data/srtm/", absoluteResult3.latitude, absoluteResult3.longitude));
    }
}

