/*
 * Decompiled with CFR 0.152.
 */
package edu.geophys.hypoline.epimap.gisexport;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.Point;
import de.micromata.opengis.kml.v_2_2_0.AltitudeMode;
import de.micromata.opengis.kml.v_2_2_0.Document;
import de.micromata.opengis.kml.v_2_2_0.Kml;
import de.micromata.opengis.kml.v_2_2_0.LineStyle;
import de.micromata.opengis.kml.v_2_2_0.Placemark;
import edu.geophys.commons.model.SNS;
import edu.geophys.commons.model.Site;
import edu.geophys.commons.model.knowledgebase.CampaignKnowledge;
import edu.geophys.commons.model.knowledgebase.StationsKnowledge;
import edu.geophys.commons.suite.SuiteManager;
import edu.geophys.commons.ui.PolyModel;
import edu.geophys.commons.util.CoordinateUtil;
import edu.geophys.commons.util.LogUtil;
import edu.geophys.hypoline.epimap.EpiCenter;
import edu.geophys.hypoline.epimap.EpiMapView;
import edu.geophys.hypoline.epimap.HypolinesModel;
import edu.geophys.hypoline.epimap.MapStationsModel;
import edu.geophys.hypoline.epimap.gisexport.KMLBase;
import edu.geophys.hypoline.epimap.gisexport.KMLCircle;
import edu.geophys.hypoline.epimap.gisexport.KMLCoordinate;
import edu.geophys.hypoline.epimap.gisexport.KMLHyperbola;
import edu.geophys.hypoline.epimap.gisexport.KMLHypo2Map;
import edu.geophys.hypoline.epimap.gisexport.KMLHypoX;
import edu.geophys.hypoline.epimap.gisexport.KMLLine;
import edu.geophys.hypoline.epimap.gisexport.KMLSite;
import java.awt.geom.PathIterator;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.geotools.data.DefaultTransaction;
import org.geotools.data.Transaction;
import org.geotools.data.collection.ListFeatureCollection;
import org.geotools.data.shapefile.ShapefileDataStore;
import org.geotools.data.shapefile.ShapefileDataStoreFactory;
import org.geotools.data.simple.SimpleFeatureSource;
import org.geotools.data.simple.SimpleFeatureStore;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.geometry.jts.JTSFactoryFinder;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class GISExportWriter {
    /*
     * WARNING - void declaration
     */
    public static void writeShapeAndKML(EpiMapView epiMapView, EpiCenter epiCenter, boolean bl) {
        Object object2;
        StationsKnowledge stationsKnowledge;
        CampaignKnowledge campaignKnowledge = SuiteManager.INSTANCE.getKnowledgebase().getCampaignKnowledge();
        Kml kml = new Kml();
        Document document = kml.createAndSetDocument();
        document.createAndAddStyle().withId("epiCenter").createAndSetIconStyle().withScale(2.0).createAndSetIcon().withHref("http://maps.google.com/mapfiles/kml/paddle/red-stars.png");
        document.createAndAddStyle().withId("stations").createAndSetIconStyle().withScale(1.0).createAndSetIcon().withHref("http://maps.google.com/mapfiles/kml/shapes/triangle.png");
        SimpleFeatureTypeBuilder simpleFeatureTypeBuilder = new SimpleFeatureTypeBuilder();
        simpleFeatureTypeBuilder.setName("Location");
        simpleFeatureTypeBuilder.setCRS((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
        simpleFeatureTypeBuilder.add("the_geom", Point.class);
        simpleFeatureTypeBuilder.add("Name", String.class);
        SimpleFeatureType simpleFeatureType = simpleFeatureTypeBuilder.buildFeatureType();
        SimpleFeatureBuilder simpleFeatureBuilder = new SimpleFeatureBuilder(simpleFeatureType);
        ArrayList<SimpleFeature> arrayList = new ArrayList<SimpleFeature>();
        SimpleFeatureTypeBuilder simpleFeatureTypeBuilder2 = new SimpleFeatureTypeBuilder();
        simpleFeatureTypeBuilder2.setName("Location");
        simpleFeatureTypeBuilder2.setCRS((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
        simpleFeatureTypeBuilder2.add("the_geom", LineString.class);
        simpleFeatureTypeBuilder2.add("Name", String.class);
        simpleFeatureTypeBuilder2.add("Color", String.class);
        SimpleFeatureType simpleFeatureType2 = simpleFeatureTypeBuilder2.buildFeatureType();
        SimpleFeatureBuilder simpleFeatureBuilder2 = new SimpleFeatureBuilder(simpleFeatureType2);
        ArrayList<SimpleFeature> arrayList2 = new ArrayList<SimpleFeature>();
        GeometryFactory geometryFactory = JTSFactoryFinder.getGeometryFactory();
        if (epiCenter.isEpiCenterSet()) {
            if (bl) {
                document.createAndAddPlacemark().withName("EpiCenter").withDescription("YELLOW").withStyleUrl("#epiCenter").createAndSetPoint().addToCoordinates(epiCenter.getLon(), epiCenter.getLat(), (double)(-epiCenter.getEpi_z()));
            } else {
                document.createAndAddPlacemark().withName("EpiCenter").withDescription("YELLOW").withStyleUrl("#epiCenter").createAndSetPoint().addToCoordinates(epiCenter.getLon(), epiCenter.getLat());
                stationsKnowledge = geometryFactory.createPoint(new Coordinate(epiCenter.getLon(), epiCenter.getLat()));
                object2 = "EpiCenter";
                simpleFeatureBuilder.add((Object)stationsKnowledge);
                simpleFeatureBuilder.add(object2);
                SimpleFeature object3 = simpleFeatureBuilder.buildFeature(null);
                arrayList.add(object3);
            }
        }
        stationsKnowledge = SuiteManager.INSTANCE.getKnowledgebase().getStationsKnowledge();
        for (MapStationsModel.Station station : ((MapStationsModel)epiMapView.getMapStationsPainter().getModel()).values()) {
            double d = station.getMapPoint().x * epiMapView.getMapModel().width + epiMapView.getMapModel().x;
            double d2 = -(station.getMapPoint().y * epiMapView.getMapModel().height + epiMapView.getMapModel().y);
            Site site = stationsKnowledge.getSiteById(station.getStationName());
            CoordinateUtil.AbsoluteResult absoluteResult = CoordinateUtil.convertRelativeToAbsolute((double)campaignKnowledge.getReferencePoint().getLatitude(), (double)campaignKnowledge.getReferencePoint().getLongitude(), (double)d, (double)d2);
            if (site != null && bl) {
                document.createAndAddPlacemark().withDescription("BLACK").withStyleUrl("#stations").withName(station.getStationName()).createAndSetPoint().addToCoordinates(absoluteResult.longitude, absoluteResult.latitude, site.getZOffsetKm());
            } else {
                document.createAndAddPlacemark().withDescription("BLACK").withStyleUrl("#stations").withName(station.getStationName()).createAndSetPoint().addToCoordinates(absoluteResult.longitude, absoluteResult.latitude);
                Point point = geometryFactory.createPoint(new Coordinate(absoluteResult.longitude, absoluteResult.latitude));
                String string = station.getStationName();
                simpleFeatureBuilder.add((Object)point);
                simpleFeatureBuilder.add((Object)string);
                SimpleFeature simpleFeature = simpleFeatureBuilder.buildFeature(null);
                arrayList.add(simpleFeature);
            }
            if (station.getBeam1() == null) continue;
            double d3 = station.getBeam1().getPivotAngle();
            double d4 = station.getBeam1().getFanAngle();
            CoordinateUtil.AbsoluteResult absoluteResult2 = CoordinateUtil.convertRelativeToAbsolute((double)campaignKnowledge.getReferencePoint().getLatitude(), (double)campaignKnowledge.getReferencePoint().getLongitude(), (double)(d + epiMapView.getMapModel().width * Math.cos(d3 - d4 / 2.0)), (double)(d2 + epiMapView.getMapModel().width * Math.sin(d3 - d4 / 2.0)));
            CoordinateUtil.AbsoluteResult absoluteResult3 = CoordinateUtil.convertRelativeToAbsolute((double)campaignKnowledge.getReferencePoint().getLatitude(), (double)campaignKnowledge.getReferencePoint().getLongitude(), (double)(d + epiMapView.getMapModel().width * Math.cos(d3 + d4 / 2.0)), (double)(d2 + epiMapView.getMapModel().width * Math.sin(d3 + d4 / 2.0)));
            Placemark placemark = document.createAndAddPlacemark().withDescription("YELLOW");
            LineStyle lineStyle = placemark.createAndAddStyle().createAndSetLineStyle();
            lineStyle.setColor("ff00A6B0");
            lineStyle.setWidth(5.0);
            de.micromata.opengis.kml.v_2_2_0.LineString lineString = placemark.withName("P-beam low").createAndSetLineString();
            lineString.addToCoordinates(absoluteResult.longitude, absoluteResult.latitude);
            lineString.addToCoordinates(absoluteResult2.longitude, absoluteResult2.latitude);
            Placemark placemark2 = document.createAndAddPlacemark().withDescription("YELLOW");
            LineStyle lineStyle2 = placemark2.createAndAddStyle().createAndSetLineStyle();
            lineStyle2.setWidth(5.0);
            lineStyle2.setColor("ff00A6B0");
            de.micromata.opengis.kml.v_2_2_0.LineString lineString2 = placemark2.withName("P-beam high").createAndSetLineString();
            lineString2.addToCoordinates(absoluteResult.longitude, absoluteResult.latitude);
            lineString2.addToCoordinates(absoluteResult3.longitude, absoluteResult3.latitude);
            LineString lineString3 = geometryFactory.createLineString(new Coordinate[]{new Coordinate(absoluteResult.longitude, absoluteResult.latitude), new Coordinate(absoluteResult2.longitude, absoluteResult2.latitude)});
            String string = "P-beam low";
            simpleFeatureBuilder2.add((Object)lineString3);
            simpleFeatureBuilder2.add((Object)string);
            simpleFeatureBuilder2.add((Object)"YELLOW");
            SimpleFeature simpleFeature = simpleFeatureBuilder2.buildFeature(null);
            arrayList2.add(simpleFeature);
            LineString lineString4 = geometryFactory.createLineString(new Coordinate[]{new Coordinate(absoluteResult.longitude, absoluteResult.latitude), new Coordinate(absoluteResult3.longitude, absoluteResult3.latitude)});
            String string2 = "P-beam high";
            simpleFeatureBuilder2.add((Object)lineString4);
            simpleFeatureBuilder2.add((Object)string2);
            simpleFeatureBuilder2.add((Object)"YELLOW");
            SimpleFeature simpleFeature2 = simpleFeatureBuilder2.buildFeature(null);
            arrayList2.add(simpleFeature2);
        }
        for (PolyModel polyModel : ((HypolinesModel)epiMapView.getHypolinesPainter().getModel()).hypolines) {
            GISExportWriter.exportPolyModel(polyModel, epiMapView, bl, campaignKnowledge, simpleFeatureBuilder2, geometryFactory, arrayList2, document);
        }
        if (epiMapView.getErrorPolygon() != null) {
            GISExportWriter.exportPolyModel(epiMapView.getErrorPolygon(), epiMapView, bl, campaignKnowledge, simpleFeatureBuilder2, geometryFactory, arrayList2, document);
        }
        object2 = SuiteManager.INSTANCE.getKnowledgebase().getTmpFolder().getAbsolutePath() + File.separator;
        try {
            void var17_25;
            String string = (String)object2;
            if (bl) {
                String string3 = string + "epizoom_abs.kml";
            } else {
                String string4 = string + "epizoom.kml";
            }
            kml.marshal(new File((String)var17_25));
            LogUtil.info(GISExportWriter.class, (String)("KML file written to: " + (String)var17_25), (boolean)true);
        }
        catch (FileNotFoundException fileNotFoundException) {
            LogUtil.error(GISExportWriter.class, (String)("Problem writing KML file: " + fileNotFoundException.getMessage()));
        }
        if (!bl) {
            GISExportWriter.writeShapeFile((String)object2 + "epizoom_points.shp", simpleFeatureType, arrayList);
            GISExportWriter.writeShapeFile((String)object2 + "epizoom_lines.shp", simpleFeatureType2, arrayList2);
        }
    }

    private static void exportPolyModel(PolyModel polyModel, EpiMapView epiMapView, boolean bl, CampaignKnowledge campaignKnowledge, SimpleFeatureBuilder simpleFeatureBuilder, GeometryFactory geometryFactory, List<SimpleFeature> list, Document document) {
        Object object;
        Placemark placemark = document.createAndAddPlacemark();
        LineStyle lineStyle = placemark.createAndAddStyle().createAndSetLineStyle();
        String string = "";
        if (!polyModel.getStation1().equals("") && !polyModel.getStation2().equals("")) {
            placemark.setDescription("BLUE");
            string = "BLUE";
            lineStyle.setColor("ffff0000");
        } else if (polyModel.getStation1().equals("ErrorPolygon")) {
            placemark.setDescription("RED");
            string = "RED";
            lineStyle.setColor("ff0000ff");
        } else {
            placemark.setDescription("GREEN");
            string = "GREEN";
            lineStyle.setColor("ff006400");
        }
        lineStyle.setWidth(5.0);
        de.micromata.opengis.kml.v_2_2_0.LineString lineString = placemark.withName(polyModel.getStation1() + "-" + polyModel.getStation2()).createAndSetLineString();
        if (bl) {
            lineString.withAltitudeMode(AltitudeMode.ABSOLUTE);
        }
        ArrayList<Coordinate> arrayList = new ArrayList<Coordinate>();
        PathIterator pathIterator = polyModel.getPath().getPathIterator(null);
        while (!pathIterator.isDone()) {
            object = new double[2];
            pathIterator.currentSegment((double[])object);
            if (object[0] != 0.0 || object[1] != 0.0) {
                double d = object[0] * epiMapView.getMapModel().width + epiMapView.getMapModel().x;
                double d2 = -(object[1] * epiMapView.getMapModel().height + epiMapView.getMapModel().y);
                if (epiMapView.getMapModel().contains(d, -d2)) {
                    CoordinateUtil.AbsoluteResult absoluteResult = CoordinateUtil.convertRelativeToAbsolute((double)campaignKnowledge.getReferencePoint().getLatitude(), (double)campaignKnowledge.getReferencePoint().getLongitude(), (double)d, (double)d2);
                    if (bl) {
                        lineString.addToCoordinates(absoluteResult.longitude, absoluteResult.latitude, campaignKnowledge.getReferencePoint().getHeight() * 1000.0);
                    } else {
                        lineString.addToCoordinates(absoluteResult.longitude, absoluteResult.latitude);
                        arrayList.add(new Coordinate(absoluteResult.longitude, absoluteResult.latitude));
                    }
                }
            }
            pathIterator.next();
        }
        object = geometryFactory.createLineString(arrayList.toArray(new Coordinate[arrayList.size()]));
        String string2 = polyModel.getStation1() + "-" + polyModel.getStation2();
        simpleFeatureBuilder.add(object);
        simpleFeatureBuilder.add((Object)string2);
        simpleFeatureBuilder.add((Object)string);
        SimpleFeature simpleFeature = simpleFeatureBuilder.buildFeature(null);
        list.add(simpleFeature);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeShapeFile(String string, SimpleFeatureType simpleFeatureType, List<SimpleFeature> list) {
        block9: {
            try {
                ShapefileDataStoreFactory shapefileDataStoreFactory = new ShapefileDataStoreFactory();
                HashMap<String, Serializable> hashMap = new HashMap<String, Serializable>();
                File file = new File(string);
                hashMap.put("url", file.toURI().toURL());
                hashMap.put("create spatial index", Boolean.TRUE);
                ShapefileDataStore shapefileDataStore = (ShapefileDataStore)shapefileDataStoreFactory.createNewDataStore(hashMap);
                shapefileDataStore.createSchema(simpleFeatureType);
                DefaultTransaction defaultTransaction = new DefaultTransaction("create");
                String string2 = shapefileDataStore.getTypeNames()[0];
                SimpleFeatureSource simpleFeatureSource = shapefileDataStore.getFeatureSource(string2);
                if (simpleFeatureSource instanceof SimpleFeatureStore) {
                    SimpleFeatureStore simpleFeatureStore = (SimpleFeatureStore)simpleFeatureSource;
                    ListFeatureCollection listFeatureCollection = new ListFeatureCollection(simpleFeatureType, list);
                    simpleFeatureStore.setTransaction((Transaction)defaultTransaction);
                    try {
                        simpleFeatureStore.addFeatures((FeatureCollection)listFeatureCollection);
                        defaultTransaction.commit();
                        break block9;
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                        defaultTransaction.rollback();
                        break block9;
                    }
                    finally {
                        defaultTransaction.close();
                    }
                }
                LogUtil.error(GISExportWriter.class, (String)("Shapefile export: " + string2 + " does not support read/write access"), (boolean)true);
            }
            catch (MalformedURLException malformedURLException) {
                LogUtil.error(GISExportWriter.class, (String)("Shapefile name cannot be converted to URL: " + malformedURLException.getMessage()), (boolean)true);
            }
            catch (IOException iOException) {
                LogUtil.error(GISExportWriter.class, (String)("Shapefile export problem: " + iOException.getMessage()), (boolean)true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public static void writeKML_Depr(EpiMapView epiMapView, EpiCenter epiCenter) {
        Object object;
        KMLBase kMLBase;
        CampaignKnowledge campaignKnowledge = SuiteManager.INSTANCE.getKnowledgebase().getCampaignKnowledge();
        StationsKnowledge stationsKnowledge = SuiteManager.INSTANCE.getKnowledgebase().getStationsKnowledge();
        KMLHypo2Map kMLHypo2Map = new KMLHypo2Map();
        CoordinateUtil.AbsoluteResult absoluteResult = CoordinateUtil.convertRelativeToAbsolute((double)campaignKnowledge.getReferencePoint().getLatitude(), (double)campaignKnowledge.getReferencePoint().getLongitude(), (double)epiMapView.getMapModel().getCenterX(), (double)epiMapView.getMapModel().getCenterY());
        kMLHypo2Map.getZoomMap().setLatitude(absoluteResult.latitude);
        kMLHypo2Map.getZoomMap().setLongitude(absoluteResult.longitude);
        CoordinateUtil.AbsoluteResult absoluteResult2 = CoordinateUtil.convertRelativeToAbsolute((double)campaignKnowledge.getReferencePoint().getLatitude(), (double)campaignKnowledge.getReferencePoint().getLongitude(), (double)epiMapView.getMapModel().getMinX(), (double)epiMapView.getMapModel().getMinY());
        CoordinateUtil.AbsoluteResult absoluteResult3 = CoordinateUtil.convertRelativeToAbsolute((double)campaignKnowledge.getReferencePoint().getLatitude(), (double)campaignKnowledge.getReferencePoint().getLongitude(), (double)epiMapView.getMapModel().getMaxX(), (double)epiMapView.getMapModel().getMaxY());
        kMLHypo2Map.getZoomMap().setHalfAxis((absoluteResult3.longitude - absoluteResult2.longitude) / 2.0);
        if (epiCenter.isEpiCenterSet()) {
            kMLHypo2Map.setHypoX(new KMLHypoX());
            kMLHypo2Map.getHypoX().setLatitude(epiCenter.getLat());
            kMLHypo2Map.getHypoX().setLongitude(epiCenter.getLon());
        }
        ArrayList<KMLBase> arrayList = new ArrayList<KMLBase>();
        for (SNS sNS : stationsKnowledge.getAllActiveSNS()) {
            for (Site object2 : sNS.getAllSitesCenterFirst()) {
                kMLBase = new KMLSite();
                ((KMLSite)kMLBase).setName(object2.getId());
                ((KMLSite)kMLBase).setDepthOverGround(object2.getZOffsetKm());
                object = CoordinateUtil.convertRelativeToAbsolute((double)campaignKnowledge.getReferencePoint().getLatitude(), (double)campaignKnowledge.getReferencePoint().getLongitude(), (double)object2.getXOffsetKm(), (double)object2.getYOffsetKm());
                ((KMLCoordinate)((Object)kMLBase)).setLatitude(((CoordinateUtil.AbsoluteResult)object).latitude);
                ((KMLCoordinate)((Object)kMLBase)).setLongitude(((CoordinateUtil.AbsoluteResult)object).longitude);
                arrayList.add(kMLBase);
            }
        }
        kMLHypo2Map.setSites(arrayList.toArray(new KMLSite[arrayList.size()]));
        ArrayList arrayList2 = new ArrayList();
        ArrayList<KMLBase> arrayList3 = new ArrayList<KMLBase>();
        int n = 0;
        int n2 = 0;
        for (PolyModel polyModel : ((HypolinesModel)epiMapView.getHypolinesPainter().getModel()).hypolines) {
            CoordinateUtil.AbsoluteResult absoluteResult4;
            double d;
            double d2;
            double[] dArray;
            PathIterator pathIterator;
            if (!polyModel.getStation1().equals("") && !polyModel.getStation2().equals("")) {
                kMLBase = new KMLHyperbola();
                ((KMLHyperbola)kMLBase).setSite1(polyModel.getStation1());
                ((KMLHyperbola)kMLBase).setSite2(polyModel.getStation2());
                ((KMLLine)kMLBase).setColor("blue");
                ((KMLLine)kMLBase).setName("Hyperbola " + n);
                object = new ArrayList();
                pathIterator = polyModel.getPath().getPathIterator(null);
                while (!pathIterator.isDone()) {
                    dArray = new double[2];
                    pathIterator.currentSegment(dArray);
                    if (dArray[0] != 0.0 || dArray[1] != 0.0) {
                        d2 = dArray[0] * epiMapView.getMapModel().width + epiMapView.getMapModel().x;
                        d = -(dArray[1] * epiMapView.getMapModel().height + epiMapView.getMapModel().y);
                        if (epiMapView.getMapModel().contains(d2, -d)) {
                            absoluteResult4 = CoordinateUtil.convertRelativeToAbsolute((double)campaignKnowledge.getReferencePoint().getLatitude(), (double)campaignKnowledge.getReferencePoint().getLongitude(), (double)d2, (double)d);
                            ((ArrayList)object).add(new KMLCoordinate(absoluteResult4.latitude, absoluteResult4.longitude));
                        }
                    }
                    pathIterator.next();
                }
                ((KMLLine)kMLBase).setCoordinates(((ArrayList)object).toArray(new KMLCoordinate[((ArrayList)object).size()]));
                arrayList2.add(kMLBase);
                ++n;
                continue;
            }
            kMLBase = new KMLCircle();
            if (!polyModel.getStation1().equals("")) {
                ((KMLCircle)kMLBase).setSite(polyModel.getStation1());
            } else {
                ((KMLCircle)kMLBase).setSite(polyModel.getStation2());
            }
            ((KMLLine)kMLBase).setColor("green");
            ((KMLLine)kMLBase).setName("tS-tP Circle " + n2);
            object = new ArrayList();
            pathIterator = polyModel.getPath().getPathIterator(null);
            while (!pathIterator.isDone()) {
                dArray = new double[2];
                pathIterator.currentSegment(dArray);
                if (dArray[0] != 0.0 || dArray[1] != 0.0) {
                    d2 = dArray[0] * epiMapView.getMapModel().width + epiMapView.getMapModel().x;
                    d = -(dArray[1] * epiMapView.getMapModel().height + epiMapView.getMapModel().y);
                    if (epiMapView.getMapModel().contains(d2, -d)) {
                        absoluteResult4 = CoordinateUtil.convertRelativeToAbsolute((double)campaignKnowledge.getReferencePoint().getLatitude(), (double)campaignKnowledge.getReferencePoint().getLongitude(), (double)d2, (double)d);
                        ((ArrayList)object).add(new KMLCoordinate(absoluteResult4.latitude, absoluteResult4.longitude));
                    }
                }
                pathIterator.next();
            }
            ((KMLLine)kMLBase).setCoordinates(((ArrayList)object).toArray(new KMLCoordinate[((ArrayList)object).size()]));
            arrayList3.add(kMLBase);
            ++n2;
        }
        kMLHypo2Map.setSiteHyperbolae(arrayList2.toArray(new KMLHyperbola[arrayList2.size()]));
        kMLHypo2Map.setSiteCircles(arrayList3.toArray(new KMLCircle[arrayList3.size()]));
        try (Object object3 = null;){
            String string = SuiteManager.INSTANCE.getKnowledgebase().getTmpFolder().getAbsolutePath() + File.separator + "epizoom.kml";
            object3 = new PrintWriter(string);
            kMLHypo2Map.writeKML((PrintWriter)object3);
            LogUtil.info(GISExportWriter.class, (String)("KML file written to: " + string), (boolean)true);
        }
    }
}

