/*
 * Decompiled with CFR 0.152.
 */
package edu.geophys.hypoline.epimap.gisexport;

import edu.geophys.commons.util.JAXBSerializable;
import edu.geophys.hypoline.epimap.gisexport.KMLBase;
import edu.geophys.hypoline.epimap.gisexport.KMLCircle;
import edu.geophys.hypoline.epimap.gisexport.KMLHyperbola;
import edu.geophys.hypoline.epimap.gisexport.KMLHypoX;
import edu.geophys.hypoline.epimap.gisexport.KMLSite;
import edu.geophys.hypoline.epimap.gisexport.KMLTriplePoint;
import edu.geophys.hypoline.epimap.gisexport.KMLTriplePointArea;
import edu.geophys.hypoline.epimap.gisexport.KMLZoomMap;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlElementWrapper;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlType;
import java.io.IOException;
import java.io.PrintWriter;

@XmlRootElement(name="hypo2map")
@XmlType(name="tHypo2Map", propOrder={"zoomMap", "hypoX", "sites", "siteHyperbolae", "siteCircles", "triplePoints", "triplePointArea"})
class KMLHypo2Map
implements KMLBase,
JAXBSerializable {
    private static final String headerTemplate = "<?xml version= \"1.0\" encoding=\"UTF-8\"?><kml xmlns=\"http://earth.google.com/kml/2.2\"><Document><name>KMLHypo2Map</name><Style id=\"yellowLineGreenPoly\"><LineStyle><color>7f00ffff</color><width>8</width></LineStyle></Style><Style id=\"redLine\"><LineStyle><color>7f0000ff</color><width>8</width></LineStyle></Style><Style id=\"lightredLine\"><LineStyle><color>7f3333FF</color><width>8</width></LineStyle></Style><Style id=\"greenLine\"><LineStyle><color>7f00ff00</color><width>8</width></LineStyle></Style><Style id=\"blueLine\"><LineStyle><color>7fff0000</color><width>8</width></LineStyle></Style><Style id=\"triplePoint\"><IconStyle><Icon><href>http://maps.google.com/mapfiles/kml/shapes/donut.png</href></Icon></IconStyle></Style><Style id=\"hypoBox\"><LineStyle><color>7f000000</color><width>8</width></LineStyle></Style><Style id=\"hypoX\"><IconStyle><Icon><href>http://maps.google.com/mapfiles/kml/shapes/hospitals.png</href></Icon></IconStyle></Style><Style id=\"site\"><IconStyle><Icon><href>http://maps.google.com/mapfiles/kml/shapes/triangle.png</href></Icon></IconStyle></Style>";
    private static final String folderStartTemplate = "<Folder><name>%s</name>";
    private static final String folderEndTemplate = "</Folder>";
    private static final String footerTemplate = "</Document></kml>";
    private KMLZoomMap zoomMap = new KMLZoomMap();
    private KMLHypoX hypoX = null;
    private KMLSite[] sites = new KMLSite[0];
    private KMLHyperbola[] siteHyperbolae = new KMLHyperbola[0];
    private KMLCircle[] circles = new KMLCircle[0];
    private KMLTriplePoint[] triplePoints = new KMLTriplePoint[0];
    private KMLTriplePointArea triplePointArea = null;

    KMLHypo2Map() {
    }

    @XmlElement(name="zoommap", required=true, nillable=false)
    public KMLZoomMap getZoomMap() {
        return this.zoomMap;
    }

    public void setZoomMap(KMLZoomMap kMLZoomMap) {
        this.zoomMap = kMLZoomMap;
    }

    @XmlElement(name="hypox", required=false, nillable=false)
    public KMLHypoX getHypoX() {
        return this.hypoX;
    }

    public void setHypoX(KMLHypoX kMLHypoX) {
        this.hypoX = kMLHypoX;
    }

    @XmlElement(name="site", required=false)
    @XmlElementWrapper(name="sites", required=true, nillable=false)
    public KMLSite[] getSites() {
        return this.sites;
    }

    public void setSites(KMLSite[] kMLSiteArray) {
        this.sites = kMLSiteArray;
    }

    @XmlElement(name="hyperbola", required=false)
    @XmlElementWrapper(name="hyperbolae", required=true, nillable=false)
    public KMLHyperbola[] getSiteHyperbolae() {
        return this.siteHyperbolae;
    }

    public void setSiteHyperbolae(KMLHyperbola[] kMLHyperbolaArray) {
        this.siteHyperbolae = kMLHyperbolaArray;
    }

    @XmlElement(name="circle", required=false)
    @XmlElementWrapper(name="circles", required=true, nillable=false)
    public KMLCircle[] getSiteCircles() {
        return this.circles;
    }

    public void setSiteCircles(KMLCircle[] kMLCircleArray) {
        this.circles = kMLCircleArray;
    }

    @XmlElement(name="triplepoint", required=false)
    @XmlElementWrapper(name="triplepoints", required=true, nillable=false)
    public KMLTriplePoint[] getTriplePoints() {
        return this.triplePoints;
    }

    public void setTriplePoints(KMLTriplePoint[] kMLTriplePointArray) {
        this.triplePoints = kMLTriplePointArray;
    }

    @XmlElement(name="triplepointarea", required=false, nillable=false)
    public KMLTriplePointArea getTriplePointArea() {
        return this.triplePointArea;
    }

    public void setTriplePointArea(KMLTriplePointArea kMLTriplePointArea) {
        this.triplePointArea = kMLTriplePointArea;
    }

    @Override
    public void writeKML(PrintWriter printWriter) throws IOException {
        printWriter.print(headerTemplate);
        this.zoomMap.writeKML(printWriter);
        if (this.hypoX != null) {
            this.hypoX.writeKML(printWriter);
        }
        printWriter.printf(folderStartTemplate, "Sites");
        for (KMLSite kMLBase : this.sites) {
            kMLBase.writeKML(printWriter);
        }
        printWriter.print(folderEndTemplate);
        printWriter.printf(folderStartTemplate, "Hyperbolae");
        for (KMLBase kMLBase : this.siteHyperbolae) {
            kMLBase.writeKML(printWriter);
        }
        for (KMLBase kMLBase : this.circles) {
            kMLBase.writeKML(printWriter);
        }
        printWriter.print(folderEndTemplate);
        printWriter.printf(folderStartTemplate, "TriplePoints");
        if (this.getTriplePointArea() != null) {
            this.getTriplePointArea().writeKML(printWriter);
        }
        for (KMLBase kMLBase : this.triplePoints) {
            kMLBase.writeKML(printWriter);
        }
        printWriter.print(folderEndTemplate);
        printWriter.print(footerTemplate);
    }
}

