/*
 * Decompiled with CFR 0.152.
 */
package edu.geophys.hypoline.sitecollection;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;

public class ZClassMerger {
    private final ArrayList<ZClass> zClassesList;
    private final float[] siteElevationsKm;
    private final float limit_km;
    private float[] zClasses = null;
    private int[] siteZClass = null;

    public ZClassMerger(float[] fArray, float f) {
        this.siteElevationsKm = fArray;
        this.zClassesList = new ArrayList(fArray.length);
        this.limit_km = f;
        for (int i = 0; i < fArray.length; ++i) {
            this.zClassesList.add(new ZClass(i));
        }
        this.classify();
    }

    private void classify() {
        int n;
        int n2;
        this.zClassesList.sort(Comparator.comparing(zClass -> zClass.first));
        for (n2 = 0; n2 < this.zClassesList.size() - 1; ++n2) {
            this.zClassesList.get(n2).calcDistToNext(this.zClassesList.get(n2 + 1));
        }
        n2 = 1;
        while (n2 != 0 && this.zClassesList.size() > 1) {
            n2 = 0;
            n = 0;
            double d = this.zClassesList.get(0).getDistToNext();
            for (int i = 1; i < this.zClassesList.size() - 1; ++i) {
                if (!(this.zClassesList.get(i).getDistToNext() < d)) continue;
                n = i;
                d = this.zClassesList.get(i).getDistToNext();
            }
            if (!(d < (double)this.limit_km)) continue;
            ZClass zClass2 = this.zClassesList.get(n);
            ZClass zClass3 = this.zClassesList.get(n + 1);
            ZClass zClass4 = new ZClass(zClass2, zClass3);
            if (n + 2 < this.zClassesList.size()) {
                zClass4.calcDistToNext(this.zClassesList.get(n + 2));
            }
            this.zClassesList.set(n, zClass4);
            this.zClassesList.remove(n + 1);
            n2 = 1;
        }
        Collections.reverse(this.zClassesList);
        this.zClasses = new float[this.zClassesList.size()];
        this.siteZClass = new int[this.siteElevationsKm.length];
        for (n = 0; n < this.zClassesList.size(); ++n) {
            ZClass zClass5 = this.zClassesList.get(n);
            this.zClasses[n] = zClass5.getMedianElevation();
            for (int i : zClass5.members) {
                this.siteZClass[i] = n;
            }
        }
    }

    public float[] getZClasses() {
        return this.zClasses;
    }

    public int[] getSiteZClass() {
        return this.siteZClass;
    }

    private class ZClass {
        private ArrayList<Integer> members = new ArrayList();
        public final double first;
        public final double last;
        private double distToNext = Double.NaN;

        public ZClass(int n) {
            this.members.add(n);
            this.last = this.first = (double)ZClassMerger.this.siteElevationsKm[n];
        }

        public ZClass(ZClass zClass, ZClass zClass2) {
            this.members.addAll(zClass.members);
            this.members.addAll(zClass2.members);
            this.sortMembers();
            int n = this.members.size();
            this.first = ZClassMerger.this.siteElevationsKm[this.members.get(0)];
            this.last = ZClassMerger.this.siteElevationsKm[this.members.get(n - 1)];
        }

        public float getMedianElevation() {
            int n = this.members.size();
            if (n == 0) {
                return Float.NaN;
            }
            if (n == 1) {
                return ZClassMerger.this.siteElevationsKm[this.members.get(0)];
            }
            int n2 = n / 2;
            if (n % 2 != 0) {
                return ZClassMerger.this.siteElevationsKm[this.members.get(n2)];
            }
            return 0.5f * (ZClassMerger.this.siteElevationsKm[this.members.get(n2)] + ZClassMerger.this.siteElevationsKm[this.members.get(n2 - 1)]);
        }

        private void sortMembers() {
            this.members.sort(Comparator.comparing(n -> Float.valueOf(ZClassMerger.this.siteElevationsKm[n])));
        }

        public void calcDistToNext(ZClass zClass) {
            this.distToNext = zClass.last - this.first;
        }

        public double getDistToNext() {
            return this.distToNext;
        }

        public String toString() {
            Object object = String.format("Z %.3f -> %.3f : (", this.first, this.last);
            for (int n : this.members) {
                object = (String)object + n + ", ";
            }
            object = (String)object + ")";
            return object;
        }
    }
}

