/*
 * Decompiled with CFR 0.152.
 */
package edu.geophys.hypoline.ui;

import edu.geophys.hypoline.ui.singlewindow.SingleWindowFrame;
import java.awt.Dimension;
import java.awt.Font;
import javax.swing.JEditorPane;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;

public class InitialHelpDialog {
    private String title = "Introduction to Hypoline";
    private String textAboveImage = "Welcome and thank you for using JHypoLine!\n\nPlease report any bugs you encounter to bug@geophys.uni-stuttgart.de\n\nHelp einf\u00fchrung\n\nThese welcome messages will give a brief introduction to each mode, the most important key codes and mouse options as well as explain the changes compared to older versions of JHypoline and Hypoline (C-Binary).\n\nKey code help for the different boxes within the modes is available by pressing \u201cF1\u201d inside the respective box; this will also reveal the expert options available.\n\nAll examples are based on the example data set.\n\nWindow overview:\n\n";
    private String textBelowImage = "All Modes have in common:\n\nChanges from Hypoline(C-Binary):\n\nStations selection: up to six stations will be displayed in a map view, where clicking on a station will bring up all channels of the latter, clicking on the map will switch to overview. For more than six stations a drop-down menu will be displayed.\n\nBasics:\n\nTime line and current frame: \n- left mouse button for time selection (synchronized with SonoView)\n- Mouse weel or left and right arrow keys will shift time window\n- Resampling is controlled via SonoView\nFilter:\n\n- left and right button set upper and lower frequency of bandpass filter\n\nSeismoPlot: \n\n- Selection of zoom for SeismoZoom via left and right mouse button for boundaries \n- Mouse weel or left and right arrow keys will shift time window\n- up and down arrow keys will adjust length of zoom window\n- \u201cs\u201d key to toggle through: seismogram, sonogram and overlay\n- \u201cc\u201d key for common scaling";

    public InitialHelpDialog(SingleWindowFrame singleWindowFrame) {
        Dimension dimension = new Dimension(500, 500);
        InitialHelpDialog.class.getClassLoader();
        String string = ClassLoader.getSystemResource("Overview.jpg").toString();
        JEditorPane jEditorPane = new JEditorPane();
        jEditorPane.putClientProperty("JEditorPane.honorDisplayProperties", Boolean.TRUE);
        jEditorPane.setFont(new Font("Arial", 1, 13));
        jEditorPane.setPreferredSize(dimension);
        jEditorPane.setEditable(false);
        jEditorPane.setContentType("text/html");
        jEditorPane.setText("<html>" + this.textAboveImage + "<br><br><center><img src='" + string + "' width=450 height=256></img></center><br><br>" + this.textBelowImage + "</html>");
        JOptionPane.showMessageDialog(singleWindowFrame, new JScrollPane(jEditorPane), this.title, -1);
    }

    public static void main(String[] stringArray) {
        new InitialHelpDialog(null);
    }
}

