/*
 * Decompiled with CFR 0.152.
 */
package edu.geophys.hypoline.ui;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JOptionPane;

public class MethodWarningFactory {
    private static final Map<WarningId, String> messages;
    private static final List<WarningId> disabled;
    private static final Object[] options;

    public static void showWarning(JComponent jComponent, WarningId warningId) {
        if (disabled.contains((Object)warningId)) {
            return;
        }
        String string = messages.containsKey((Object)warningId) ? messages.get((Object)warningId) : warningId.name();
        int n = JOptionPane.showOptionDialog(jComponent, string, "Suggestion", 2, 2, null, options, options[1]);
        if (n == 0) {
            disabled.add(warningId);
        }
    }

    private MethodWarningFactory() {
    }

    static {
        disabled = new LinkedList<WarningId>();
        options = new Object[]{"Don't show this warning in the future", "OK"};
        messages = new HashMap<WarningId, String>();
        messages.put(WarningId.PICK_ON_SATELLITE, "Pick coherent P and S on SNS aux traces only in ArrayBeam mode. (Picking in Network mode will not add new info but slow down graphics update)");
        messages.put(WarningId.PICK_AMP_ON_Z, "Amplitudes for Magnitude estimation can only be picked on horizontal traces.");
    }

    public static enum WarningId {
        PICK_ON_SATELLITE,
        PICK_AMP_ON_Z;

    }
}

