/*
 * Decompiled with CFR 0.152.
 */
package edu.geophys.hypoline.ui;

import edu.geophys.commons.themes.SuiteTheme;
import edu.geophys.commons.themes.ThemeManager;
import edu.geophys.commons.ui.ActivateableComponent;
import edu.geophys.commons.util.DateTimeUtil;
import edu.geophys.hypoline.epimap.EpiCenter;
import edu.geophys.hypoline.ui.Legend;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.JLabel;
import layout.TableLayout;

public class StatusPanel
extends ActivateableComponent {
    private static final long serialVersionUID = 1L;
    private static final int MARGIN = 10;
    private static final String EMPTY = " - ";
    private static final String LATLON_FMT = "%.5f";
    private static final String NE_FMT = "%.2f";
    private Mode mode = Mode.DEGREES;
    private final JLabel originTime = StatusPanel.createLabel("");
    private final JLabel latitude = StatusPanel.createLabel("");
    private final JLabel longitude = StatusPanel.createLabel("");
    private final JLabel easting = StatusPanel.createLabel("");
    private final JLabel northing = StatusPanel.createLabel("");
    private final JLabel depth = StatusPanel.createLabel("");
    private final JLabel magnitude = StatusPanel.createLabel("");
    private final JLabel resid = StatusPanel.createLabel("");
    private String dateStr = "";
    private String timeStr = "";
    private String latitudeStr = "";
    private String longitudeStr = "";
    private String eastingStr = "";
    private String northingStr = "";
    private String depthStr = "";
    private String magnitudeStr = "";
    private final JLabel latitudeLabel = StatusPanel.createLabel("lat.: ");
    private final JLabel longitudeLabel = StatusPanel.createLabel("lon.: ");
    private final JLabel northingLabel = StatusPanel.createLabel("Y: ");
    private final JLabel eastingLabel = StatusPanel.createLabel("X: ");
    private SuiteTheme theme = null;

    public StatusPanel() {
        double[][] dArrayArray = new double[][]{{10.0, -3.0, -3.0, 10.0, -3.0, -3.0, 10.0, -3.0, -3.0, 10.0, -3.0, -3.0, 10.0, -3.0, -3.0, 10.0, -1.0, -3.0, -3.0, 10.0}, {10.0, -1.0}};
        this.updatePanelTheme();
        Font font = this.getFont();
        font = new Font(font.getFontName(), 1, font.getSize());
        this.originTime.setFont(font);
        this.latitude.setFont(font);
        this.longitude.setFont(font);
        this.easting.setFont(font);
        this.northing.setFont(font);
        this.depth.setFont(font);
        this.magnitude.setFont(font);
        TableLayout tableLayout = new TableLayout((double[][])dArrayArray);
        this.setLayout((LayoutManager)tableLayout);
        this.add(StatusPanel.createLabel("origin time: "), "1,1");
        this.add(this.originTime, "2,1");
        this.add(this.latitudeLabel, "4,1");
        this.add(this.latitude, "5,1");
        this.add(this.longitudeLabel, "7,1");
        this.add(this.longitude, "8,1");
        this.add(this.eastingLabel, "4,1");
        this.add(this.easting, "5,1");
        this.add(this.northingLabel, "7,1");
        this.add(this.northing, "8,1");
        this.add(StatusPanel.createLabel("depth: "), "10,1");
        this.add(this.depth, "11,1");
        this.add(StatusPanel.createLabel("<html>M<sub>L</sub></html>: "), "13,1");
        this.add(this.magnitude, "14,1");
        JLabel jLabel = StatusPanel.createLabel("<html>P<sub>resid.</sub></html>:");
        this.add(jLabel, "17,1");
        this.add(this.resid, "18,1");
        this.updatePositionLabels();
        this.addKeyListener(new KeyListener(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                switch (keyEvent.getKeyCode()) {
                    case 67: {
                        StatusPanel.this.copyToClipboard();
                        break;
                    }
                    case 77: {
                        this.flipMode();
                        break;
                    }
                    case 112: {
                        Legend.legendf1(Legend.WindowName.STATUS);
                        break;
                    }
                }
            }

            private void flipMode() {
                switch (StatusPanel.this.mode) {
                    case CARTESIAN: {
                        StatusPanel.this.mode = Mode.DEGREES;
                        break;
                    }
                    case DEGREES: {
                        StatusPanel.this.mode = Mode.CARTESIAN;
                    }
                }
                StatusPanel.this.updatePositionLabels();
            }

            @Override
            public void keyTyped(KeyEvent keyEvent) {
            }

            @Override
            public void keyReleased(KeyEvent keyEvent) {
            }
        });
    }

    private void updatePanelTheme() {
        if (ThemeManager.getInstance().getTheme() == this.theme) {
            return;
        }
        Color color = ThemeManager.getInstance().getTheme().getHypolineGold();
        this.originTime.setForeground(color);
        this.latitude.setForeground(color);
        this.longitude.setForeground(color);
        this.easting.setForeground(color);
        this.northing.setForeground(color);
        this.depth.setForeground(color);
        this.magnitude.setForeground(color);
        this.repaint();
    }

    protected void paintComponent(Graphics graphics) {
        this.updatePanelTheme();
        super.paintComponent(graphics);
    }

    private void updatePositionLabels() {
        switch (this.mode) {
            case DEGREES: {
                this.latitudeLabel.setVisible(true);
                this.latitude.setVisible(true);
                this.longitudeLabel.setVisible(true);
                this.longitude.setVisible(true);
                this.eastingLabel.setVisible(false);
                this.easting.setVisible(false);
                this.northingLabel.setVisible(false);
                this.northing.setVisible(false);
                break;
            }
            case CARTESIAN: {
                this.latitudeLabel.setVisible(false);
                this.latitude.setVisible(false);
                this.longitudeLabel.setVisible(false);
                this.longitude.setVisible(false);
                this.eastingLabel.setVisible(true);
                this.easting.setVisible(true);
                this.northingLabel.setVisible(true);
                this.northing.setVisible(true);
            }
        }
        this.revalidate();
    }

    private static JLabel createLabel(String string) {
        JLabel jLabel = new JLabel(string){
            private static final long serialVersionUID = 1L;

            @Override
            public void setText(String string) {
                if (string.isEmpty()) {
                    string = StatusPanel.EMPTY;
                }
                super.setText(string);
            }
        };
        jLabel.setHorizontalAlignment(0);
        jLabel.setVerticalAlignment(1);
        return jLabel;
    }

    private void setOriginTime(double d) {
        this.originTime.setText(DateTimeUtil.formatDateTimeISO((double)d));
        if (Double.isNaN(d)) {
            this.originTime.setText("");
            this.dateStr = "";
            this.timeStr = "";
        } else {
            this.originTime.setText(DateTimeUtil.formatDateTimeISO((double)d));
            this.dateStr = DateTimeUtil.formatDateISO((double)d);
            this.timeStr = DateTimeUtil.formatTimeHighPrecision((double)d);
        }
    }

    private void setLatitudeNorthing(double d, double d2) {
        Object object = Double.isNaN(d) ? "" : String.format(LATLON_FMT, d) + "N";
        this.latitude.setText((String)object);
        this.latitudeStr = object;
        object = Double.isNaN(d2) ? "" : String.format(NE_FMT, d2) + " km";
        this.northing.setText((String)object);
        this.northingStr = object;
    }

    private void setLongitudeEasting(double d, double d2) {
        Object object = Double.isNaN(d) ? "" : String.format(LATLON_FMT, d) + "E";
        this.longitude.setText((String)object);
        this.longitudeStr = object;
        object = Double.isNaN(d2) ? "" : String.format(NE_FMT, d2) + " km";
        this.easting.setText((String)object);
        this.eastingStr = object;
    }

    private void setDepth(float f) {
        Object object = Float.isNaN(f) ? "" : String.format("%.1f", Float.valueOf(f)) + " km";
        this.depth.setText((String)object);
        this.depthStr = object;
    }

    public void setMagnitude(float f) {
        String string = Float.isNaN(f) ? "" : String.format("%.1f", Float.valueOf(f));
        this.magnitude.setText(string);
        this.magnitudeStr = string;
    }

    private void setResid(double d) {
        if (d < 0.0) {
            this.resid.setText("");
            return;
        }
        this.resid.setText(String.format("%.4f s", d));
    }

    public void setEpicenter(EpiCenter epiCenter) {
        this.setOriginTime(epiCenter.getOnsetTime());
        this.setLatitudeNorthing(epiCenter.getLat(), epiCenter.getY());
        this.setLongitudeEasting(epiCenter.getLon(), epiCenter.getX());
        if (Double.isNaN(epiCenter.getLon())) {
            this.setDepth(Float.NaN);
        } else {
            this.setDepth(epiCenter.getSimul_depth());
        }
        this.setResid(epiCenter.getRsdp());
    }

    private void copyToClipboard() {
        String[] stringArray;
        String[] stringArray2 = null;
        switch (this.mode) {
            case DEGREES: {
                stringArray2 = stringArray = new String[]{this.dateStr, this.timeStr, this.latitudeStr, this.longitudeStr, this.depthStr, this.magnitudeStr};
                break;
            }
            case CARTESIAN: {
                String[] stringArray3 = new String[]{this.dateStr, this.timeStr, this.eastingStr, this.northingStr, this.depthStr, this.magnitudeStr};
                stringArray2 = stringArray3;
            }
        }
        if (stringArray2 == null) {
            return;
        }
        stringArray = new StringSelection(String.join((CharSequence)",", stringArray2));
        Toolkit.getDefaultToolkit().getSystemClipboard().setContents((Transferable)stringArray, null);
    }

    static enum Mode {
        CARTESIAN,
        DEGREES;

    }
}

