/*
 * Decompiled with CFR 0.152.
 */
package edu.geophys.hypoline.ui.arraybeamprocessing;

import edu.geophys.commons.model.DefaultTrace;
import edu.geophys.commons.model.knowledgebase.CampaignKnowledge;
import edu.geophys.commons.resources.Colors;
import edu.geophys.commons.suite.SuiteManager;
import edu.geophys.commons.util.DateTimeUtil;
import edu.geophys.commons.util.LoadHeaderUtil;
import edu.geophys.commons.util.LogUtil;
import edu.geophys.commons.util.MathUtil;
import edu.geophys.hypoline.HypoLineManager;
import edu.geophys.hypoline.ui.arraybeamprocessing.BBFK;
import edu.geophys.hypoline.ui.trace.SiteModel;
import edu.geophys.hypoline.ui.trace.TraceRenderer;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import javax.swing.JComponent;

public class FKAnalysis {
    private final double tapfrac = 0.1;
    private final int prewhiten = 0;
    private double semb_thres = -1.0E9;
    private double vel_thres = -1.0E9;
    private double[][] normalizedMap;
    private double[][] geometry;
    private double sll_x;
    private double slm_x;
    private double sll_y;
    private double slm_y;

    public void update(double d, int n) {
        List<SiteModel> list = HypoLineManager.INSTANCE.getCurrentSitesDetail();
        ArrayList<SiteModel> arrayList = new ArrayList<SiteModel>();
        for (SiteModel siteModel : list) {
            if (siteModel.getTraceName(TraceRenderer.TraceType.TRACE_Z) == null) continue;
            arrayList.add(siteModel);
        }
        int n2 = arrayList.size();
        if (n2 > 1) {
            double d2 = ((SiteModel)((Object)arrayList.get(0))).getStart();
            double d3 = ((SiteModel)((Object)arrayList.get(0))).getStart() + ((SiteModel)((Object)arrayList.get(0))).getLength();
            double[][] dArrayArray = new double[n2][];
            for (int i = 0; i < dArrayArray.length; ++i) {
                float[] fArray = ((SiteModel)((Object)arrayList.get(i))).getCurrentZoomZTrace().getSamples();
                dArrayArray[i] = new double[fArray.length];
                for (int j = 0; j < fArray.length; ++j) {
                    dArrayArray[i][j] = n == 0 ? (double)fArray[j] : Math.sin((double)j * 2.0 * Math.PI * (double)n / (double)SuiteManager.INSTANCE.getKnowledgebase().getCampaignKnowledge().getGlobalSamplerate());
                }
            }
            double[][] dArray = new double[n2][2];
            for (int i = 0; i < n2; ++i) {
                dArray[i][0] = ((SiteModel)((Object)arrayList.get(i))).getXOffsetKm();
                dArray[i][1] = ((SiteModel)((Object)arrayList.get(i))).getYOffsetKm();
            }
            this.sll_x = -1.0 / d;
            this.slm_x = -this.sll_x;
            this.sll_y = this.sll_x;
            this.slm_y = -this.sll_x;
            double d4 = 1.0 / d / 100.0;
            double d5 = ((SiteModel)((Object)arrayList.get(0))).getLength();
            double d6 = 0.5;
            this.fk(dArrayArray, dArray, d5, d6, this.sll_x, this.slm_x, this.sll_y, this.slm_y, d4, this.semb_thres, this.vel_thres, 0.0, (double)SuiteManager.INSTANCE.getKnowledgebase().getCampaignKnowledge().getGlobalSamplerate() / 2.0, d2, d3);
        }
    }

    public List<Double[]> fk(double[][] dArray, double[][] dArray2, double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9, double d10, double d11, double d12, double d13) {
        ArrayList<Double[]> arrayList = new ArrayList<Double[]>();
        int n = (int)((d4 - d3) / d7 + 0.5 + 1.0);
        int n2 = (int)((d6 - d5) / d7 + 0.5 + 1.0);
        this.geometry = this.get_geometry(dArray2);
        double[][][] dArray3 = this.get_timeshift(this.geometry, d3, d5, d7, n, n2);
        int n3 = dArray.length;
        double d14 = SuiteManager.INSTANCE.getKnowledgebase().getCampaignKnowledge().getGlobalSamplerate();
        int n4 = (int)(d * d14);
        int n5 = (int)((double)n4 * d2);
        LogUtil.info(this.getClass(), (String)("No. stations: " + n3 + " no. samples: " + n4 + " no. step: " + n5));
        double d15 = d12;
        int n6 = 0;
        boolean bl = true;
        while (bl) {
            int n7;
            int n8;
            double[] dArray4 = new double[1];
            int[] nArray = new int[1];
            int[] nArray2 = new int[1];
            double[] dArray5 = new double[1];
            double[][] dArray6 = new double[n][n2];
            BBFK.bbfk(new int[n3], n6, dArray, dArray3, dArray4, dArray5, nArray, nArray2, d10, d11, d14, n4, n3, 0, n, n2, 0, dArray6, 0.1, 0, 0);
            double d16 = d3 + (double)nArray[0] * d7;
            double d17 = d5 + (double)nArray2[0] * d7;
            double d18 = Math.sqrt(d16 * d16 + d17 * d17);
            if (d18 < 1.0E-8) {
                d18 = 1.0E-8;
            }
            double d19 = 180.0 * Math.atan2(d17, d16) / Math.PI;
            double d20 = MathUtil.convertMathAngleToAzimuth((double)d19);
            if (dArray5[0] > d8 && 1.0 / d18 > d9) {
                arrayList.add(new Double[]{d15, dArray5[0], dArray4[0], d20, d18});
                LogUtil.info(this.getClass(), (String)("Time: " + DateTimeUtil.formatDateTimeISO((double)d15) + " pow: " + MathUtil.format2Digits((double)dArray5[0]) + " abspow: " + MathUtil.format2Digits((double)dArray4[0]) + " bazi: " + MathUtil.format2Digits((double)d20) + " slow: " + MathUtil.format2Digits((double)d18)));
            }
            if (d15 + (double)(n4 + n5) / d14 > d13) {
                bl = false;
            }
            n6 += n5;
            d15 += (double)n5 / d14;
            double d21 = Double.MAX_VALUE;
            double d22 = -1.7976931348623157E308;
            this.normalizedMap = new double[dArray6.length][dArray6[0].length];
            for (n8 = 0; n8 < dArray6.length; ++n8) {
                for (n7 = 0; n7 < dArray6[n8].length; ++n7) {
                    if (dArray6[n8][n7] > d22) {
                        d22 = dArray6[n8][n7];
                    }
                    if (!(dArray6[n8][n7] < d21)) continue;
                    d21 = dArray6[n8][n7];
                }
            }
            for (n8 = 0; n8 < dArray6.length; ++n8) {
                for (n7 = 0; n7 < dArray6[n8].length; ++n7) {
                    this.normalizedMap[n8][n7] = (dArray6[n8][n7] - d21) / (d22 - d21);
                }
            }
        }
        return arrayList;
    }

    private double[][] get_geometry(double[][] dArray) {
        int n;
        double[][] dArray2 = dArray;
        double d = 0.0;
        double d2 = 0.0;
        for (n = 0; n < dArray2.length; ++n) {
            d += dArray2[n][0];
            d2 += dArray2[n][1];
        }
        d /= (double)dArray2.length;
        d2 /= (double)dArray2.length;
        for (n = 0; n < dArray2.length; ++n) {
            double[] dArray3 = dArray2[n];
            dArray3[0] = dArray3[0] - d;
            double[] dArray4 = dArray2[n];
            dArray4[1] = dArray4[1] - d2;
        }
        return dArray2;
    }

    private double[][][] get_timeshift(double[][] dArray, double d, double d2, double d3, int n, int n2) {
        int n3 = dArray.length;
        double[][][] dArray2 = new double[n3][n][n2];
        for (int i = 0; i < n; ++i) {
            double d4 = d + (double)i * d3;
            for (int j = 0; j < n2; ++j) {
                double d5 = d2 + (double)j * d3;
                for (int k = 0; k < n3; ++k) {
                    dArray2[k][i][j] = d4 * dArray[k][0] + d5 * dArray[k][1];
                }
            }
        }
        return dArray2;
    }

    public static void main(String[] stringArray) {
        Locale.setDefault(Locale.UK);
        TimeZone.setDefault(TimeZone.getTimeZone("UTC"));
        LoadHeaderUtil.loadHeader((File)new File("/home/sick/geophys/knowbases/Heumoeser_Hang/Felssturz/header.sht"));
        CampaignKnowledge campaignKnowledge = SuiteManager.INSTANCE.getKnowledgebase().getCampaignKnowledge();
        String[] stringArray2 = new String[]{"S1C-SZ", "S1N-SZ", "S1W-SZ", "S1E-SZ"};
        double d = (double)campaignKnowledge.getCampaignEpochStart() / 1000.0;
        double d2 = d + 10.0;
        DefaultTrace[] defaultTraceArray = SuiteManager.INSTANCE.getTraceProvider().requestTrace(d, d2, campaignKnowledge.getGlobalSamplerate(), stringArray2);
        new FKAnalysis();
    }

    public double[][] getNormalizedMap() {
        return this.normalizedMap;
    }

    public void setNormalizedMap(double[][] dArray) {
        this.normalizedMap = dArray;
    }

    public class FKPlotter
    extends JComponent {
        private static final long serialVersionUID = 1L;
        private double[][] data;
        private double[][] geometry;
        private int colorNo = Colors.SONOGRAM.length;

        public void update(double[][] dArray, double[][] dArray2) {
            this.data = dArray;
            this.geometry = dArray2;
            this.repaint();
        }

        @Override
        protected void paintComponent(Graphics graphics) {
            super.paintComponent(graphics);
            Graphics2D graphics2D = (Graphics2D)graphics;
            if (this.data != null) {
                int n;
                int n2;
                int n3 = (int)Math.ceil((double)this.getWidth() / (double)this.data.length);
                int n4 = (int)Math.ceil((double)this.getHeight() / (double)this.data[0].length);
                for (n2 = 0; n2 < this.data.length; ++n2) {
                    for (n = 0; n < this.data[n2].length; ++n) {
                        float f = (float)MathUtil.convertFromTo((double)this.data[n2][this.data[n2].length - n - 1], (double)0.0, (double)1.0, (double)0.0, (double)(this.colorNo - 1));
                        graphics2D.setColor(Colors.SONOGRAM[(int)f]);
                        int n5 = (int)Math.floor(MathUtil.convertFromTo((double)n2, (double)0.0, (double)this.data.length, (double)0.0, (double)this.getWidth()));
                        int n6 = (int)Math.floor(MathUtil.convertFromTo((double)n, (double)0.0, (double)this.data[n2].length, (double)0.0, (double)this.getHeight()));
                        graphics2D.fillRect(n5, n6, n3, n4);
                    }
                }
                graphics2D.setColor(Color.BLACK);
                graphics2D.drawLine(0, this.getHeight() / 2, this.getWidth(), this.getHeight() / 2);
                graphics2D.drawLine(this.getWidth() / 2, 0, this.getWidth() / 2, this.getHeight());
                graphics2D.setColor(Color.BLACK);
                for (n2 = 0; n2 < this.geometry.length; ++n2) {
                    n = (int)MathUtil.convertFromTo((double)this.geometry[n2][0], (double)FKAnalysis.this.sll_x, (double)FKAnalysis.this.slm_x, (double)0.0, (double)this.getWidth());
                    int n7 = (int)MathUtil.convertFromTo((double)this.geometry[n2][1], (double)FKAnalysis.this.sll_y, (double)FKAnalysis.this.slm_y, (double)this.getHeight(), (double)0.0);
                    graphics2D.fillOval(n - 5, n7 - 5, 10, 10);
                }
            }
        }
    }
}

