/*
 * Decompiled with CFR 0.152.
 */
package edu.geophys.hypoline.ui.arrayselection;

import edu.geophys.commons.model.SNS;
import edu.geophys.commons.model.knowledgebase.StationsKnowledge;
import edu.geophys.commons.suite.SuiteManager;
import edu.geophys.commons.ui.ActivateableComponent;
import edu.geophys.hypoline.HypoLineManager;
import edu.geophys.hypoline.legacy.ArrayPositionWrapper;
import edu.geophys.hypoline.ui.Legend;
import edu.geophys.hypoline.ui.arrayselection.ArraySelectionButton;
import java.awt.LayoutManager;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.LinkedList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JOptionPane;
import javax.swing.JTextArea;
import layout.TableLayout;

public class ArraySelectionView
extends ActivateableComponent {
    private static final long serialVersionUID = 1L;
    private static int SPACING = 4;
    private final List<ArraySelectionButton> siteButtons = new LinkedList<ArraySelectionButton>();
    private final StationsKnowledge sk = SuiteManager.INSTANCE.getKnowledgebase().getStationsKnowledge();
    KeyListener keyListener = new KeyListener(){

        @Override
        public void keyReleased(KeyEvent keyEvent) {
            switch (keyEvent.getKeyCode()) {
                case 76: {
                    ArraySelectionView.this.listStations();
                    break;
                }
                case 112: {
                    if (keyEvent.isAltDown()) {
                        Legend.legendf1(Legend.WindowName.MASTEREVENT);
                        break;
                    }
                    Legend.legendf1(Legend.WindowName.SNSMAP);
                }
            }
        }

        @Override
        public void keyTyped(KeyEvent keyEvent) {
        }

        @Override
        public void keyPressed(KeyEvent keyEvent) {
        }
    };
    MouseListener overviewMouseListener = new MouseListener(){

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            HypoLineManager.INSTANCE.getConfig().setActiveSNS(-1);
            HypoLineManager.INSTANCE.updateSelectedStationDisplay();
            HypoLineManager.INSTANCE.getHlApp().getMainFrame().resetSplitPane();
        }
    };
    MouseListener arrSelMouseListener = new MouseListener(){

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            ArraySelectionButton arraySelectionButton = (ArraySelectionButton)mouseEvent.getSource();
            if (mouseEvent.getButton() == 1) {
                for (int i = 0; i < ArraySelectionView.this.sk.getAllActiveSNS().length; ++i) {
                    if (!ArraySelectionView.this.sk.getAllActiveSNS()[i].getID().equals(arraySelectionButton.getText())) continue;
                    HypoLineManager.INSTANCE.getConfig().setActiveSNS(i);
                    HypoLineManager.INSTANCE.updateSelectedStationDisplay();
                    HypoLineManager.INSTANCE.getHlApp().getMainFrame().resetSplitPane();
                    break;
                }
            } else if (mouseEvent.getButton() == 3) {
                HypoLineManager.INSTANCE.getConfig().setActiveSNS(-1);
                HypoLineManager.INSTANCE.updateSelectedStationDisplay();
                HypoLineManager.INSTANCE.getHlApp().getMainFrame().resetSplitPane();
            }
        }
    };

    public ArraySelectionView() {
        this.setBorder(BorderFactory.createEmptyBorder(SPACING, SPACING, SPACING, SPACING));
        this.addKeyListener(this.keyListener);
        this.updateView();
    }

    protected void listStations() {
        Object object = "";
        for (SNS sNS : this.sk.getAllActiveSNS()) {
            object = (String)object + sNS.getID() + "\n";
        }
        JOptionPane.showMessageDialog(HypoLineManager.INSTANCE.getHlApp().getMainFrame(), new JTextArea((String)object), "List of mini-arrays", -1);
    }

    public void updateView() {
        this.initNeighbourArraySelection();
        this.revalidate();
        this.repaint();
    }

    private void initNeighbourArraySelection() {
        HypoLineManager.INSTANCE.getAllNeighbourSNS().clear();
        TableLayout tableLayout = new TableLayout();
        tableLayout.insertColumn(0, -1.0);
        tableLayout.insertColumn(1, (double)SPACING);
        tableLayout.insertColumn(2, -1.0);
        tableLayout.insertColumn(3, (double)SPACING);
        tableLayout.insertColumn(4, -1.0);
        tableLayout.insertRow(0, -1.0);
        tableLayout.insertRow(1, (double)SPACING);
        tableLayout.insertRow(2, -1.0);
        tableLayout.insertRow(3, (double)SPACING);
        tableLayout.insertRow(4, -1.0);
        this.setLayout((LayoutManager)tableLayout);
        this.addMouseListener(this.overviewMouseListener);
        int n = 0;
        ArrayPositionWrapper arrayPositionWrapper = HypoLineManager.INSTANCE.getArrayPositionWrapper();
        for (ArrayPositionWrapper.PositionMatrixElement positionMatrixElement : arrayPositionWrapper.getPositionMatrix()) {
            if (positionMatrixElement.sns == null) continue;
            ArraySelectionButton arraySelectionButton = new ArraySelectionButton(positionMatrixElement.sns);
            this.siteButtons.add(arraySelectionButton);
            arraySelectionButton.addMouseListener(this.arrSelMouseListener);
            HypoLineManager.INSTANCE.getAllNeighbourSNS().add(positionMatrixElement.sns);
            this.add(arraySelectionButton, String.format("%d,%d", positionMatrixElement.col * 2, positionMatrixElement.row * 2));
            ++n;
        }
    }
}

