/*
 * Decompiled with CFR 0.152.
 */
package edu.geophys.hypoline.ui.arrayselection;

import edu.geophys.commons.model.SNS;
import edu.geophys.commons.model.Site;
import edu.geophys.commons.model.knowledgebase.StationsKnowledge;
import edu.geophys.commons.suite.SuiteManager;
import edu.geophys.hypoline.HypoLineManager;
import edu.geophys.hypoline.ui.singlewindow.SingleWindowFrame;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import layout.TableLayout;

public class CustomSnsSelection {
    public CustomSnsSelection(SingleWindowFrame singleWindowFrame) {
        final List<String> list = HypoLineManager.INSTANCE.getConfig().getCustomSites();
        final HashMap<JCheckBox, String> hashMap = new HashMap<JCheckBox, String>();
        TableLayout tableLayout = new TableLayout();
        JPanel jPanel = new JPanel((LayoutManager)tableLayout);
        tableLayout.insertColumn(0, -3.0);
        tableLayout.insertColumn(1, -1.0);
        int n = 0;
        StationsKnowledge stationsKnowledge = SuiteManager.INSTANCE.getKnowledgebase().getStationsKnowledge();
        for (SNS sNS : stationsKnowledge.getAllActiveSNS()) {
            for (Site site : sNS.getAllSites()) {
                if (site == null) continue;
                ArrayList<String> arrayList = new ArrayList<String>();
                arrayList.add(site.getId());
                for (String string : arrayList) {
                    final JCheckBox jCheckBox = new JCheckBox(string);
                    jCheckBox.setFocusable(false);
                    jCheckBox.setSelected(list.contains(string));
                    hashMap.put(jCheckBox, string);
                    tableLayout.insertRow(n, -3.0);
                    jPanel.add((Component)jCheckBox, "1, " + n);
                    jCheckBox.addItemListener(new ItemListener(){

                        @Override
                        public void itemStateChanged(ItemEvent itemEvent) {
                            if (jCheckBox.isSelected()) {
                                list.add((String)hashMap.get(jCheckBox));
                            } else {
                                list.remove(hashMap.get(jCheckBox));
                            }
                            if (HypoLineManager.INSTANCE.getConfig().getActiveSNS() == -1) {
                                HypoLineManager.INSTANCE.getConfig().firePropertyChange("activeSNS", false, true);
                            }
                        }
                    });
                    ++n;
                }
            }
        }
        JScrollPane jScrollPane = new JScrollPane(jPanel);
        jScrollPane.getVerticalScrollBar().setUnitIncrement(16);
        jScrollPane.setPreferredSize(new Dimension(100, 200));
        JOptionPane.showConfirmDialog(singleWindowFrame, jScrollPane, "Select traces for custom view", -1, -1);
    }
}

