/*
 * Decompiled with CFR 0.152.
 */
package edu.geophys.hypoline.ui.magnitude;

import edu.geophys.commons.themes.SuiteTheme;
import edu.geophys.commons.themes.ThemeManager;
import edu.geophys.commons.ui.ActivateableComponent;
import edu.geophys.commons.util.LocalMagnitude;
import edu.geophys.commons.util.LogUtil;
import edu.geophys.commons.util.MathUtil;
import edu.geophys.commons.util.SiPrefixedValue;
import edu.geophys.commons.util.SwingUtil;
import edu.geophys.hypoline.HypoLineManager;
import edu.geophys.hypoline.ui.Legend;
import edu.geophys.hypoline.ui.trace.SiteModel;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Stroke;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTextArea;
import javax.swing.SpinnerNumberModel;
import layout.TableLayout;

public class MagnitudePanel
extends ActivateableComponent {
    private static final long serialVersionUID = 1L;
    private final MagnitudePanel thisMagnitudePanel = this;
    private List<SiteModel> siteModels = new ArrayList<SiteModel>();
    private float meanAmpMy;
    private float meanMl;
    private float ml = Float.NaN;
    private JTextArea textArea;
    private MagnitudePanel thisVar;
    private JScrollPane scroll;
    private static double[][] ZOOM_LIMITS = new double[][]{{1000.0, 1000000.0, 1.0E-8, 0.01}, {100.0, 100000.0, 1.0E-9, 0.001}, {10.0, 30000.0, 1.0E-9, 1.0E-5}};
    private int zoomLvl = 0;
    LocalMagnitude calcMagnitude = new LocalMagnitude();
    private static final int MARGIN_W = 40;
    private static final int MARGIN_S = 20;
    private static final int MARGIN_N = 10;
    private static final int MARGIN_E = 30;
    private static final int TICK_LEN = 4;
    private static final int LABEL_OFFSET = 2;
    private static final int CROSS_SIZE = 10;
    private static final boolean DEBUG_TITLE = false;
    private static final String DEFAULT_TITLE = "Amplitude pp";
    private String title = "Amplitude pp";
    private static final float MINIMUM_MAGNITUDE = -4.0f;
    private static final float MAXIMUM_MAGNITUDE = 9.5f;
    private boolean textOrGraph = false;
    private static final Font LARGE_FONT = new Font("Arial", 1, 12);
    private static final Font LABEL_FONT = new Font("Arial", 0, 10);
    private static final Stroke CROSS_STROKE = new BasicStroke(2.0f, 1, 1);
    private static final Stroke DEFAULT_STROKE = new BasicStroke(1.0f);
    private KeyListener keyListener = new KeyListener(){

        @Override
        public void keyPressed(KeyEvent keyEvent) {
            switch (keyEvent.getKeyCode()) {
                case 66: {
                    MagnitudePanel.this.setMl(MagnitudePanel.this.meanMl);
                    break;
                }
                case 40: {
                    MagnitudePanel.this.setMl(MagnitudePanel.this.ml - 0.1f);
                    break;
                }
                case 38: {
                    MagnitudePanel.this.setMl(MagnitudePanel.this.ml + 0.1f);
                    break;
                }
                case 73: {
                    MagnitudePanel.this.showEpiDepthInputSelection();
                    break;
                }
                case 84: {
                    MagnitudePanel.this.switchView();
                    break;
                }
                case 112: {
                    if (keyEvent.isAltDown()) {
                        Legend.legendf1(Legend.WindowName.MASTEREVENT);
                        break;
                    }
                    Legend.legendf1(Legend.WindowName.MAGMAP2);
                    break;
                }
                case 39: {
                    if (MagnitudePanel.this.zoomLvl > 0) {
                        --MagnitudePanel.this.zoomLvl;
                        break;
                    }
                    return;
                }
                case 37: {
                    if (MagnitudePanel.this.zoomLvl < ZOOM_LIMITS.length - 1) {
                        ++MagnitudePanel.this.zoomLvl;
                        break;
                    }
                    return;
                }
            }
            MagnitudePanel.this.repaintArea();
            MagnitudePanel.this.repaint();
        }

        @Override
        public void keyTyped(KeyEvent keyEvent) {
        }

        @Override
        public void keyReleased(KeyEvent keyEvent) {
        }
    };

    public MagnitudePanel() {
        this.thisVar = this;
        this.addKeyListener(this.keyListener);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getButton() == 1) {
                    Point2D.Double double_ = MagnitudePanel.this.pxToValue(mouseEvent.getPoint(), new PlotMetrics(MagnitudePanel.this.thisMagnitudePanel));
                    float f = MagnitudePanel.this.calcMagnitude.calcMlPPSI(double_);
                    MagnitudePanel.this.setMl(f);
                } else if (mouseEvent.getButton() == 3) {
                    MagnitudePanel.this.deleteMl();
                } else {
                    return;
                }
                MagnitudePanel.this.repaintArea();
                MagnitudePanel.this.repaint();
            }
        });
        this.textArea = new JTextArea(){
            private static final long serialVersionUID = 1L;

            @Override
            protected void processMouseEvent(MouseEvent mouseEvent) {
                super.processMouseEvent(mouseEvent);
                if (mouseEvent.getID() == 504) {
                    MagnitudePanel.this.thisVar.setActive(true);
                } else if (mouseEvent.getID() == 505) {
                    MagnitudePanel.this.thisVar.setActive(false);
                }
            }
        };
        this.textArea.setEditable(false);
        this.textArea.setFocusable(false);
        this.textArea.setFocusable(false);
        this.textArea.setLineWrap(true);
        this.textArea.setFont(LABEL_FONT);
        this.scroll = new JScrollPane(this.textArea, 20, 31);
        this.scroll.getVerticalScrollBar().setUnitIncrement(16);
        this.setLayout((LayoutManager)new TableLayout((double[][])new double[][]{{-1.0}, {-1.0}}));
        this.setBackground(ThemeManager.getInstance().getTheme().getMapBackgroundColor());
    }

    /*
     * WARNING - void declaration
     */
    private void repaintArea() {
        String string;
        Object object = "";
        for (SiteModel object2 : this.siteModels) {
            string = "-";
            if (!Float.isNaN(object2.getMagnitudeAmpMy()) && object2.getMagnitudeAmpMy() > 0.0f) {
                string = MathUtil.format3Digits((double)object2.getMagnitudeAmpMy());
            }
            String string2 = "-";
            if (!Float.isNaN(object2.getMagnitudeMl()) && Math.abs(object2.getMagnitudeMl()) < 20.0f) {
                string2 = MathUtil.format2Digits((double)object2.getMagnitudeMl());
            }
            object = (String)object + object2.getId() + " Amp[my] " + string + " ML " + string2 + "\n";
        }
        Object object3 = "-";
        if (!Float.isNaN(this.meanAmpMy)) {
            object3 = MathUtil.format3Digits((double)this.meanAmpMy);
        }
        object = (String)object + "Mean Amp [my] " + (String)object3 + "\n";
        if (HypoLineManager.INSTANCE.getEpiMapDb().getEpiCenter().isEpiCenterSet()) {
            void var3_6;
            String string3 = "-";
            if (!Float.isNaN(this.meanMl)) {
                String string4 = MathUtil.format2Digits((double)this.meanMl);
            }
            object = (String)object + "Mean ML " + (String)var3_6 + "\n";
            string = "-";
            if (!Float.isNaN(this.ml)) {
                string = MathUtil.format2Digits((double)this.ml);
            }
            object = (String)object + "Local Magnitude " + string + "\n";
        } else {
            object = (String)object + "Epicenter not set!\n";
        }
        this.textArea.setText((String)object);
    }

    public void update() {
        this.siteModels.clear();
        int n = 0;
        int n2 = 0;
        this.meanAmpMy = 0.0f;
        this.meanMl = 0.0f;
        for (SiteModel siteModel : HypoLineManager.INSTANCE.getSites()) {
            float f;
            SiteModel siteModel2 = siteModel.getChild();
            if (siteModel2.getTraceEW() == null && siteModel2.getTraceNS() == null) continue;
            this.siteModels.add(siteModel2);
            if (!Float.isNaN(siteModel2.getMagnitudeAmpMy()) && siteModel2.getMagnitudeAmpMy() > 0.0f) {
                f = siteModel2.getMagnitudeAmpMy();
                this.meanAmpMy += f;
                ++n2;
            }
            if (Float.isNaN(siteModel2.getMagnitudeMl()) || !(Math.abs(siteModel2.getMagnitudeMl()) < 20.0f)) continue;
            f = siteModel2.getMagnitudeMl();
            this.meanMl += f;
            ++n;
        }
        this.meanAmpMy /= (float)n2;
        this.meanMl /= (float)n;
        this.repaintArea();
        this.repaint();
    }

    public float getMl() {
        return this.ml;
    }

    public void setMl(float f) {
        this.ml = f = Math.max(-4.0f, Math.min(f, 9.5f));
        LocalMagnitude localMagnitude = new LocalMagnitude();
        for (SiteModel siteModel : HypoLineManager.INSTANCE.getSites()) {
            SiteModel siteModel2 = siteModel.getChild();
            if (Double.isNaN(siteModel2.getEpiDist())) continue;
            siteModel2.setSimulatedAmplitude(localMagnitude.calcAmplitude((float)siteModel2.getEpiDist(), f));
            siteModel2.updateRepaint();
        }
        HypoLineManager.INSTANCE.getEpiMapDb().updateEpiCenter();
        HypoLineManager.INSTANCE.getStatusPanel().setMagnitude(f);
    }

    public void deleteMl() {
        this.ml = Float.NaN;
        HypoLineManager.INSTANCE.getStatusPanel().setMagnitude(Float.NaN);
    }

    private void showEpiDepthInputSelection() {
        if (HypoLineManager.INSTANCE.getEpiMapDb().getEpiCenter().isEpiCenterSet()) {
            JPanel jPanel = new JPanel((LayoutManager)new TableLayout((double[][])new double[][]{{-3.0, 10.0, -1.0}, {-1.0}}));
            jPanel.add((Component)new JLabel("New local magnitude"), "0, 0");
            JSpinner jSpinner = new JSpinner();
            jSpinner.setModel(new SpinnerNumberModel((Number)this.ml, null, null, (Number)0.1));
            jPanel.add((Component)jSpinner, "2, 0");
            int n = JOptionPane.showConfirmDialog(HypoLineManager.INSTANCE.getHlApp().getMainFrame(), jPanel, "Choose accurate epidepth", -1);
            if (n == 0) {
                this.setMl(((Double)jSpinner.getValue()).floatValue());
            }
        } else {
            LogUtil.error(((Object)((Object)this)).getClass(), (String)"Epicenter not set", (boolean)true);
        }
    }

    private void switchView() {
        this.textOrGraph = !this.textOrGraph;
        this.removeAll();
        if (this.textOrGraph) {
            this.add(this.scroll, "0, 0");
        }
        this.revalidate();
        this.repaint();
    }

    public void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        Graphics2D graphics2D = (Graphics2D)graphics;
        SwingUtil.setRenderingQuality((Graphics2D)graphics2D, (SwingUtil.RenderQuality)SwingUtil.RenderQuality.HIGH);
        PlotMetrics plotMetrics = new PlotMetrics(this);
        graphics2D.setFont(LABEL_FONT);
        graphics2D.setColor(ThemeManager.getInstance().getTheme().getHypolineBlue());
        graphics2D.setStroke(DEFAULT_STROKE);
        this.paintMagnitudeBands(graphics2D, plotMetrics);
        graphics2D.setColor(this.getForeground());
        this.paintTitle(graphics2D, plotMetrics);
        this.paintXAxis(graphics2D, plotMetrics);
        this.paintYAxis(graphics2D, plotMetrics);
        graphics2D.setColor(ThemeManager.getInstance().getTheme().getHypolineRed());
        graphics2D.setStroke(CROSS_STROKE);
        this.paintEventAmplitudes(graphics2D, plotMetrics);
        graphics2D.setFont(LARGE_FONT);
        this.paintCurrentMagnitude(graphics2D, plotMetrics);
    }

    private void paintTitle(Graphics2D graphics2D, PlotMetrics plotMetrics) {
        graphics2D.drawString(this.title, 42, 10);
    }

    private void paintCurrentMagnitude(Graphics2D graphics2D, PlotMetrics plotMetrics) {
        double d = (double)LocalMagnitude.getRangeLimitsKm()[0] * 1000.0;
        double d2 = (double)LocalMagnitude.getRangeLimitsKm()[1] * 1000.0;
        float f = this.getMl();
        if (Float.isNaN(f)) {
            return;
        }
        graphics2D.setColor(ThemeManager.getInstance().getTheme().getHypolineGold());
        Point point = this.valueToPx(new Point2D.Double(plotMetrics.valsMin.x, this.calcMagnitude.calcAmplitudePPSI(plotMetrics.valsMin.x, f)), plotMetrics);
        Point point2 = this.valueToPx(new Point2D.Double(d, this.calcMagnitude.calcAmplitudePPSI(d, f)), plotMetrics);
        if (point.x < point2.x) {
            graphics2D.drawLine(point.x, point.y, point2.x, point2.y);
        }
        point = point2;
        point2 = this.valueToPx(new Point2D.Double(d2, this.calcMagnitude.calcAmplitudePPSI(d2, f)), plotMetrics);
        graphics2D.drawLine(point.x, point.y, point2.x, point2.y);
        point = point2;
        point2 = this.valueToPx(new Point2D.Double(plotMetrics.valsMax.x, this.calcMagnitude.calcAmplitudePPSI(plotMetrics.valsMax.x, f)), plotMetrics);
        if (point.x < point2.x) {
            graphics2D.drawLine(point.x, point.y, point2.x, point2.y);
        }
        double d3 = 10.0 * plotMetrics.valsZeroZero.x;
        point = this.valueToPx(new Point2D.Double(d3, this.calcMagnitude.calcAmplitudePPSI(d3, f)), plotMetrics);
        double d4 = 0.95;
        while (point.y > plotMetrics.h - 20 && point.x > 40) {
            point = this.valueToPx(new Point2D.Double(d3 *= d4, this.calcMagnitude.calcAmplitudePPSI(d3, f)), plotMetrics);
        }
        if (point.y > plotMetrics.h - 20) {
            point = new Point(40, plotMetrics.h - 20);
        }
        String string = String.format("Ml %.1f", Float.valueOf(f));
        Rectangle2D rectangle2D = graphics2D.getFontMetrics().getStringBounds(string, graphics2D);
        while ((double)point.y - rectangle2D.getHeight() < 10.0 && (double)point.x + rectangle2D.getWidth() < (double)(plotMetrics.w - 30)) {
            point = this.valueToPx(new Point2D.Double(d3 /= d4, this.calcMagnitude.calcAmplitudePPSI(d3, f)), plotMetrics);
        }
        if ((double)point.y - rectangle2D.getHeight() < 10.0) {
            point = new Point(plotMetrics.w - 30 - (int)rectangle2D.getWidth(), 10 + (int)rectangle2D.getHeight());
        }
        Color color = graphics2D.getColor();
        graphics2D.setColor(this.getBackground());
        graphics2D.fillRect((int)(rectangle2D.getX() + (double)point.x + 4.0), (int)(rectangle2D.getY() + (double)point.y - 4.0), (int)rectangle2D.getWidth(), (int)rectangle2D.getHeight());
        graphics2D.setColor(color);
        graphics2D.drawString(string, point.x + 4, point.y - 4);
    }

    private void paintMagnitudeBands(Graphics2D graphics2D, PlotMetrics plotMetrics) {
        double d = this.calcMagnitude.calcMlPPSI(plotMetrics.valsMin);
        d = Math.max(d, -4.0);
        double d2 = this.calcMagnitude.calcMlPPSI(plotMetrics.valsMax);
        d2 = Math.min(d2, 9.0);
        double d3 = 1.0;
        double d4 = (double)LocalMagnitude.getRangeLimitsKm()[0] * 1000.0;
        double d5 = (double)LocalMagnitude.getRangeLimitsKm()[1] * 1000.0;
        if (d2 - d <= 4.0) {
            d3 = 0.5;
        }
        Point2D.Double double_ = this.pxToValue(new Point(plotMetrics.w - 30 + 4, 0), plotMetrics);
        double d6 = double_.x;
        float f = (int)d - 1;
        while ((double)f <= d2) {
            Point point = this.valueToPx(new Point2D.Double(plotMetrics.valsMin.x, this.calcMagnitude.calcAmplitudePPSI(plotMetrics.valsMin.x, f)), plotMetrics);
            Point point2 = this.valueToPx(new Point2D.Double(d4, this.calcMagnitude.calcAmplitudePPSI(d4, f)), plotMetrics);
            if (point.x < point2.x) {
                graphics2D.drawLine(point.x, point.y, point2.x, point2.y);
            }
            point = point2;
            point2 = this.valueToPx(new Point2D.Double(d5, this.calcMagnitude.calcAmplitudePPSI(d5, f)), plotMetrics);
            graphics2D.drawLine(point.x, point.y, point2.x, point2.y);
            point = point2;
            point2 = this.valueToPx(new Point2D.Double(d6, this.calcMagnitude.calcAmplitudePPSI(d6, f)), plotMetrics);
            if (point.x < point2.x) {
                graphics2D.drawLine(point.x, point.y, point2.x, point2.y);
            }
            point = this.valueToPx(new Point2D.Double(d6, this.calcMagnitude.calcAmplitudePPSI(d6, f)), plotMetrics);
            if (point.y < plotMetrics.h) {
                graphics2D.drawString(String.format("%.1f", Float.valueOf(f)), point.x + 4, point.y);
            }
            f = (float)((double)f + d3);
        }
    }

    private void paintXAxis(Graphics2D graphics2D, PlotMetrics plotMetrics) {
        Rectangle2D rectangle2D;
        String string;
        SiPrefixedValue siPrefixedValue;
        Point point;
        Point2D.Double double_;
        double d;
        graphics2D.drawLine(40, plotMetrics.h - 20, plotMetrics.w - 30 + 4, plotMetrics.h - 20);
        int n = 0;
        for (d = Math.pow(10.0, (int)Math.log10(plotMetrics.valsZeroZero.x)); d < plotMetrics.valsMax.x; d *= 10.0) {
            double_ = new Point2D.Double(d, 0.0);
            point = this.valueToPx(double_, plotMetrics);
            siPrefixedValue = new SiPrefixedValue((Number)d);
            string = String.format("%.0f%sm", Float.valueOf(siPrefixedValue.getPrefixedValue()), siPrefixedValue.getPrefix());
            rectangle2D = graphics2D.getFontMetrics().getStringBounds(string, graphics2D);
            graphics2D.drawLine(point.x, plotMetrics.h - 20, point.x, plotMetrics.h - 20 + 4);
            if (point.x < 40 || !((double)point.x + rectangle2D.getWidth() < (double)plotMetrics.w)) continue;
            graphics2D.drawString(string, point.x + 2, plotMetrics.h - 20 + 4 + (int)rectangle2D.getHeight());
            ++n;
        }
        if (n < 4) {
            for (d = 3.0 * Math.pow(10.0, (int)Math.log10(plotMetrics.valsZeroZero.x)); d < plotMetrics.valsMax.x; d *= 10.0) {
                double_ = new Point2D.Double(d, 0.0);
                point = this.valueToPx(double_, plotMetrics);
                siPrefixedValue = new SiPrefixedValue((Number)d);
                string = String.format("%.0f%sm", Float.valueOf(siPrefixedValue.getPrefixedValue()), siPrefixedValue.getPrefix());
                rectangle2D = graphics2D.getFontMetrics().getStringBounds(string, graphics2D);
                graphics2D.drawLine(point.x, plotMetrics.h - 20, point.x, plotMetrics.h - 20 + 4);
                if (point.x < 40 || !((double)point.x + rectangle2D.getWidth() < (double)plotMetrics.w)) continue;
                graphics2D.drawString(string, point.x + 2, plotMetrics.h - 20 + 4 + (int)rectangle2D.getHeight());
                ++n;
            }
        }
    }

    private void paintYAxis(Graphics2D graphics2D, PlotMetrics plotMetrics) {
        Rectangle2D rectangle2D;
        String string;
        SiPrefixedValue siPrefixedValue;
        Point point;
        Point2D.Double double_;
        double d;
        graphics2D.drawLine(40, 6, 40, plotMetrics.h - 20);
        int n = 0;
        for (d = Math.pow(10.0, (int)Math.log10(plotMetrics.valsZeroZero.y)); d < plotMetrics.valsMax.y; d *= 10.0) {
            double_ = new Point2D.Double(0.0, d);
            point = this.valueToPx(double_, plotMetrics);
            siPrefixedValue = new SiPrefixedValue((Number)d);
            string = String.format("%.0f%sm", Float.valueOf(siPrefixedValue.getPrefixedValue()), siPrefixedValue.getPrefix());
            rectangle2D = graphics2D.getFontMetrics().getStringBounds(string, graphics2D);
            graphics2D.drawLine(40, point.y, 36, point.y);
            if (!((double)point.y - rectangle2D.getHeight() > 0.0) || point.y > plotMetrics.h - 20) continue;
            graphics2D.drawString(string, 36 - (int)rectangle2D.getWidth(), point.y - 2);
            ++n;
        }
        if (n < 5) {
            for (d = 3.0 * Math.pow(10.0, (int)Math.log10(plotMetrics.valsZeroZero.y)); d < plotMetrics.valsMax.y; d *= 10.0) {
                double_ = new Point2D.Double(0.0, d);
                point = this.valueToPx(double_, plotMetrics);
                siPrefixedValue = new SiPrefixedValue((Number)d);
                string = String.format("%.0f%sm", Float.valueOf(siPrefixedValue.getPrefixedValue()), siPrefixedValue.getPrefix());
                rectangle2D = graphics2D.getFontMetrics().getStringBounds(string, graphics2D);
                graphics2D.drawLine(40, point.y, 36, point.y);
                if (!((double)point.y - rectangle2D.getHeight() > 0.0) || point.y > plotMetrics.h - 20) continue;
                graphics2D.drawString(string, 36 - (int)rectangle2D.getWidth(), point.y - 2);
                ++n;
            }
        }
    }

    private void paintEventAmplitudes(Graphics2D graphics2D, PlotMetrics plotMetrics) {
        SuiteTheme suiteTheme = ThemeManager.getInstance().getTheme();
        for (SiteModel siteModel : this.siteModels) {
            double d = siteModel.getHypoDist() * 1000.0;
            double d2 = (double)siteModel.getMagnitudeAmpMy() * 2.0E-6;
            if (Double.isNaN(d) || Double.isNaN(d2)) continue;
            Point2D.Double double_ = new Point2D.Double(d, d2);
            Point point = this.valueToPx(double_, plotMetrics);
            graphics2D.setColor(siteModel.isActiveTrace() ? suiteTheme.getHypolineRed() : suiteTheme.getHypolineGold());
            graphics2D.drawLine(point.x - 5, point.y, point.x + 5, point.y);
            graphics2D.drawLine(point.x, point.y - 5, point.x, point.y + 5);
        }
    }

    public Point valueToPx(Point2D.Double double_, PlotMetrics plotMetrics) {
        return new Point((int)(Math.log10(double_.getX() / plotMetrics.xMin) * plotMetrics.wfac) + 40, this.getHeight() - (int)(Math.log10(double_.getY() / plotMetrics.yMin) * plotMetrics.hfac) - 20);
    }

    public Point2D.Double pxToValue(Point point, PlotMetrics plotMetrics) {
        int n = point.x - 40;
        int n2 = this.getHeight() - point.y - 20;
        return new Point2D.Double(plotMetrics.xMin * Math.pow(10.0, (double)n / plotMetrics.wfac), plotMetrics.yMin * Math.pow(10.0, (double)n2 / plotMetrics.hfac));
    }

    public int getZoomLvl() {
        return this.zoomLvl;
    }

    class PlotMetrics {
        private final MagnitudePanel p;
        public final int w;
        public final int h;
        public final Point2D.Double valsMin;
        public final Point2D.Double valsMax;
        public final Point2D.Double valsZeroZero;
        public final double xMin;
        public final double xMax;
        public final double yMin;
        public final double yMax;
        public final int w_margin;
        public final int h_margin;
        public final double wfac;
        public final double hfac;

        public PlotMetrics(MagnitudePanel magnitudePanel2) {
            this.p = magnitudePanel2;
            this.w = this.p.getWidth();
            this.h = this.p.getHeight();
            MagnitudePanel.this.zoomLvl = this.p.getZoomLvl();
            this.xMin = ZOOM_LIMITS[MagnitudePanel.this.zoomLvl][0];
            this.xMax = ZOOM_LIMITS[MagnitudePanel.this.zoomLvl][1];
            this.yMin = ZOOM_LIMITS[MagnitudePanel.this.zoomLvl][2];
            this.yMax = ZOOM_LIMITS[MagnitudePanel.this.zoomLvl][3];
            this.w_margin = this.w - 40 - 30;
            this.h_margin = this.h - 10 - 20;
            this.wfac = (double)this.w_margin / Math.log10(this.xMax / this.xMin);
            this.hfac = (double)this.h_margin / Math.log10(this.yMax / this.yMin);
            this.valsMin = MagnitudePanel.this.pxToValue(new Point(0, this.h), this);
            this.valsMax = MagnitudePanel.this.pxToValue(new Point(this.w, 0), this);
            this.valsZeroZero = MagnitudePanel.this.pxToValue(new Point(40, this.h - 20), this);
        }
    }
}

