/*
 * Decompiled with CFR 0.152.
 */
package edu.geophys.hypoline.ui.singlewindow;

import edu.geophys.commons.range.DefaultRangeMarkerModel;
import edu.geophys.commons.range.RangeMarkerModel;
import edu.geophys.commons.suite.SuiteManager;
import edu.geophys.commons.ui.FrameIconSetter;
import edu.geophys.commons.ui.JAboutDialog;
import edu.geophys.commons.ui.range.JTimeRangeInteractive;
import edu.geophys.commons.util.DateTimeUtil;
import edu.geophys.commons.util.LogUtil;
import edu.geophys.commons.util.PrintUtils;
import edu.geophys.hypoline.HypoLineConfiguration;
import edu.geophys.hypoline.HypoLineManager;
import edu.geophys.hypoline.ui.Legend;
import edu.geophys.hypoline.ui.StatusPanel;
import edu.geophys.hypoline.ui.arrayselection.ArraySelectionView;
import edu.geophys.hypoline.ui.dynamicparts.First;
import edu.geophys.hypoline.ui.dynamicparts.Second;
import edu.geophys.hypoline.ui.dynamicparts.Zero;
import edu.geophys.hypoline.ui.filter.FilterView;
import edu.geophys.hypoline.ui.singlewindow.FixedLayoutManager;
import edu.geophys.hypoline.ui.singlewindow.ModeSelectionButton;
import edu.geophys.hypoline.ui.trace.StationView;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.Date;
import javax.imageio.ImageIO;
import javax.swing.Box;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JSplitPane;
import javax.swing.KeyStroke;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import layout.TableLayout;

public class SingleWindowFrame
extends JFrame {
    private static final long serialVersionUID = 1L;
    private JMenuBar jMenuBar;
    private ArraySelectionView arraySelectionView;
    private JTimeRangeInteractive timeRangeSelection;
    private StatusPanel statusPanel;
    private StationView stationView;
    private StationView stationZoomView;
    private FilterView filterView;
    private SingleWindowFrame singleWindowFrame;
    private JSplitPane splitPane;
    private Zero zero = new Zero();
    private First first = new First();
    private Second second = new Second();

    public SingleWindowFrame(String string) {
        super(string);
        this.setMinimumSize(new Dimension(1280, 768));
        this.singleWindowFrame = this;
        this.initialize();
    }

    private void initialize() {
        FrameIconSetter.setFrameIcon((JFrame)this);
        this.setLayout(new FixedLayoutManager());
        this.setJMenuBar(this.getJMenuBar());
        this.arraySelectionView = new ArraySelectionView();
        this.timeRangeSelection = new JTimeRangeInteractive();
        this.timeRangeSelection.addKeyListener(new KeyListener(){

            @Override
            public void keyReleased(KeyEvent keyEvent) {
                switch (keyEvent.getKeyCode()) {
                    case 112: {
                        if (keyEvent.isShiftDown()) {
                            Legend.legendf1(Legend.WindowName.MASTEREVENT);
                            break;
                        }
                        Legend.legendf1(Legend.WindowName.TIMELINE);
                    }
                }
            }

            @Override
            public void keyTyped(KeyEvent keyEvent) {
            }

            @Override
            public void keyPressed(KeyEvent keyEvent) {
            }
        });
        this.statusPanel = HypoLineManager.INSTANCE.getStatusPanel();
        this.stationView = new StationView((RangeMarkerModel<Object>)new DefaultRangeMarkerModel(), "1a", "1b", null);
        this.stationZoomView = new StationView((RangeMarkerModel<Object>)this.stationView.getMarkerModel().createChild("1a", "1b"), "2a", "2b", this.stationView);
        this.filterView = new FilterView();
        this.splitPane = new JSplitPane(0, true, (Component)((Object)this.stationView), (Component)((Object)this.stationZoomView));
        this.splitPane.setOneTouchExpandable(true);
        this.add((Component)((Object)this.arraySelectionView));
        this.add((Component)this.timeRangeSelection);
        this.add((Component)((Object)this.statusPanel));
        this.add(this.splitPane);
        this.add((Component)((Object)this.filterView));
        this.add(this.zero);
        this.add(this.first);
        this.add(this.second);
        this.pack();
        this.resetSplitPane();
    }

    public void resetSplitPane() {
        HypoLineConfiguration.HypoLineMode hypoLineMode = HypoLineManager.INSTANCE.getConfig().getHypoLineMode();
        boolean bl = HypoLineManager.INSTANCE.getConfig().getActiveSNS() < 0;
        this.splitPane.setDividerLocation(switch (hypoLineMode) {
            case HypoLineConfiguration.HypoLineMode.NETWORK -> (bl ? 150.0 : 100.0) / 400.0;
            case HypoLineConfiguration.HypoLineMode.ARRAY -> 0.25;
            case HypoLineConfiguration.HypoLineMode.MAGNITUDE -> (bl ? 150.0 : 80.0) / 400.0;
            default -> 0.5;
        });
    }

    public void update() {
        this.zero.update();
        this.first.update();
        this.second.update();
    }

    public final FilterView getFilterView() {
        return this.filterView;
    }

    public final StationView getStationView() {
        return this.stationView;
    }

    public final StationView getStationZoomView() {
        return this.stationZoomView;
    }

    public final JTimeRangeInteractive getTimeSelection() {
        return this.timeRangeSelection;
    }

    public ArraySelectionView getArraySelectionView() {
        return this.arraySelectionView;
    }

    public void setArraySelectionView(ArraySelectionView arraySelectionView) {
        this.arraySelectionView = arraySelectionView;
    }

    @Override
    public JMenuBar getJMenuBar() {
        this.jMenuBar = new JMenuBar();
        JMenu jMenu = new JMenu("File");
        JMenuItem jMenuItem = new JMenuItem();
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(80, 2));
        jMenuItem.setMnemonic('p');
        jMenuItem.setText("Print");
        jMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SingleWindowFrame.this.printComponents();
            }
        });
        jMenu.add(jMenuItem);
        JMenuItem jMenuItem2 = new JMenuItem();
        jMenuItem2.setAccelerator(KeyStroke.getKeyStroke(88, 2));
        jMenuItem2.setMnemonic('x');
        jMenuItem2.setText("Exit");
        jMenuItem2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                HypoLineManager.INSTANCE.getHlApp().exit();
            }
        });
        jMenu.add(jMenuItem2);
        this.jMenuBar.add(jMenu);
        JMenu jMenu2 = new JMenu("Tools");
        JMenuItem jMenuItem3 = new JMenuItem("Grid search configuration");
        jMenuItem3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                final HypoLineConfiguration hypoLineConfiguration = HypoLineManager.INSTANCE.getConfig();
                TableLayout tableLayout = new TableLayout();
                JPanel jPanel = new JPanel((LayoutManager)tableLayout);
                tableLayout.insertColumn(0, -3.0);
                tableLayout.insertColumn(1, 150.0);
                int n = 0;
                JLabel jLabel = new JLabel("gridType:");
                final JComboBox<HypoLineConfiguration.GRID_TYPE> jComboBox = new JComboBox<HypoLineConfiguration.GRID_TYPE>();
                jComboBox.setModel(new DefaultComboBoxModel<HypoLineConfiguration.GRID_TYPE>(HypoLineConfiguration.GRID_TYPE.values()));
                jComboBox.setSelectedItem((Object)hypoLineConfiguration.getGridType());
                jComboBox.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        hypoLineConfiguration.setGridType((HypoLineConfiguration.GRID_TYPE)((Object)jComboBox.getSelectedItem()));
                    }
                });
                tableLayout.insertRow(n, -3.0);
                jPanel.add((Component)jLabel, "0, " + n);
                jPanel.add(jComboBox, "1, " + n);
                JLabel jLabel2 = new JLabel("useBeamsInGridSearch:");
                final JCheckBox jCheckBox = new JCheckBox();
                jCheckBox.setSelected(hypoLineConfiguration.isUseBeamsInGrid());
                jCheckBox.addItemListener(new ItemListener(){

                    @Override
                    public void itemStateChanged(ItemEvent itemEvent) {
                        hypoLineConfiguration.setUseBeamsInGrid(jCheckBox.isSelected());
                    }
                });
                tableLayout.insertRow(++n, -3.0);
                jPanel.add((Component)jLabel2, "0, " + n);
                jPanel.add((Component)jCheckBox, "1, " + n);
                JLabel jLabel3 = new JLabel("numGridPointsXY:");
                final JSpinner jSpinner = new JSpinner();
                jSpinner.setModel(new SpinnerNumberModel(hypoLineConfiguration.getNumGrdPoints(), 1, Integer.MAX_VALUE, 100));
                jSpinner.addChangeListener(new ChangeListener(){

                    @Override
                    public void stateChanged(ChangeEvent changeEvent) {
                        hypoLineConfiguration.setNumGrdPoints((Integer)jSpinner.getValue());
                    }
                });
                tableLayout.insertRow(++n, -3.0);
                jPanel.add((Component)jLabel3, "0, " + n);
                jPanel.add((Component)jSpinner, "1, " + n);
                JLabel jLabel4 = new JLabel("numProbabilisticSamples:");
                final JSpinner jSpinner2 = new JSpinner();
                jSpinner2.setModel(new SpinnerNumberModel(hypoLineConfiguration.getProbabilisticGridSampleNum(), 1, Integer.MAX_VALUE, 10));
                jSpinner2.addChangeListener(new ChangeListener(){

                    @Override
                    public void stateChanged(ChangeEvent changeEvent) {
                        hypoLineConfiguration.setProbabilisticGridSampleNum((Integer)jSpinner2.getValue());
                    }
                });
                tableLayout.insertRow(++n, -3.0);
                jPanel.add((Component)jLabel4, "0, " + n);
                jPanel.add((Component)jSpinner2, "1, " + n);
                ++n;
                JOptionPane.showConfirmDialog(SingleWindowFrame.this.singleWindowFrame, jPanel, "Select grid search parameters", -1, -1, null);
            }
        });
        jMenu2.add(jMenuItem3);
        this.jMenuBar.add(jMenu2);
        JMenu jMenu3 = new JMenu("Results");
        JMenuItem jMenuItem4 = new JMenuItem();
        jMenuItem4.setAccelerator(KeyStroke.getKeyStroke(83, 2));
        jMenuItem4.setMnemonic('s');
        jMenuItem4.setText("Save to protocol");
        jMenuItem4.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                HypoLineManager.INSTANCE.getProtFileManager().saveToProtFile();
            }
        });
        jMenu3.add(jMenuItem4);
        JMenuItem jMenuItem5 = new JMenuItem();
        jMenuItem5.setAccelerator(KeyStroke.getKeyStroke(76, 2));
        jMenuItem5.setMnemonic('l');
        jMenuItem5.setText("Load from protocol");
        jMenuItem5.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                HypoLineManager.INSTANCE.getProtFileManager().loadFromProtFile();
            }
        });
        jMenu3.add(jMenuItem5);
        JMenuItem jMenuItem6 = new JMenuItem();
        jMenuItem6.setAccelerator(KeyStroke.getKeyStroke(83, 2));
        jMenuItem6.setMnemonic('s');
        jMenuItem6.setText("Show protocol bulletin");
        jMenuItem6.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                HypoLineManager.INSTANCE.getProtFileManager().loadFromProtFileAdvanced();
            }
        });
        jMenu3.add(jMenuItem6);
        JMenuItem jMenuItem7 = new JMenuItem();
        jMenuItem7.setAccelerator(KeyStroke.getKeyStroke(82, 2));
        jMenuItem7.setMnemonic('r');
        jMenuItem7.setText("Reset results");
        jMenuItem7.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                HypoLineManager.INSTANCE.resetAll();
            }
        });
        jMenu3.add(jMenuItem7);
        this.jMenuBar.add(jMenu3);
        JMenu jMenu4 = new JMenu("About");
        JMenuItem jMenuItem8 = new JMenuItem();
        jMenuItem8.setAccelerator(KeyStroke.getKeyStroke(65, 2));
        jMenuItem8.setMnemonic('a');
        jMenuItem8.setText("About");
        jMenuItem8.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JAboutDialog.showDialog((Frame)SingleWindowFrame.this, (boolean)true);
            }
        });
        jMenu4.add(jMenuItem8);
        this.jMenuBar.add(jMenu4);
        this.jMenuBar.add(Box.createHorizontalStrut(10));
        ModeSelectionButton modeSelectionButton = new ModeSelectionButton("P+S Phases", HypoLineConfiguration.HypoLineMode.NETWORK);
        modeSelectionButton.setMnemonic('n');
        this.jMenuBar.add(modeSelectionButton);
        this.jMenuBar.add(Box.createHorizontalStrut(10));
        ModeSelectionButton modeSelectionButton2 = new ModeSelectionButton("Array beam", HypoLineConfiguration.HypoLineMode.ARRAY);
        modeSelectionButton2.setMnemonic('a');
        this.jMenuBar.add(modeSelectionButton2);
        this.jMenuBar.add(Box.createHorizontalStrut(10));
        ModeSelectionButton modeSelectionButton3 = new ModeSelectionButton("Magnitude", HypoLineConfiguration.HypoLineMode.MAGNITUDE);
        modeSelectionButton3.setMnemonic('m');
        this.jMenuBar.add(modeSelectionButton3);
        this.jMenuBar.add(Box.createHorizontalGlue());
        return this.jMenuBar;
    }

    protected void printComponents() {
        File file = SuiteManager.INSTANCE.getProjectDirectories().getExportsDirectory();
        String string = file.toString();
        if (!file.exists() && !file.mkdirs()) {
            LogUtil.error(this.getClass(), (String)("Could not create pattern dir " + file.getAbsolutePath()));
            return;
        }
        String string2 = string + File.separator + "hypoLine-" + DateTimeUtil.formatDateTimeOnlynumbers((long)new Date().getTime());
        try {
            Graphics graphics;
            BufferedImage bufferedImage;
            Object object = this.stationView;
            if (((JComponent)object).getHeight() > 0 && ((JComponent)object).getWidth() > 0) {
                bufferedImage = new BufferedImage(((JComponent)object).getWidth(), ((JComponent)object).getHeight(), 2);
                graphics = bufferedImage.getGraphics();
                ((Component)object).paintAll(graphics);
                ImageIO.write((RenderedImage)bufferedImage, "png", new File(string2 + "-stationView.png"));
                PrintUtils.exportJComponentAsPDF((JComponent)object, (File)new File(string2 + "-stationView.pdf"), (Dimension)((Component)object).getSize());
            }
            if (((JComponent)(object = this.stationZoomView)).getHeight() > 0 && ((JComponent)object).getWidth() > 0) {
                bufferedImage = new BufferedImage(((JComponent)object).getWidth(), ((JComponent)object).getHeight(), 2);
                graphics = bufferedImage.getGraphics();
                ((Component)object).paintAll(graphics);
                ImageIO.write((RenderedImage)bufferedImage, "png", new File(string2 + "-stationViewZoom.png"));
                PrintUtils.exportJComponentAsPDF((JComponent)object, (File)new File(string2 + "-stationViewZoom.pdf"), (Dimension)((Component)object).getSize());
            }
            object = this.filterView;
            bufferedImage = new BufferedImage(((JComponent)object).getWidth(), ((JComponent)object).getHeight(), 2);
            graphics = bufferedImage.getGraphics();
            ((Component)object).paintAll(graphics);
            ImageIO.write((RenderedImage)bufferedImage, "png", new File(string2 + "-filter.png"));
            PrintUtils.exportJComponentAsPDF((JComponent)object, (File)new File(string2 + "-filter.pdf"), (Dimension)((Component)object).getSize());
            object = this.zero;
            bufferedImage = new BufferedImage(((JComponent)object).getWidth(), ((JComponent)object).getHeight(), 2);
            graphics = bufferedImage.getGraphics();
            ((Component)object).paintAll(graphics);
            ImageIO.write((RenderedImage)bufferedImage, "png", new File(string2 + "-zero.png"));
            PrintUtils.exportJComponentAsPDF((JComponent)object, (File)new File(string2 + "-zero.pdf"), (Dimension)((Component)object).getSize());
            object = this.first;
            bufferedImage = new BufferedImage(((JComponent)object).getWidth(), ((JComponent)object).getHeight(), 2);
            graphics = bufferedImage.getGraphics();
            ((Component)object).paintAll(graphics);
            ImageIO.write((RenderedImage)bufferedImage, "png", new File(string2 + "-first.png"));
            PrintUtils.exportJComponentAsPDF((JComponent)object, (File)new File(string2 + "-first.pdf"), (Dimension)((Component)object).getSize());
            object = this.second;
            bufferedImage = new BufferedImage(((JComponent)object).getWidth(), ((JComponent)object).getHeight(), 2);
            graphics = bufferedImage.getGraphics();
            ((Component)object).paintAll(graphics);
            ImageIO.write((RenderedImage)bufferedImage, "png", new File(string2 + "-second.png"));
            PrintUtils.exportJComponentAsPDF((JComponent)object, (File)new File(string2 + "-second.pdf"), (Dimension)((Component)object).getSize());
        }
        catch (IOException iOException) {
            LogUtil.error(this.getClass(), (String)("Could not save trace snapshot " + iOException.getLocalizedMessage()));
            return;
        }
        LogUtil.info(this.getClass(), (String)("Snapshot saved in " + string), (boolean)true);
    }

    public Zero getZero() {
        return this.zero;
    }

    public void setZero(Zero zero) {
        this.zero = zero;
    }

    public First getFirst() {
        return this.first;
    }

    public void setFirst(First first) {
        this.first = first;
    }

    public Second getSecond() {
        return this.second;
    }

    public void setSecond(Second second) {
        this.second = second;
    }
}

