/*
 * Decompiled with CFR 0.152.
 */
package edu.geophys.hypoline.ui.trace;

import edu.geophys.commons.ui.AbstractPaint;
import edu.geophys.commons.util.MathUtil;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.geom.Path2D;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;

public class AzimuthTraceComponent
extends AbstractPaint {
    private static final long serialVersionUID = 1L;
    protected BufferedImage buffer;
    private float[] values;

    protected void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        graphics2D.setColor(Color.BLACK);
        int n = this.getHeight() / 2;
        double d = this.getWidth() / this.values.length;
        if (this.values != null) {
            for (int i = 0; i < this.values.length; ++i) {
                int n2 = (int)MathUtil.convertFromTo((double)i, (double)0.0, (double)this.values.length, (double)0.0, (double)this.getWidth());
                graphics2D.draw(AzimuthTraceComponent.createArrowForLine(new Point(n2, n), this.values[i] + 90.0f, d, 45.0));
            }
        }
        graphics2D.dispose();
    }

    public void setValues(float[] fArray) {
        this.values = fArray;
        this.repaint();
    }

    public static Path2D createArrowForLine(Point2D point2D, double d, double d2, double d3) {
        double d4 = 2.0;
        double d5 = point2D.getX();
        double d6 = point2D.getY();
        double d7 = Math.toRadians(d);
        double d8 = Math.toRadians(d + d3);
        double d9 = Math.toRadians(d - d3);
        Path2D.Double double_ = new Path2D.Double();
        ((Path2D)double_).moveTo(d2 * Math.cos(d7) + d5, d2 * Math.sin(d7) + d6);
        ((Path2D)double_).lineTo(d5, d6);
        ((Path2D)double_).moveTo(d2 / d4 * Math.cos(d8) + d5, d2 / d4 * Math.sin(d8) + d6);
        ((Path2D)double_).lineTo(d5, d6);
        ((Path2D)double_).lineTo(d2 / d4 * Math.cos(d9) + d5, d2 / d4 * Math.sin(d9) + d6);
        return double_;
    }
}

