/*
 * Decompiled with CFR 0.152.
 */
package edu.geophys.hypoline.ui.trace;

import edu.geophys.commons.model.SNS;
import edu.geophys.commons.suite.SuiteManager;
import edu.geophys.commons.themes.ThemeManager;
import edu.geophys.commons.util.LogUtil;
import edu.geophys.commons.util.MathUtil;
import edu.geophys.hypoline.HypoLineConfiguration;
import edu.geophys.hypoline.HypoLineManager;
import edu.geophys.hypoline.ui.trace.SiteModel;
import edu.geophys.hypoline.ui.trace.StationView;
import edu.geophys.hypoline.ui.trace.TraceRenderer;
import edu.geophys.sonoview.SonogramRenderer;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.LayoutManager;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.DecimalFormat;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import layout.TableLayout;

public class LabelPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private final SiteModel site;
    private final StationView parent;
    private final String label;
    private String fixedCaption;
    private final JLabel bottomPanel = new JLabel("");
    private final JLabel middlePanel = new JLabel("");
    private DecimalFormat df = new DecimalFormat("#.#####");
    private boolean fullLabel;
    PropertyChangeListener scaleListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (propertyChangeEvent.getPropertyName().equals("update") || propertyChangeEvent.getPropertyName().equals("repaint")) {
                LogUtil.debug(this.getClass(), (String)"labelpanel update");
                if (LabelPanel.this.fixedCaption != null) {
                    LabelPanel.this.bottomPanel.setText(LabelPanel.this.fixedCaption);
                } else {
                    Object object = " [nm/s] ";
                    if (HypoLineManager.INSTANCE.getConfig().getHypoLineMode().equals((Object)HypoLineConfiguration.HypoLineMode.MAGNITUDE) && LabelPanel.this.site.getThreeComp() != null) {
                        object = " [nm] ";
                    }
                    if (LabelPanel.this.site.isPolarityFlip()) {
                        object = ((String)object).substring(0, ((String)object).length() - 1);
                        object = (String)object + "*";
                    }
                    float f = LabelPanel.this.site.getCurrentMaxValue() * 2.0f;
                    Object object2 = "";
                    if (f > 0.0f) {
                        if (HypoLineManager.INSTANCE.getMasterEventManager().isInitialized() && HypoLineManager.INSTANCE.getConfig().getHypoLineMode().equals((Object)HypoLineConfiguration.HypoLineMode.NETWORK)) {
                            object2 = (String)object2 + "<html>" + LabelPanel.this.df.format(f) + (String)object;
                            String string = Integer.toHexString(ThemeManager.getInstance().getTheme().getMEColor().getRGB());
                            string = string.substring(2, string.length());
                            object2 = (String)object2 + "<br><font color='#" + string + "'>" + LabelPanel.this.df.format((double)f / HypoLineManager.INSTANCE.getMasterEventManager().getMeAmpFactor()) + (String)object + "</font></html>";
                        } else if (LabelPanel.this.parent.getRenderMode().equals((Object)StationView.RenderMode.SONOGRAM)) {
                            float f2 = SuiteManager.INSTANCE.getKnowledgebase().getCampaignKnowledge().getGlobalSamplerate();
                            object2 = (String)object2 + MathUtil.format2Digits((double)(f2 / (float)SonogramRenderer.ifft)) + "-" + MathUtil.format2Digits((double)((double)f2 / 2.0)) + "[Hz]";
                        } else {
                            object2 = (String)object2 + LabelPanel.this.df.format(f) + (String)object;
                        }
                        LabelPanel.this.bottomPanel.setText((String)(LabelPanel.this.fullLabel ? object2 : ""));
                    } else {
                        LabelPanel.this.bottomPanel.setText("NaN");
                    }
                }
            }
        }
    };
    MouseListener middleMouseListenerParent = new MouseListener(){

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            if (mouseEvent.getButton() == 1) {
                int n = 0;
                for (SNS sNS : SuiteManager.INSTANCE.getKnowledgebase().getStationsKnowledge().getAllActiveSNS()) {
                    if (sNS.equals(LabelPanel.this.site.getSns())) {
                        HypoLineManager.INSTANCE.getConfig().setActiveSNS(n);
                        HypoLineManager.INSTANCE.updateSelectedStationDisplay();
                        HypoLineManager.INSTANCE.getHlApp().getMainFrame().resetSplitPane();
                        break;
                    }
                    ++n;
                }
            } else if (mouseEvent.getButton() == 3) {
                // empty if block
            }
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
        }
    };
    MouseListener bottomMouseListener = new MouseListener(){

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            block4: {
                block5: {
                    if (LabelPanel.this.site.getRenderMode().equals((Object)StationView.RenderMode.SONOGRAM)) break block4;
                    if (mouseEvent.getButton() != 3) break block5;
                    LabelPanel.this.site.setCurrentMaxValue(LabelPanel.this.site.getCurrentMaxValue() * 2.0f);
                    LabelPanel.this.site.updateRepaint();
                    for (SiteModel siteModel : HypoLineManager.INSTANCE.getCurrentSitesOverview()) {
                        if (!HypoLineManager.INSTANCE.getConfig().isCommonScaling() && siteModel.getId() != LabelPanel.this.site.getId()) continue;
                        siteModel.setCurrentMaxValue(LabelPanel.this.site.getCurrentMaxValue());
                        siteModel.updateRepaint();
                    }
                    for (SiteModel siteModel : HypoLineManager.INSTANCE.getCurrentSitesDetail()) {
                        if (!HypoLineManager.INSTANCE.getConfig().isCommonScaling() && siteModel.getId() != LabelPanel.this.site.getId()) continue;
                        siteModel.setCurrentMaxValue(LabelPanel.this.site.getCurrentMaxValue());
                        siteModel.updateRepaint();
                    }
                    break block4;
                }
                if (mouseEvent.getButton() != 1) break block4;
                LabelPanel.this.site.setCurrentMaxValue(LabelPanel.this.site.getCurrentMaxValue() / 2.0f);
                LabelPanel.this.site.updateRepaint();
                for (SiteModel siteModel : HypoLineManager.INSTANCE.getCurrentSitesOverview()) {
                    if (!HypoLineManager.INSTANCE.getConfig().isCommonScaling() && siteModel.getId() != LabelPanel.this.site.getId()) continue;
                    siteModel.setCurrentMaxValue(LabelPanel.this.site.getCurrentMaxValue());
                    siteModel.updateRepaint();
                }
                for (SiteModel siteModel : HypoLineManager.INSTANCE.getCurrentSitesDetail()) {
                    if (!HypoLineManager.INSTANCE.getConfig().isCommonScaling() && siteModel.getId() != LabelPanel.this.site.getId()) continue;
                    siteModel.setCurrentMaxValue(LabelPanel.this.site.getCurrentMaxValue());
                    siteModel.updateRepaint();
                }
            }
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
        }
    };
    MouseListener middleMouseListener = new MouseListener(){

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            LabelPanel.this.site.setActiveTrace(true);
            LabelPanel.this.parent.updateActiveTrace(LabelPanel.this.site);
            LabelPanel.this.parent.updateModel(false);
            if (mouseEvent.getButton() == 1) {
                LabelPanel.this.site.setpOrSActive(true);
                HypoLineManager.INSTANCE.getEpiMapDb().updateSimulation();
            } else {
                LabelPanel.this.site.setpOrSActive(false);
            }
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
        }
    };
    MouseListener topMouseListener = new MouseListener(){

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            if (mouseEvent.getButton() == 1) {
                if (HypoLineManager.INSTANCE.getConfig().getHypoLineMode().equals((Object)HypoLineConfiguration.HypoLineMode.NETWORK)) {
                    LogUtil.debug(this.getClass(), (String)("Deleting P pick of trace " + LabelPanel.this.label));
                    LabelPanel.this.site.setpPick(Double.NaN);
                } else if (HypoLineManager.INSTANCE.getConfig().getHypoLineMode().equals((Object)HypoLineConfiguration.HypoLineMode.ARRAY)) {
                    LabelPanel.this.site.setpCorr(Double.NaN);
                } else if (HypoLineManager.INSTANCE.getConfig().getHypoLineMode().equals((Object)HypoLineConfiguration.HypoLineMode.MAGNITUDE)) {
                    LabelPanel.this.site.setMagnitude1Pick(Double.NaN);
                }
            } else if (mouseEvent.getButton() == 3) {
                if (HypoLineManager.INSTANCE.getConfig().getHypoLineMode().equals((Object)HypoLineConfiguration.HypoLineMode.NETWORK)) {
                    LogUtil.debug(this.getClass(), (String)("Deleting S pick of trace " + LabelPanel.this.label));
                    LabelPanel.this.site.setsPick(Double.NaN);
                } else if (HypoLineManager.INSTANCE.getConfig().getHypoLineMode().equals((Object)HypoLineConfiguration.HypoLineMode.ARRAY)) {
                    LabelPanel.this.site.setsCorr(Double.NaN);
                } else if (HypoLineManager.INSTANCE.getConfig().getHypoLineMode().equals((Object)HypoLineConfiguration.HypoLineMode.MAGNITUDE)) {
                    LabelPanel.this.site.setMagnitude2Pick(Double.NaN);
                }
            }
            LabelPanel.this.parent.updateModel(false);
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
        }
    };

    public LabelPanel(String string, SiteModel siteModel, StationView stationView, TraceRenderer.TraceType traceType, boolean bl) {
        this(string, siteModel, stationView, bl);
    }

    public LabelPanel(String string, SiteModel siteModel, StationView stationView, String string2, boolean bl) {
        this(string, siteModel, stationView, bl);
        this.fixedCaption = string2;
    }

    public LabelPanel(String string, SiteModel siteModel, StationView stationView, boolean bl) {
        this.label = bl ? string : this.createShortLabel(string);
        this.site = siteModel;
        this.parent = stationView;
        this.fullLabel = bl;
        this.bottomPanel.setFont(this.bottomPanel.getFont().deriveFont(this.bottomPanel.getFont().getStyle() | 0, this.bottomPanel.getFont().getSize() - 3));
        this.bottomPanel.setVerticalAlignment(3);
        this.bottomPanel.setHorizontalAlignment(4);
        this.setLayout((LayoutManager)new TableLayout((double[][])new double[][]{{-1.0, -3.0}, {-1.0}}));
        JPanel jPanel = siteModel.getChild() == null ? new JPanel((LayoutManager)new TableLayout((double[][])new double[][]{{-1.0}, {-1.0, -3.0, -1.0}})) : new JPanel((LayoutManager)new TableLayout((double[][])new double[][]{{-1.0}, {-1.0}}));
        if (siteModel.getChild() == null) {
            JPanel jPanel2 = new JPanel();
            jPanel.add((Component)jPanel2, "0, 0");
            jPanel2.addMouseListener(this.topMouseListener);
        }
        this.middlePanel.setText(this.label);
        this.middlePanel.setHorizontalAlignment(4);
        if (siteModel.getChild() == null) {
            jPanel.add((Component)this.middlePanel, "0, 1");
            this.middlePanel.addMouseListener(this.middleMouseListener);
            jPanel.add((Component)this.bottomPanel, "0, 2");
            this.bottomPanel.addMouseListener(this.bottomMouseListener);
            siteModel.addPropertyChangeListener(this.scaleListener);
        } else {
            jPanel.add((Component)this.middlePanel, "0, 0");
            this.middlePanel.addMouseListener(this.middleMouseListenerParent);
        }
        this.add((Component)jPanel, "0, 0");
        this.add((Component)new TraceAxis(), "1, 0");
    }

    private String createShortLabel(String string) {
        String[] stringArray = string.split("-");
        return stringArray[stringArray.length - 1];
    }

    class TraceAxis
    extends JComponent {
        private static final long serialVersionUID = 1L;
        private final int xdist = 3;
        private final int ydist = 2;
        private final int xlength = 5;

        public TraceAxis() {
            this.setMinimumSize(new Dimension(8, this.getHeight()));
        }

        @Override
        protected void paintComponent(Graphics graphics) {
            super.paintComponent(graphics);
            Graphics2D graphics2D = (Graphics2D)graphics;
            graphics2D.drawLine(this.getWidth() - 3, 2, this.getWidth() - 3, this.getHeight() - 2);
            graphics2D.drawLine(this.getWidth() - 3, 2, this.getWidth() - 3 - 5, 2);
            graphics2D.drawLine(this.getWidth() - 3, this.getHeight() - 2, this.getWidth() - 3 - 5, this.getHeight() - 2);
        }
    }
}

