/*
 * Decompiled with CFR 0.152.
 */
package edu.geophys.hypoline.ui.trace;

import edu.geophys.commons.range.RangeMarkerModel;
import edu.geophys.commons.suite.SuiteManager;
import edu.geophys.commons.ui.ActivateableComponent;
import edu.geophys.commons.ui.SingleSonoPaint;
import edu.geophys.commons.util.MathUtil;
import edu.geophys.commons.util.PolarizationAnalysis;
import edu.geophys.hypoline.ui.trace.AzimuthTraceComponent;
import edu.geophys.hypoline.ui.trace.MouseRenderer;
import edu.geophys.hypoline.ui.trace.SiteModel;
import edu.geophys.hypoline.ui.trace.StationView;
import edu.geophys.hypoline.ui.trace.TraceRenderer;
import obspy.FiltUtil;

public class MovingPCATraceRenderer
extends TraceRenderer {
    private static final long serialVersionUID = 1L;
    private final SiteModel trace;
    private final SingleSonoPaint incidenceTrace = new SingleSonoPaint(new int[10][10]);
    private final SingleSonoPaint rectiTrace = new SingleSonoPaint(new int[10][10]);
    private final SingleSonoPaint planaTrace = new SingleSonoPaint(new int[10][10]);
    private final AzimuthTraceComponent azimuthTrace = new AzimuthTraceComponent();
    private float samprate = SuiteManager.INSTANCE.getKnowledgebase().getCampaignKnowledge().getGlobalSamplerate();
    private final int windowsize = 256;
    private final int step = Math.max(1, (int)(0.05f * this.samprate));
    private int[] flsteps = new int[]{1, 1, 4, 5, 10};
    private int[] fusteps = new int[]{10, 20, 20, 40, 30};
    private int freqstepNo = 5;
    private int sonoMax = 11;

    public MovingPCATraceRenderer(SiteModel siteModel, MouseRenderer mouseRenderer, ActivateableComponent activateableComponent, RangeMarkerModel<Object> rangeMarkerModel, String string, String string2, StationView stationView, SiteModel siteModel2) {
        super(siteModel, mouseRenderer, activateableComponent, rangeMarkerModel, string, string2, stationView);
        this.trace = siteModel2;
        this.removeMouseMotionListener(this.mouseAdapter);
        this.removeMouseListener(this.mouseAdapter);
        this.removeMouseWheelListener(this.mouseAdapter);
    }

    @Override
    public void update() {
        if (this.trace.getCurrentZoomZTrace().getSamples().length > 256 && this.trace.getCurrentZoomETrace().getSamples().length > 256 && this.trace.getCurrentZoomNTrace().getSamples().length > 256) {
            int n;
            float[] fArray = this.trace.getCurrentZoomZTrace().getSamples();
            float[] fArray2 = this.trace.getCurrentZoomETrace().getSamples();
            float[] fArray3 = this.trace.getCurrentZoomNTrace().getSamples();
            double d = Double.MAX_VALUE;
            double d2 = Double.MAX_VALUE;
            double d3 = Double.MAX_VALUE;
            double d4 = -1.7976931348623157E308;
            double d5 = -1.7976931348623157E308;
            double d6 = -1.7976931348623157E308;
            int n2 = (int)Math.ceil((fArray.length - 256) / this.step) + 1;
            double[][] dArray = new double[this.freqstepNo][n2];
            double[][] dArray2 = new double[this.freqstepNo][n2];
            double[][] dArray3 = new double[this.freqstepNo][n2];
            float[][] fArray4 = new float[this.freqstepNo][n2];
            float[][] fArray5 = new float[this.freqstepNo][fArray.length];
            float[][] fArray6 = new float[this.freqstepNo][fArray2.length];
            float[][] fArray7 = new float[this.freqstepNo][fArray3.length];
            for (n = 0; n < this.freqstepNo; ++n) {
                float f = this.flsteps[n];
                float f2 = this.fusteps[n];
                for (int i = 0; i < fArray5[n].length; ++i) {
                    fArray5[n][i] = MathUtil.hannWindow((float)fArray[i], (int)i, (int)fArray5[n].length);
                    fArray6[n][i] = MathUtil.hannWindow((float)fArray2[i], (int)i, (int)fArray6[n].length);
                    fArray7[n][i] = MathUtil.hannWindow((float)fArray3[i], (int)i, (int)fArray7[n].length);
                }
                FiltUtil.spr_bp_fast_bworth((float[])fArray5[n], (int)fArray5[n].length, (float)(1.0f / this.samprate), (float)f, (float)f2, (int)2, (boolean)false);
                FiltUtil.spr_bp_fast_bworth((float[])fArray6[n], (int)fArray6[n].length, (float)(1.0f / this.samprate), (float)f, (float)f2, (int)2, (boolean)false);
                FiltUtil.spr_bp_fast_bworth((float[])fArray7[n], (int)fArray7[n].length, (float)(1.0f / this.samprate), (float)f, (float)f2, (int)2, (boolean)false);
            }
            for (n = 0; n < fArray.length - 256; n += this.step) {
                for (int i = 0; i < this.freqstepNo; ++i) {
                    float[] fArray8 = new float[256];
                    float[] fArray9 = new float[256];
                    float[] fArray10 = new float[256];
                    for (int j = n; j < 256 + n; ++j) {
                        fArray8[j - n] = fArray5[i][j];
                        fArray9[j - n] = fArray6[i][j];
                        fArray10[j - n] = fArray7[i][j];
                    }
                    PolarizationAnalysis polarizationAnalysis = new PolarizationAnalysis(fArray8, fArray10, fArray9, this.samprate);
                    double d7 = polarizationAnalysis.getpAzimuth();
                    if (d7 > 180.0) {
                        d7 = 360.0 - d7;
                    }
                    fArray4[i][n / this.step] = (float)polarizationAnalysis.getpAzimuth();
                    double d8 = (float)polarizationAnalysis.getpIncidence();
                    double d9 = polarizationAnalysis.getRectilinearity();
                    double d10 = polarizationAnalysis.getPlanarity();
                    dArray[i][n / this.step] = d8;
                    dArray2[i][n / this.step] = d9;
                    dArray3[i][n / this.step] = d10;
                    if (d9 < d) {
                        d = d9;
                    }
                    if (d10 < d2) {
                        d2 = d10;
                    }
                    if (dArray[i][n / this.step] < d3) {
                        d3 = dArray[i][n / this.step];
                    }
                    if (d9 > d4) {
                        d4 = d9;
                    }
                    if (d10 > d5) {
                        d5 = d10;
                    }
                    if (!(dArray[i][n / this.step] > d6)) continue;
                    d6 = dArray[i][n / this.step];
                }
            }
            for (n = 0; n < dArray2.length; ++n) {
                for (int i = 0; i < dArray2[n].length; ++i) {
                    dArray2[n][i] = MathUtil.convertFromTo((double)dArray2[n][i], (double)0.0, (double)d4, (double)0.0, (double)this.sonoMax);
                    dArray3[n][i] = MathUtil.convertFromTo((double)dArray3[n][i], (double)0.0, (double)d5, (double)0.0, (double)this.sonoMax);
                    dArray[n][i] = MathUtil.convertFromTo((double)dArray[n][i], (double)0.0, (double)d6, (double)0.0, (double)this.sonoMax);
                }
            }
            this.incidenceTrace.setValues(dArray);
            this.rectiTrace.setValues(dArray2);
            this.planaTrace.setValues(dArray3);
            this.azimuthTrace.setValues(fArray4[3]);
        } else {
            this.incidenceTrace.setValues(new int[10][10]);
            this.rectiTrace.setValues(new int[10][10]);
            this.planaTrace.setValues(new int[10][10]);
            this.azimuthTrace.setValues(new float[10]);
        }
    }

    @Deprecated
    public float[] rotateToRadialAndTransverse(double d, float[] fArray, float[] fArray2, boolean bl) {
        double d2 = Math.cos(d);
        double d3 = Math.sin(d);
        float[] fArray3 = new float[fArray.length];
        float[] fArray4 = new float[fArray.length];
        for (int i = 0; i < fArray.length; ++i) {
            if (bl) {
                fArray3[i] = (float)(d2 * (double)fArray[i] + d3 * (double)fArray2[i]);
                continue;
            }
            fArray4[i] = (float)(-d3 * (double)fArray[i] + d2 * (double)fArray2[i]);
        }
        if (bl) {
            return fArray3;
        }
        return fArray4;
    }

    public AzimuthTraceComponent getAzimuthTrace() {
        return this.azimuthTrace;
    }

    public SingleSonoPaint getIncidenceTrace() {
        return this.incidenceTrace;
    }

    public SingleSonoPaint getRectiTrace() {
        return this.rectiTrace;
    }

    public SingleSonoPaint getPlanaTrace() {
        return this.planaTrace;
    }
}

