/*
 * Decompiled with CFR 0.152.
 */
package edu.geophys.hypoline.ui.vertical;

import edu.geophys.commons.model.knowledgebase.LayerKnowledge;
import edu.geophys.commons.model.layer.Layer;
import edu.geophys.commons.model.layer.LayerModel;
import edu.geophys.commons.suite.SuiteManager;
import edu.geophys.commons.util.LogUtil;
import edu.geophys.hypoline.HypoLineManager;
import edu.geophys.hypoline.sitecollection.SiteCollectionModel;
import edu.geophys.hypoline.ui.vertical.LayerTableModel;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.table.AbstractTableModel;

public class LayerModelController {
    private final LayerTableModel layersTM = new LayerTableModel();
    private final LayerModelsTM layerModelsTM = new LayerModelsTM();
    private LayerModel currentLayerModel = null;
    public final Action deleteLayerModel = new AbstractAction("Remove selected layer model"){
        private static final long serialVersionUID = 1L;

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            LogUtil.error(this.getClass(), (String)("Unimplemented Action: " + this.toString()), (boolean)true);
        }
    };
    public final Action reloadLayerModels = new AbstractAction("Remove selected layer model"){
        private static final long serialVersionUID = 1L;

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            LogUtil.error(this.getClass(), (String)("Unimplemented Action: " + this.toString()), (boolean)true);
        }
    };

    public LayerModelsTM getLayerModelsTM() {
        return this.layerModelsTM;
    }

    public LayerTableModel getLayersTM() {
        return this.layersTM;
    }

    public LayerModel getCurrentLayerModel() {
        return this.currentLayerModel;
    }

    public void setCurrentLayerModel(LayerModel layerModel) {
        this.currentLayerModel = layerModel;
        HypoLineManager.INSTANCE.getConfig().setLayerModelName(layerModel.getName());
        HypoLineManager.INSTANCE.onUpdateLayerModel();
    }

    public void setCurrentLayerModel(int n) {
        int n2;
        if (n < 0) {
            return;
        }
        LayerKnowledge layerKnowledge = SuiteManager.INSTANCE.getKnowledgebase().getLayerKnowledge();
        int n3 = n2 = n == 0 ? 9 : n - 1;
        if (n2 >= layerKnowledge.getLayerModels().size()) {
            return;
        }
        this.setCurrentLayerModel((LayerModel)layerKnowledge.getLayerModels().get(n2));
    }

    public String getCurrentLayerModelHotkey() {
        ArrayList arrayList = SuiteManager.INSTANCE.getKnowledgebase().getLayerKnowledge().getLayerModels();
        for (int i = 0; i < arrayList.size(); ++i) {
            if (i > 9) {
                return "";
            }
            if (arrayList.get(i) != this.currentLayerModel) continue;
            return "" + (i == 9 ? 0 : i + 1);
        }
        return "";
    }

    public void setCurrentLayerModel(String string) {
        LayerKnowledge layerKnowledge = SuiteManager.INSTANCE.getKnowledgebase().getLayerKnowledge();
        for (LayerModel layerModel : layerKnowledge.getLayerModels()) {
            if (!string.equalsIgnoreCase(layerModel.getName())) continue;
            this.setCurrentLayerModel(layerModel);
            return;
        }
        LayerModel layerModel = (LayerModel)layerKnowledge.getLayerModels().get(0);
        if (!string.isEmpty()) {
            LogUtil.warn(this.getClass(), (String)("Layer model \"" + string + "\" unknown. Using model \"" + layerModel.getName() + "\"."), (boolean)true);
        }
        this.setCurrentLayerModel(layerModel);
    }

    public void onModification() {
        this.currentLayerModel.checkValid();
        if (!this.currentLayerModel.isValid()) {
            LogUtil.error(this.getClass(), (String)("Invalid LayerModel:\n" + String.join((CharSequence)"\n", this.currentLayerModel.getProblems())), (boolean)true);
        }
        this.currentLayerModel.setModified(true);
        HypoLineManager.INSTANCE.onUpdateLayerModel();
    }

    public static boolean doubleEqual(double d, double d2) {
        if (Double.isNaN(d) && Double.isNaN(d2)) {
            return true;
        }
        return Math.abs(d - d2) < 1.0E-12;
    }

    public double getCorrectedFirstLayerThickness() {
        Layer layer = (Layer)this.currentLayerModel.getLayers().get(0);
        if (layer.getD() <= 0.0) {
            return layer.getD();
        }
        double d = this.currentLayerModel.getZeroElevation();
        if (Double.isNaN(d)) {
            return layer.getD();
        }
        SiteCollectionModel siteCollectionModel = HypoLineManager.INSTANCE.getSiteCollectionModel();
        double d2 = siteCollectionModel.getHighestZClassElevationKm();
        if (d2 < d) {
            return layer.getD();
        }
        double d3 = d2 - d;
        return layer.getD() + d3;
    }

    public double getCorrectedZeroElevation() {
        SiteCollectionModel siteCollectionModel = HypoLineManager.INSTANCE.getSiteCollectionModel();
        double d = siteCollectionModel.getHighestZClassElevationKm();
        double d2 = this.currentLayerModel.getZeroElevation();
        if (Double.isNaN(d2) || d2 < d) {
            return d;
        }
        return d2;
    }

    public double getRawZeroElevation() {
        if (this.currentLayerModel.hasZeroElevation()) {
            return this.currentLayerModel.getZeroElevation();
        }
        SiteCollectionModel siteCollectionModel = HypoLineManager.INSTANCE.getSiteCollectionModel();
        return siteCollectionModel.getHighestZClassElevationKm();
    }

    public class LayerModelsTM
    extends AbstractTableModel {
        private static final long serialVersionUID = 1L;
        private static final String[] COLUMN_NAMES = new String[]{"Key", "Mod.", "Name", "Comment"};

        @Override
        public String getColumnName(int n) {
            return COLUMN_NAMES[n];
        }

        @Override
        public int getRowCount() {
            SuiteManager.INSTANCE.getKnowledgebase().getLayerKnowledge();
            return SuiteManager.INSTANCE.getKnowledgebase().getLayerKnowledge().getLayerModels().size();
        }

        @Override
        public int getColumnCount() {
            return COLUMN_NAMES.length;
        }

        public void updateNewRows() {
            this.fireTableDataChanged();
        }

        @Override
        public Object getValueAt(int n, int n2) {
            LayerModel layerModel = (LayerModel)SuiteManager.INSTANCE.getKnowledgebase().getLayerKnowledge().getLayerModels().get(n);
            switch (n2) {
                case 0: {
                    return n < 9 ? "" + (n + 1) : "";
                }
                case 1: {
                    return layerModel.isModified() ? "\u2732" : "";
                }
                case 2: {
                    return layerModel.getName();
                }
                case 3: {
                    return layerModel.getDescription();
                }
            }
            return null;
        }
    }
}

