/*
 * Decompiled with CFR 0.152.
 */
package edu.geophys.hypoline.ui.vertical;

import edu.geophys.commons.model.layer.LayerModel;
import edu.geophys.hypoline.HypoLineManager;
import edu.geophys.hypoline.ui.vertical.ButtonColumn;
import edu.geophys.hypoline.ui.vertical.LayerModelController;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.border.Border;

public class LayerModelEditor
extends JComponent {
    private static final long serialVersionUID = 1L;
    private static final Border ELEMENT_BORDER = BorderFactory.createTitledBorder("Layer Model Editor:");
    private static final String NO_ZERO_ELEVATION = "Use highest station elevation";
    private static final int CHECKMARK_WIDTH = 30;
    private static final int BUTTON_WIDTH = 25;
    private JTable lTable = null;
    private JTextField nameField = new JTextField();
    private JTextField descriptionField = new JTextField();
    private JTextField vp2vsField = new JTextField();
    private JTextField zeroElevationField = new JTextField();
    private JTextField filenameField = new JTextField();
    private JTextField modifiedField = new JTextField();
    private JButton zeroElevationReset = new JButton("Use highest station elevation");
    private int gridY = 0;
    Action delete = new AbstractAction("-"){
        private static final long serialVersionUID = 1L;

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            LayerModelController layerModelController = HypoLineManager.INSTANCE.getLayerModelController();
            int n = Integer.valueOf(actionEvent.getActionCommand());
            boolean bl = layerModelController.getCurrentLayerModel().uiRemoveLayer(n);
            if (bl) {
                layerModelController.onModification();
            }
        }
    };
    Action insert = new AbstractAction("+"){
        private static final long serialVersionUID = 1L;

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            LayerModelController layerModelController = HypoLineManager.INSTANCE.getLayerModelController();
            int n = Integer.valueOf(actionEvent.getActionCommand());
            boolean bl = layerModelController.getCurrentLayerModel().uiInsertLayer(n);
            if (bl) {
                layerModelController.onModification();
            }
        }
    };

    public LayerModelEditor() {
        this.initComponents();
        this.addComponentsListeners();
        this.updateComponents();
    }

    private void addComponentsListeners() {
        final LayerModelController layerModelController = HypoLineManager.INSTANCE.getLayerModelController();
        this.nameField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent focusEvent) {
                String string = ((JTextField)focusEvent.getSource()).getText();
                if (string.equals(layerModelController.getCurrentLayerModel().getName())) {
                    return;
                }
                layerModelController.getCurrentLayerModel().setName(string);
                layerModelController.onModification();
            }
        });
        this.descriptionField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent focusEvent) {
                String string = ((JTextField)focusEvent.getSource()).getText();
                if (string.equals(layerModelController.getCurrentLayerModel().getDescription())) {
                    return;
                }
                layerModelController.getCurrentLayerModel().setDescription(string);
                layerModelController.onModification();
            }
        });
        this.vp2vsField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent focusEvent) {
                String string = ((JTextField)focusEvent.getSource()).getText();
                try {
                    double d = Double.parseDouble(string);
                    if (LayerModelController.doubleEqual(d, layerModelController.getCurrentLayerModel().getVp2vs())) {
                        return;
                    }
                    layerModelController.getCurrentLayerModel().setVp2vs(d);
                    layerModelController.onModification();
                }
                catch (NumberFormatException numberFormatException) {
                    JOptionPane.showMessageDialog(LayerModelEditor.this, "'" + string + "' is not a valid number!", "Input error", 0);
                    return;
                }
            }
        });
        this.zeroElevationField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent focusEvent) {
                String string = ((JTextField)focusEvent.getSource()).getText();
                if (string.strip().equalsIgnoreCase(LayerModelEditor.NO_ZERO_ELEVATION)) {
                    if (!layerModelController.getCurrentLayerModel().hasZeroElevation()) {
                        return;
                    }
                    layerModelController.getCurrentLayerModel().setZeroElevation(Double.NaN);
                    layerModelController.onModification();
                    return;
                }
                try {
                    double d = Double.parseDouble(string);
                    if (LayerModelController.doubleEqual(d, layerModelController.getCurrentLayerModel().getZeroElevation())) {
                        return;
                    }
                    layerModelController.getCurrentLayerModel().setZeroElevation(d);
                    layerModelController.onModification();
                    return;
                }
                catch (NumberFormatException numberFormatException) {
                    JOptionPane.showMessageDialog(LayerModelEditor.this, "'" + string + "' is not a valid number!", "Input error", 0);
                    return;
                }
            }
        });
        this.zeroElevationReset.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (!layerModelController.getCurrentLayerModel().hasZeroElevation()) {
                    return;
                }
                layerModelController.getCurrentLayerModel().setZeroElevation(Double.NaN);
                layerModelController.onModification();
            }
        });
    }

    private void updateComponents() {
        LayerModel layerModel = HypoLineManager.INSTANCE.getLayerModelController().getCurrentLayerModel();
        this.lTable.repaint();
        this.nameField.setText(layerModel.getName());
        this.descriptionField.setText(layerModel.getDescription());
        this.vp2vsField.setText("" + layerModel.getVp2vs());
        this.zeroElevationField.setText((String)(Double.isNaN(layerModel.getZeroElevation()) ? NO_ZERO_ELEVATION : "" + layerModel.getZeroElevation()));
        this.modifiedField.setText(layerModel.isModified() ? "Yes" : "No");
        if (layerModel.getFile() == null) {
            this.filenameField.setText("<undefined>");
        } else {
            this.filenameField.setText(layerModel.getFile().getPath());
        }
        this.zeroElevationReset.setEnabled(layerModel.hasZeroElevation());
        new ButtonColumn(this.lTable, this.insert, 4);
        new ButtonColumn(this.lTable, this.delete, 5);
    }

    private void initComponents() {
        this.filenameField.setEditable(false);
        this.modifiedField.setEditable(false);
        LayerModelController layerModelController = HypoLineManager.INSTANCE.getLayerModelController();
        this.setBorder(ELEMENT_BORDER);
        this.setLayout(new GridBagLayout());
        this.addTextEntryRow("Name:", this.nameField, "");
        this.addTextEntryRow("Description:", this.descriptionField, "");
        this.addTextEntryRow("File:", this.filenameField, "");
        this.addTextEntryRow("vP/vS Ratio:", this.vp2vsField, "");
        this.addTextEntryRow("Surface Elevation:", this.zeroElevationField, "km");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = this.gridY++;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        this.add((Component)this.zeroElevationReset, gridBagConstraints);
        this.lTable = new JTable(layerModelController.getLayersTM());
        this.lTable.setCellSelectionEnabled(true);
        this.lTable.setRowSelectionAllowed(false);
        this.lTable.setColumnSelectionAllowed(false);
        this.lTable.setSelectionMode(0);
        this.lTable.setFillsViewportHeight(true);
        this.lTable.getColumnModel().getColumn(2).setMinWidth(30);
        this.lTable.getColumnModel().getColumn(2).setMaxWidth(30);
        this.lTable.getColumnModel().getColumn(3).setMinWidth(30);
        this.lTable.getColumnModel().getColumn(3).setMaxWidth(30);
        this.lTable.getColumnModel().getColumn(4).setMinWidth(25);
        this.lTable.getColumnModel().getColumn(4).setMaxWidth(25);
        this.lTable.getColumnModel().getColumn(5).setMinWidth(25);
        this.lTable.getColumnModel().getColumn(5).setMaxWidth(25);
        this.lTable.setPreferredScrollableViewportSize(this.lTable.getPreferredSize());
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = this.gridY++;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(5, 2, 2, 2);
        this.add((Component)new JScrollPane(this.lTable), gridBagConstraints);
    }

    private void addTextEntryRow(String string, JComponent jComponent, String string2) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        this.add((Component)new JLabel(string), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)jComponent, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 0.0;
        this.add((Component)new JLabel(string2), gridBagConstraints);
        ++this.gridY;
    }

    public void updateLayerModel() {
        this.updateComponents();
    }
}

