/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.TauP;

import edu.sc.seis.TauP.Alert;
import edu.sc.seis.TauP.Outputs;
import edu.sc.seis.TauP.SeismicPhase;
import edu.sc.seis.TauP.TauModelException;
import edu.sc.seis.TauP.TauPException;
import edu.sc.seis.TauP.TauP_Time;
import edu.sc.seis.TauP.TauP_Tool;
import edu.sc.seis.TauP.ToolRun;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.List;

public class TauP_PhaseDescribe
extends TauP_Time {
    @Override
    public void printStdUsage() {
        TauP_Tool.printStdUsageHead(this.arrivals.getClass());
        Alert.info("-ph phase list     -- comma separated phase list\n-pf phasefile      -- file containing phases\n\n-mod[el] modelname -- use velocity model \"modelname\" for calculations\n                      Default is iasp91.\n\n-h depth           -- source depth in km\n\n--stadepth depth   -- receiver depth in km\n\n");
    }

    @Override
    public void printUsage() {
        this.printStdUsage();
        TauP_PhaseDescribe.printStdUsageTail();
    }

    @Override
    protected String[] parseCmdLineArgs(String[] origArgs) throws IOException {
        String[] args = ToolRun.parseCommonCmdLineArgs(origArgs);
        String[] noComprendoArgs = new String[args.length];
        int numNoComprendoArgs = 0;
        boolean cmdLineArgPhase = false;
        boolean cmdLineArgPhaseFile = false;
        for (int i = 0; i < args.length; ++i) {
            if (TauP_PhaseDescribe.dashEquals("help", args[i])) {
                this.printUsage();
                noComprendoArgs[numNoComprendoArgs++] = args[i];
                continue;
            }
            if (TauP_PhaseDescribe.dashEquals("expert", args[i])) {
                expert = true;
                continue;
            }
            if (i < args.length - 1) {
                if (TauP_PhaseDescribe.dashEquals("mod", args[i]) || TauP_PhaseDescribe.dashEquals("model", args[i])) {
                    this.toolProps.put("taup.model.name", args[i + 1]);
                    ++i;
                    continue;
                }
                if (args[i].equalsIgnoreCase("-h")) {
                    this.toolProps.put("taup.source.depth", args[i + 1]);
                    ++i;
                    continue;
                }
                if (args[i].equalsIgnoreCase("--stadepth")) {
                    this.setReceiverDepth(Double.parseDouble(args[i + 1]));
                    ++i;
                    continue;
                }
                if (args[i].equalsIgnoreCase("-o")) {
                    this.outFileBase = args[i + 1];
                    ++i;
                    continue;
                }
                if (TauP_PhaseDescribe.dashEquals("ph", args[i])) {
                    if (cmdLineArgPhase) {
                        this.toolProps.put("taup.phase.list", this.toolProps.getProperty("taup.phase.list", "") + "," + args[i + 1]);
                    } else {
                        this.toolProps.put("taup.phase.list", args[i + 1]);
                    }
                    cmdLineArgPhase = true;
                    ++i;
                    continue;
                }
                if (TauP_PhaseDescribe.dashEquals("pf", args[i])) {
                    cmdLineArgPhaseFile = true;
                    this.toolProps.put("taup.phase.file", args[i + 1]);
                    ++i;
                    continue;
                }
                if (TauP_PhaseDescribe.dashEquals("prop", args[i])) {
                    File f = new File(args[i + 1]);
                    if (!f.exists()) {
                        throw new FileNotFoundException(args[i + 1]);
                    }
                    BufferedReader r = new BufferedReader(new FileReader(args[i + 1]));
                    this.toolProps.load(r);
                    Outputs.configure(this.toolProps);
                    ++i;
                    continue;
                }
                if (i < args.length - 2) {
                    if (args[i].contains("set") && args[i + 1].startsWith("taup.")) {
                        this.toolProps.setProperty(args[i + 1], args[i + 2]);
                        Outputs.configure(this.toolProps);
                        i += 2;
                        continue;
                    }
                    noComprendoArgs[numNoComprendoArgs++] = args[i];
                    continue;
                }
                noComprendoArgs[numNoComprendoArgs++] = args[i];
                continue;
            }
            noComprendoArgs[numNoComprendoArgs++] = args[i];
        }
        if (cmdLineArgPhaseFile || cmdLineArgPhase) {
            if (cmdLineArgPhaseFile && !cmdLineArgPhase) {
                this.toolProps.remove("taup.phase.list");
            }
            if (!cmdLineArgPhaseFile && cmdLineArgPhase) {
                this.toolProps.remove("taup.phase.file");
            }
        }
        if (numNoComprendoArgs > 0) {
            String[] temp = new String[numNoComprendoArgs];
            System.arraycopy(noComprendoArgs, 0, temp, 0, numNoComprendoArgs);
            return temp;
        }
        return new String[0];
    }

    @Override
    public void start() throws IOException, TauModelException, TauPException {
        this.depthCorrect(this.getSourceDepth(), this.getReceiverDepth());
        this.printResult(this.getWriter());
    }

    @Override
    public void printResult(PrintWriter writer) {
        List<SeismicPhase> phaseList = this.getSeismicPhases();
        for (SeismicPhase phase : phaseList) {
            writer.println(phase.describe());
            writer.println("--------");
        }
    }
}

